/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;

public class BinomialDistributionEx
extends BaseRandomOp {
    private long trials;
    private double probability;

    public BinomialDistributionEx() {
    }

    public BinomialDistributionEx(@NonNull INDArray z, long trials, double probability) {
        super(z, z, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        this.trials = trials;
        this.probability = probability;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistributionEx(@NonNull INDArray z, long trials, @NonNull INDArray probabilities) {
        super(z, probabilities, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked non-null but is null");
        }
        if (z.length() != probabilities.length()) {
            throw new IllegalStateException("Length of probabilities array should match length of target array");
        }
        if (probabilities.elementWiseStride() < 1) {
            throw new IllegalStateException("Probabilities array shouldn't have negative elementWiseStride");
        }
        Preconditions.checkArgument((probabilities.dataType() == z.dataType() ? 1 : 0) != 0, (String)"Probabilities and Z operand should have same data type");
        this.trials = trials;
        this.probability = 0.0;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistributionEx(@NonNull INDArray z, @NonNull INDArray probabilities) {
        this(z, probabilities.length(), probabilities);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked non-null but is null");
        }
    }

    @Override
    public int opNum() {
        return 9;
    }

    @Override
    public String opName() {
        return "distribution_binomial_ex";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("BinomialDistributionEx does not have a derivative.");
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        return this.calculateOutputShape();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        LongShapeDescriptor longShapeDescriptor = LongShapeDescriptor.fromShape(this.shape, this.dataType);
        return Arrays.asList(longShapeDescriptor);
    }
}

