/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape.bp;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StridedSliceBp
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(StridedSliceBp.class);
    private long[] begin;
    private long[] end;
    private long[] strides;
    private int beginMask;
    private int endMask;
    private int ellipsisMask;
    private int newAxisMask;
    private int shrinkAxisMask;

    public StridedSliceBp() {
    }

    public StridedSliceBp(SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable grad, @NonNull long[] begin, @NonNull long[] end, @NonNull long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        super(null, sameDiff, new SDVariable[]{in, grad});
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (grad == null) {
            throw new NullPointerException("grad is marked non-null but is null");
        }
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked non-null but is null");
        }
        this.begin = begin;
        this.end = end;
        this.strides = strides;
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    public StridedSliceBp(SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable grad, @NonNull SDVariable begin, @NonNull SDVariable end, @NonNull SDVariable strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        super(null, sameDiff, new SDVariable[]{in, grad, begin, end, strides});
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (grad == null) {
            throw new NullPointerException("grad is marked non-null but is null");
        }
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked non-null but is null");
        }
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    private void addArguments() {
        this.addIArgument(this.beginMask);
        this.addIArgument(this.ellipsisMask);
        this.addIArgument(this.endMask);
        this.addIArgument(this.newAxisMask);
        this.addIArgument(this.shrinkAxisMask);
        if (this.begin != null) {
            this.addIArgument(this.begin);
            this.addIArgument(this.end);
            this.addIArgument(this.strides);
        }
    }

    @Override
    public String opName() {
        return "strided_slice_bp";
    }

    @Override
    public void assertValidForExecution() {
        if (this.numInputArguments() != 2 && this.numInputArguments() != 4) {
            throw new ND4JIllegalStateException("Num input arguments must be 2 or 4.");
        }
        if (this.numIArguments() < 5) {
            throw new ND4JIllegalStateException("Number of integer arguments must >= 5");
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        throw new UnsupportedOperationException("Differentation not supported for backprop function: " + this.getClass().getSimpleName());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes.size() == 2 || dataTypes.size() == 5 ? 1 : 0) != 0, (String)"Expected list with exactly 2 or 5 datatypes for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(this.arg().dataType());
    }
}

