/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.shape.bp.SliceBp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slice
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Slice.class);
    private int[] begin;
    private int[] size;

    public Slice() {
    }

    public Slice(SameDiff sameDiff, @NonNull SDVariable input, @NonNull int[] begin, @NonNull int[] size) {
        super(null, sameDiff, new SDVariable[]{input});
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        this.begin = begin;
        this.size = size;
        this.addIArgument(begin);
        this.addIArgument(size);
    }

    public Slice(SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable begin, @NonNull SDVariable end) {
        super(null, sameDiff, new SDVariable[]{input, begin, end});
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
    }

    public Slice(INDArray input, int[] begin, int ... size) {
        super(new INDArray[]{input}, null);
        this.begin = begin;
        this.size = size;
        this.addIArgument(begin);
        this.addIArgument(size);
    }

    public Slice(@NonNull INDArray input, @NonNull INDArray begin, @NonNull INDArray end) {
        super(new INDArray[]{input, begin, end}, null);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
    }

    @Override
    public String opName() {
        return "slice";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Slice";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        if (this.args().length == 1) {
            return new SliceBp(this.sameDiff, this.arg(), grad.get(0), this.begin, this.size).outputs();
        }
        return new SliceBp(this.sameDiff, this.arg(0), grad.get(0), this.arg(1), this.arg(2)).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((boolean)(dataTypes != null & (dataTypes.size() == 1 || dataTypes.size() == 3)), (String)"Expected list with 1 or 3 datatypes for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

