/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce.custom;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.reduce.bp.SumBp;

public class LogSumExp
extends DynamicCustomOp {
    protected boolean keepDims;

    public LogSumExp(SameDiff sameDiff, SDVariable i_v, boolean keepDims, int[] dimensions) {
        super(sameDiff, i_v);
        if (dimensions != null) {
            this.addIArgument(dimensions);
            this.dimensions = dimensions;
        }
        this.addTArgument(keepDims ? 1.0 : 0.0);
        this.keepDims = keepDims;
    }

    public LogSumExp(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        this(sameDiff, i_v, false, dimensions);
    }

    public LogSumExp() {
    }

    public LogSumExp(INDArray x, int ... dimensions) {
        this(x, false, dimensions);
    }

    public LogSumExp(INDArray x, boolean keepDim, int ... dimensions) {
        this(x, null, keepDim, dimensions);
    }

    public LogSumExp(INDArray x, INDArray z, boolean keepDim, int ... dimensions) {
        super(null, x, z, Collections.singletonList(keepDim ? 1.0 : 0.0), dimensions);
    }

    @Override
    public String opName() {
        return "reduce_logsumexp";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable exp = this.sameDiff.math.exp(this.arg());
        SDVariable sumExp = exp.sum(this.dimensions);
        SDVariable gradProd = f1.get(0).div(sumExp);
        SDVariable dSumExpdx = new SumBp(this.sameDiff, this.arg(), gradProd, this.keepDims, this.dimensions).outputVariable().mul(exp);
        return Collections.singletonList(dSumExpdx);
    }

    @Override
    public String onnxName() {
        return "ReduceLogSumExp";
    }
}

