/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.weights;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.RNNWeights;

public class SRUWeights
extends RNNWeights {
    private SDVariable weights;
    private INDArray iWeights;
    private SDVariable bias;
    private INDArray iBias;

    @Override
    public SDVariable[] args() {
        return new SDVariable[]{this.weights, this.bias};
    }

    @Override
    public INDArray[] arrayArgs() {
        return new INDArray[]{this.iWeights, this.iBias};
    }

    SRUWeights(SDVariable weights, INDArray iWeights, SDVariable bias, INDArray iBias) {
        this.weights = weights;
        this.iWeights = iWeights;
        this.bias = bias;
        this.iBias = iBias;
    }

    public static SRUWeightsBuilder builder() {
        return new SRUWeightsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SRUWeights)) {
            return false;
        }
        SRUWeights other = (SRUWeights)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SDVariable this$weights = this.getWeights();
        SDVariable other$weights = other.getWeights();
        if (this$weights == null ? other$weights != null : !((Object)this$weights).equals(other$weights)) {
            return false;
        }
        INDArray this$iWeights = this.getIWeights();
        INDArray other$iWeights = other.getIWeights();
        if (this$iWeights == null ? other$iWeights != null : !this$iWeights.equals(other$iWeights)) {
            return false;
        }
        SDVariable this$bias = this.getBias();
        SDVariable other$bias = other.getBias();
        if (this$bias == null ? other$bias != null : !((Object)this$bias).equals(other$bias)) {
            return false;
        }
        INDArray this$iBias = this.getIBias();
        INDArray other$iBias = other.getIBias();
        return !(this$iBias == null ? other$iBias != null : !this$iBias.equals(other$iBias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SRUWeights;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SDVariable $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : ((Object)$weights).hashCode());
        INDArray $iWeights = this.getIWeights();
        result = result * 59 + ($iWeights == null ? 43 : $iWeights.hashCode());
        SDVariable $bias = this.getBias();
        result = result * 59 + ($bias == null ? 43 : ((Object)$bias).hashCode());
        INDArray $iBias = this.getIBias();
        result = result * 59 + ($iBias == null ? 43 : $iBias.hashCode());
        return result;
    }

    public SDVariable getWeights() {
        return this.weights;
    }

    public INDArray getIWeights() {
        return this.iWeights;
    }

    public SDVariable getBias() {
        return this.bias;
    }

    public INDArray getIBias() {
        return this.iBias;
    }

    public void setWeights(SDVariable weights) {
        this.weights = weights;
    }

    public void setIWeights(INDArray iWeights) {
        this.iWeights = iWeights;
    }

    public void setBias(SDVariable bias) {
        this.bias = bias;
    }

    public void setIBias(INDArray iBias) {
        this.iBias = iBias;
    }

    public String toString() {
        return "SRUWeights(weights=" + this.getWeights() + ", iWeights=" + this.getIWeights() + ", bias=" + this.getBias() + ", iBias=" + this.getIBias() + ")";
    }

    public static class SRUWeightsBuilder {
        private SDVariable weights;
        private INDArray iWeights;
        private SDVariable bias;
        private INDArray iBias;

        SRUWeightsBuilder() {
        }

        public SRUWeightsBuilder weights(SDVariable weights) {
            this.weights = weights;
            return this;
        }

        public SRUWeightsBuilder iWeights(INDArray iWeights) {
            this.iWeights = iWeights;
            return this;
        }

        public SRUWeightsBuilder bias(SDVariable bias) {
            this.bias = bias;
            return this;
        }

        public SRUWeightsBuilder iBias(INDArray iBias) {
            this.iBias = iBias;
            return this;
        }

        public SRUWeights build() {
            return new SRUWeights(this.weights, this.iWeights, this.bias, this.iBias);
        }

        public String toString() {
            return "SRUWeights.SRUWeightsBuilder(weights=" + this.weights + ", iWeights=" + this.iWeights + ", bias=" + this.bias + ", iBias=" + this.iBias + ")";
        }
    }
}

