/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.indexaccum;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseIndexAccumulation;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;

public class LastIndex
extends BaseIndexAccumulation {
    protected Condition condition;
    protected double compare;
    protected double eps;
    protected int mode;

    public LastIndex(SameDiff sameDiff, SDVariable i_v, boolean keepDims, Condition condition, int ... dimensions) {
        this(sameDiff, i_v, condition, keepDims, dimensions);
    }

    public LastIndex(SameDiff sameDiff, SDVariable i_v, Condition condition, boolean keepDims, int ... dimensions) {
        super(sameDiff, i_v, keepDims, dimensions);
        this.condition = condition;
        this.compare = condition.getValue();
        this.mode = condition.condtionNum();
        this.eps = Nd4j.EPS_THRESHOLD;
        this.extraArgs = new Object[]{this.compare, this.eps, (double)this.mode};
    }

    public LastIndex(SameDiff sameDiff, SDVariable x, @NonNull Condition condition, int ... dimensions) {
        super(sameDiff, x, false, dimensions);
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        this.condition = condition;
    }

    public LastIndex(INDArray x, @NonNull Condition condition, int ... dimensions) {
        this(x, condition, Nd4j.EPS_THRESHOLD, dimensions);
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
    }

    public LastIndex(INDArray in, boolean keepDim, Condition condition, int ... dimensions) {
        this(in, condition, keepDim, dimensions);
    }

    public LastIndex(INDArray x, @NonNull Condition condition, boolean keepDim, int ... dimensions) {
        this(x, condition, Nd4j.EPS_THRESHOLD, dimensions);
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        this.keepDims = keepDim;
    }

    public LastIndex(INDArray x, @NonNull Condition condition, double eps, int ... dimensions) {
        super(x, null, dimensions);
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        this.condition = condition;
        this.compare = condition.getValue();
        this.mode = condition.condtionNum();
        this.eps = eps;
        this.extraArgs = new Object[]{this.compare, eps, (double)this.mode};
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("compare", this.compare);
        ret.put("eps", this.eps);
        ret.put("mode", this.mode);
        return ret;
    }

    @Override
    public int opNum() {
        return 5;
    }

    @Override
    public String opName() {
        return "last_index";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }

    public Condition getCondition() {
        return this.condition;
    }

    public double getCompare() {
        return this.compare;
    }

    public double getEps() {
        return this.eps;
    }

    public int getMode() {
        return this.mode;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setCompare(double compare) {
        this.compare = compare;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LastIndex)) {
            return false;
        }
        LastIndex other = (LastIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getCompare(), other.getCompare()) != 0) {
            return false;
        }
        if (Double.compare(this.getEps(), other.getEps()) != 0) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        Condition this$condition = this.getCondition();
        Condition other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LastIndex;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $compare = Double.doubleToLongBits(this.getCompare());
        result = result * 59 + (int)($compare >>> 32 ^ $compare);
        long $eps = Double.doubleToLongBits(this.getEps());
        result = result * 59 + (int)($eps >>> 32 ^ $eps);
        result = result * 59 + this.getMode();
        Condition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "LastIndex(condition=" + this.getCondition() + ", compare=" + this.getCompare() + ", eps=" + this.getEps() + ", mode=" + this.getMode() + ")";
    }

    public LastIndex() {
    }
}

