/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.grid;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.GridOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.grid.GridDescriptor;
import org.nd4j.linalg.api.ops.grid.GridPointers;
import org.nd4j.linalg.api.ops.grid.OpDescriptor;

public abstract class BaseGridOp
extends BaseOp
implements GridOp {
    protected List<OpDescriptor> queuedOps = new ArrayList<OpDescriptor>();
    protected List<GridPointers> grid = new ArrayList<GridPointers>();

    public BaseGridOp() {
    }

    public BaseGridOp(INDArray x, INDArray y) {
    }

    protected BaseGridOp(Op ... ops) {
        this.grid = new ArrayList<GridPointers>(ops.length);
        for (Op op : ops) {
            this.queuedOps.add(new OpDescriptor(op, null));
            this.grid.add(null);
        }
    }

    protected BaseGridOp(OpDescriptor ... descriptors) {
        for (OpDescriptor op : descriptors) {
            this.queuedOps.add(op);
            this.grid.add(null);
        }
    }

    protected BaseGridOp(GridPointers ... pointers) {
        for (GridPointers ptr : pointers) {
            this.grid.add(ptr);
        }
    }

    protected BaseGridOp(List<Op> ops) {
        this(ops.toArray(new Op[0]));
    }

    @Override
    public GridDescriptor getGridDescriptor() {
        GridDescriptor descriptor = new GridDescriptor();
        descriptor.setGridDepth(this.grid.size());
        descriptor.setGridPointers(this.grid);
        return descriptor;
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }
}

