/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class Lstsq
extends DynamicCustomOp {
    public Lstsq(@NonNull INDArray matrix, @NonNull INDArray rhs, double l2_regularizer, boolean fast) {
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        if (rhs == null) {
            throw new NullPointerException("rhs is marked non-null but is null");
        }
        this.addInputArgument(matrix, rhs);
        this.addTArgument(l2_regularizer);
        this.addBArgument(fast);
    }

    public Lstsq(@NonNull INDArray matrix, @NonNull INDArray rhs) {
        this(matrix, rhs, 0.0, true);
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        if (rhs == null) {
            throw new NullPointerException("rhs is marked non-null but is null");
        }
    }

    public Lstsq(@NonNull SameDiff sameDiff, @NonNull SDVariable matrix, @NonNull SDVariable rhs, double l2_regularizer, boolean fast) {
        super(sameDiff, new SDVariable[]{matrix, rhs});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        if (rhs == null) {
            throw new NullPointerException("rhs is marked non-null but is null");
        }
        this.addTArgument(l2_regularizer);
        this.addBArgument(fast);
    }

    @Override
    public String opName() {
        return "lstsq";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public Lstsq() {
    }
}

