/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.iter;

import java.util.Iterator;
import org.nd4j.common.util.ArrayUtil;

public class FlatIterator
implements Iterator<int[]> {
    private int[] shape;
    private int runningDimension;
    private int[] currentCoord;
    private int length;
    private int current = 0;

    public FlatIterator(int[] shape) {
        this.shape = shape;
        this.currentCoord = new int[shape.length];
        this.length = ArrayUtil.prod((int[])shape);
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean hasNext() {
        return this.current < this.length;
    }

    @Override
    public int[] next() {
        if (this.currentCoord[this.runningDimension] == this.shape[this.runningDimension]) {
            --this.runningDimension;
            this.currentCoord[this.runningDimension] = 0;
            if (this.runningDimension < this.shape.length) {
                // empty if block
            }
        } else {
            int n = this.runningDimension;
            this.currentCoord[n] = this.currentCoord[n] + 1;
        }
        ++this.current;
        return this.currentCoord;
    }
}

