/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.environment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.nd4j.linalg.factory.Nd4j;

public class Nd4jEnvironment
implements Serializable {
    private long ram;
    private int numCores;
    private String os;
    private int numGpus;
    private List<Long> gpuRam;
    private String blasVendor;
    private long blasThreads;
    private int ompThreads;
    public static final String MEMORY_BANDWIDTH_KEY = "memoryBandwidth";
    public static final String CUDA_DEVICE_NAME_KEY = "cuda.deviceName";
    public static final String CUDA_FREE_MEMORY_KEY = "cuda.freeMemory";
    public static final String CUDA_TOTAL_MEMORY_KEY = "cuda.totalMemory";
    public static final String CUDA_DEVICE_MAJOR_VERSION_KEY = "cuda.deviceMajor";
    public static final String CUDA_DEVICE_MINOR_VERSION_KEY = "cuda.deviceMinor";
    public static final String BACKEND_KEY = "backend";
    public static final String CUDA_NUM_GPUS_KEY = "cuda.availableDevices";
    public static final String CUDA_DEVICE_INFORMATION_KEY = "cuda.devicesInformation";
    public static final String BLAS_VENDOR_KEY = "blas.vendor";
    public static final String OS_KEY = "os";
    public static final String HOST_FREE_MEMORY_KEY = "memory.free";
    public static final String HOST_TOTAL_MEMORY_KEY = "memory.available";
    public static final String CPU_CORES_KEY = "cores";
    public static final String OMP_THREADS_KEY = "omp.threads";
    public static final String BLAS_THREADS_KEY = "blas.threads";

    public static Nd4jEnvironment getEnvironment() {
        Properties envInfo = Nd4j.getExecutioner().getEnvironmentInformation();
        Nd4jEnvironment ret = Nd4jEnvironment.builder().numCores(Nd4jEnvironment.getIntOrZero(CPU_CORES_KEY, envInfo)).ram(Nd4jEnvironment.getLongOrZero(HOST_TOTAL_MEMORY_KEY, envInfo)).os(envInfo.get(OS_KEY).toString()).blasVendor(envInfo.get(BLAS_VENDOR_KEY).toString()).blasThreads(Nd4jEnvironment.getLongOrZero(BLAS_THREADS_KEY, envInfo)).ompThreads(Nd4jEnvironment.getIntOrZero(OMP_THREADS_KEY, envInfo)).numGpus(Nd4jEnvironment.getIntOrZero(CUDA_NUM_GPUS_KEY, envInfo)).build();
        if (envInfo.containsKey(CUDA_DEVICE_INFORMATION_KEY)) {
            List deviceInfo = (List)envInfo.get(CUDA_DEVICE_INFORMATION_KEY);
            ArrayList<Long> gpuRam = new ArrayList<Long>();
            for (Map info : deviceInfo) {
                gpuRam.add(Long.parseLong(info.get(CUDA_TOTAL_MEMORY_KEY).toString()));
            }
            ret.setGpuRam(gpuRam);
        }
        return ret;
    }

    private static long getLongOrZero(String key, Properties properties) {
        if (properties.get(key) == null) {
            return 0L;
        }
        return Long.parseLong(properties.get(key).toString());
    }

    private static int getIntOrZero(String key, Properties properties) {
        if (properties.get(key) == null) {
            return 0;
        }
        return Integer.parseInt(properties.get(key).toString());
    }

    public static Nd4jEnvironmentBuilder builder() {
        return new Nd4jEnvironmentBuilder();
    }

    public long getRam() {
        return this.ram;
    }

    public int getNumCores() {
        return this.numCores;
    }

    public String getOs() {
        return this.os;
    }

    public int getNumGpus() {
        return this.numGpus;
    }

    public List<Long> getGpuRam() {
        return this.gpuRam;
    }

    public String getBlasVendor() {
        return this.blasVendor;
    }

    public long getBlasThreads() {
        return this.blasThreads;
    }

    public int getOmpThreads() {
        return this.ompThreads;
    }

    public void setRam(long ram) {
        this.ram = ram;
    }

    public void setNumCores(int numCores) {
        this.numCores = numCores;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setNumGpus(int numGpus) {
        this.numGpus = numGpus;
    }

    public void setGpuRam(List<Long> gpuRam) {
        this.gpuRam = gpuRam;
    }

    public void setBlasVendor(String blasVendor) {
        this.blasVendor = blasVendor;
    }

    public void setBlasThreads(long blasThreads) {
        this.blasThreads = blasThreads;
    }

    public void setOmpThreads(int ompThreads) {
        this.ompThreads = ompThreads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nd4jEnvironment)) {
            return false;
        }
        Nd4jEnvironment other = (Nd4jEnvironment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRam() != other.getRam()) {
            return false;
        }
        if (this.getNumCores() != other.getNumCores()) {
            return false;
        }
        if (this.getNumGpus() != other.getNumGpus()) {
            return false;
        }
        if (this.getBlasThreads() != other.getBlasThreads()) {
            return false;
        }
        if (this.getOmpThreads() != other.getOmpThreads()) {
            return false;
        }
        String this$os = this.getOs();
        String other$os = other.getOs();
        if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
            return false;
        }
        List<Long> this$gpuRam = this.getGpuRam();
        List<Long> other$gpuRam = other.getGpuRam();
        if (this$gpuRam == null ? other$gpuRam != null : !((Object)this$gpuRam).equals(other$gpuRam)) {
            return false;
        }
        String this$blasVendor = this.getBlasVendor();
        String other$blasVendor = other.getBlasVendor();
        return !(this$blasVendor == null ? other$blasVendor != null : !this$blasVendor.equals(other$blasVendor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nd4jEnvironment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ram = this.getRam();
        result = result * 59 + (int)($ram >>> 32 ^ $ram);
        result = result * 59 + this.getNumCores();
        result = result * 59 + this.getNumGpus();
        long $blasThreads = this.getBlasThreads();
        result = result * 59 + (int)($blasThreads >>> 32 ^ $blasThreads);
        result = result * 59 + this.getOmpThreads();
        String $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : $os.hashCode());
        List<Long> $gpuRam = this.getGpuRam();
        result = result * 59 + ($gpuRam == null ? 43 : ((Object)$gpuRam).hashCode());
        String $blasVendor = this.getBlasVendor();
        result = result * 59 + ($blasVendor == null ? 43 : $blasVendor.hashCode());
        return result;
    }

    public String toString() {
        return "Nd4jEnvironment(ram=" + this.getRam() + ", numCores=" + this.getNumCores() + ", os=" + this.getOs() + ", numGpus=" + this.getNumGpus() + ", gpuRam=" + this.getGpuRam() + ", blasVendor=" + this.getBlasVendor() + ", blasThreads=" + this.getBlasThreads() + ", ompThreads=" + this.getOmpThreads() + ")";
    }

    public Nd4jEnvironment() {
    }

    public Nd4jEnvironment(long ram, int numCores, String os, int numGpus, List<Long> gpuRam, String blasVendor, long blasThreads, int ompThreads) {
        this.ram = ram;
        this.numCores = numCores;
        this.os = os;
        this.numGpus = numGpus;
        this.gpuRam = gpuRam;
        this.blasVendor = blasVendor;
        this.blasThreads = blasThreads;
        this.ompThreads = ompThreads;
    }

    public static class Nd4jEnvironmentBuilder {
        private long ram;
        private int numCores;
        private String os;
        private int numGpus;
        private List<Long> gpuRam;
        private String blasVendor;
        private long blasThreads;
        private int ompThreads;

        Nd4jEnvironmentBuilder() {
        }

        public Nd4jEnvironmentBuilder ram(long ram) {
            this.ram = ram;
            return this;
        }

        public Nd4jEnvironmentBuilder numCores(int numCores) {
            this.numCores = numCores;
            return this;
        }

        public Nd4jEnvironmentBuilder os(String os) {
            this.os = os;
            return this;
        }

        public Nd4jEnvironmentBuilder numGpus(int numGpus) {
            this.numGpus = numGpus;
            return this;
        }

        public Nd4jEnvironmentBuilder gpuRam(List<Long> gpuRam) {
            this.gpuRam = gpuRam;
            return this;
        }

        public Nd4jEnvironmentBuilder blasVendor(String blasVendor) {
            this.blasVendor = blasVendor;
            return this;
        }

        public Nd4jEnvironmentBuilder blasThreads(long blasThreads) {
            this.blasThreads = blasThreads;
            return this;
        }

        public Nd4jEnvironmentBuilder ompThreads(int ompThreads) {
            this.ompThreads = ompThreads;
            return this;
        }

        public Nd4jEnvironment build() {
            return new Nd4jEnvironment(this.ram, this.numCores, this.os, this.numGpus, this.gpuRam, this.blasVendor, this.blasThreads, this.ompThreads);
        }

        public String toString() {
            return "Nd4jEnvironment.Nd4jEnvironmentBuilder(ram=" + this.ram + ", numCores=" + this.numCores + ", os=" + this.os + ", numGpus=" + this.numGpus + ", gpuRam=" + this.gpuRam + ", blasVendor=" + this.blasVendor + ", blasThreads=" + this.blasThreads + ", ompThreads=" + this.ompThreads + ")";
        }
    }
}

