/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.util;

import org.nd4j.context.Nd4jContext;
import org.nd4j.linalg.api.buffer.DataBuffer;

public class AllocUtil {
    public static DataBuffer.AllocationMode getAllocationModeFromContext(String allocMode) {
        switch (allocMode) {
            case "heap": {
                return DataBuffer.AllocationMode.HEAP;
            }
            case "javacpp": {
                return DataBuffer.AllocationMode.JAVACPP;
            }
            case "direct": {
                return DataBuffer.AllocationMode.DIRECT;
            }
        }
        return DataBuffer.AllocationMode.JAVACPP;
    }

    public static String getAllocModeName(DataBuffer.AllocationMode allocationMode) {
        switch (allocationMode) {
            case HEAP: {
                return "heap";
            }
            case JAVACPP: {
                return "javacpp";
            }
            case DIRECT: {
                return "direct";
            }
        }
        return "javacpp";
    }

    public static DataBuffer.AllocationMode getAllocationModeFromContext() {
        return DataBuffer.AllocationMode.MIXED_DATA_TYPES;
    }

    public static void setAllocationModeForContext(DataBuffer.AllocationMode allocationModeForContext) {
        AllocUtil.setAllocationModeForContext(AllocUtil.getAllocModeName(allocationModeForContext));
    }

    public static void setAllocationModeForContext(String allocationModeForContext) {
        if (!(allocationModeForContext.equals("heap") || allocationModeForContext.equals("javacpp") || allocationModeForContext.equals("direct"))) {
            throw new IllegalArgumentException("Allocation mode must be one of: heap,javacpp, or direct");
        }
        Nd4jContext.getInstance().getConf().put("alloc", allocationModeForContext);
    }
}

