/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.random.custom.RandomExponential;
import org.nd4j.linalg.api.ops.random.impl.BernoulliDistribution;
import org.nd4j.linalg.api.ops.random.impl.BinomialDistribution;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.api.ops.random.impl.LogNormalDistribution;
import org.nd4j.linalg.api.ops.random.impl.TruncatedNormalDistribution;
import org.nd4j.linalg.api.ops.random.impl.UniformDistribution;

public class SDRandom
extends SDOps {
    public SDRandom(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable bernoulli(double p, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return new BernoulliDistribution(this.sd, p, datatype, shape).outputVariable();
    }

    public SDVariable bernoulli(String name, double p, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        SDVariable out = new BernoulliDistribution(this.sd, p, datatype, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable binomial(int nTrials, double p, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return new BinomialDistribution(this.sd, nTrials, p, datatype, shape).outputVariable();
    }

    public SDVariable binomial(String name, int nTrials, double p, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        SDVariable out = new BinomialDistribution(this.sd, nTrials, p, datatype, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable exponential(double lambda, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        Preconditions.checkArgument((lambda > 0.0 ? 1 : 0) != 0, (String)"Must be positive");
        return new RandomExponential(this.sd, lambda, datatype, shape).outputVariable();
    }

    public SDVariable exponential(String name, double lambda, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        Preconditions.checkArgument((lambda > 0.0 ? 1 : 0) != 0, (String)"Must be positive");
        SDVariable out = new RandomExponential(this.sd, lambda, datatype, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logNormal(double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return new LogNormalDistribution(this.sd, mean, stddev, datatype, shape).outputVariable();
    }

    public SDVariable logNormal(String name, double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        SDVariable out = new LogNormalDistribution(this.sd, mean, stddev, datatype, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable normal(double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return new GaussianDistribution(this.sd, mean, stddev, datatype, shape).outputVariable();
    }

    public SDVariable normal(String name, double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        SDVariable out = new GaussianDistribution(this.sd, mean, stddev, datatype, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable normalTruncated(double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return new TruncatedNormalDistribution(this.sd, mean, stddev, datatype, shape).outputVariable();
    }

    public SDVariable normalTruncated(String name, double mean, double stddev, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        SDVariable out = new TruncatedNormalDistribution(this.sd, mean, stddev, datatype, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable uniform(double min, double max, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return new UniformDistribution(this.sd, min, max, datatype, shape).outputVariable();
    }

    public SDVariable uniform(String name, double min, double max, DataType datatype, long ... shape) {
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        SDVariable out = new UniformDistribution(this.sd, min, max, datatype, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }
}

