/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.DataFormat;
import org.nd4j.linalg.api.ops.impl.image.ExtractImagePatches;
import org.nd4j.linalg.api.ops.impl.layers.convolution.AvgPooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.AvgPooling3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Col2Im;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv1D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DepthToSpace;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DepthwiseConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Im2col;
import org.nd4j.linalg.api.ops.impl.layers.convolution.LocalResponseNormalization;
import org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPoolWithArgmax;
import org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPooling3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SpaceToDepth;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Upsampling2d;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Upsampling3d;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.LocalResponseNormalizationConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BatchToSpace;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Dilation2D;
import org.nd4j.linalg.api.ops.impl.transforms.custom.SpaceToBatch;

public class SDCNN
extends SDOps {
    public SDCNN(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable avgPooling2d(SDVariable input, Pooling2DConfig Pooling2DConfig2) {
        SDValidation.validateNumerical("avgPooling2d", "input", input);
        return new AvgPooling2D(this.sd, input, Pooling2DConfig2).outputVariable();
    }

    public SDVariable avgPooling2d(String name, SDVariable input, Pooling2DConfig Pooling2DConfig2) {
        SDValidation.validateNumerical("avgPooling2d", "input", input);
        SDVariable out = new AvgPooling2D(this.sd, input, Pooling2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable avgPooling3d(SDVariable input, Pooling3DConfig Pooling3DConfig2) {
        SDValidation.validateNumerical("avgPooling3d", "input", input);
        return new AvgPooling3D(this.sd, input, Pooling3DConfig2).outputVariable();
    }

    public SDVariable avgPooling3d(String name, SDVariable input, Pooling3DConfig Pooling3DConfig2) {
        SDValidation.validateNumerical("avgPooling3d", "input", input);
        SDVariable out = new AvgPooling3D(this.sd, input, Pooling3DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable batchToSpace(SDVariable x, int[] blocks, int[] croppingTop, int ... croppingBottom) {
        SDValidation.validateNumerical("batchToSpace", "x", x);
        Preconditions.checkArgument((blocks.length == 2 ? 1 : 0) != 0, (String)"blocks has incorrect size/length. Expected: blocks.length == 2, got %s", (int)blocks.length);
        Preconditions.checkArgument((croppingTop.length == 2 ? 1 : 0) != 0, (String)"croppingTop has incorrect size/length. Expected: croppingTop.length == 2, got %s", (int)croppingTop.length);
        Preconditions.checkArgument((croppingBottom.length == 2 ? 1 : 0) != 0, (String)"croppingBottom has incorrect size/length. Expected: croppingBottom.length == 2, got %s", (int)croppingBottom.length);
        return new BatchToSpace(this.sd, x, blocks, croppingTop, croppingBottom).outputVariable();
    }

    public SDVariable batchToSpace(String name, SDVariable x, int[] blocks, int[] croppingTop, int ... croppingBottom) {
        SDValidation.validateNumerical("batchToSpace", "x", x);
        Preconditions.checkArgument((blocks.length == 2 ? 1 : 0) != 0, (String)"blocks has incorrect size/length. Expected: blocks.length == 2, got %s", (int)blocks.length);
        Preconditions.checkArgument((croppingTop.length == 2 ? 1 : 0) != 0, (String)"croppingTop has incorrect size/length. Expected: croppingTop.length == 2, got %s", (int)croppingTop.length);
        Preconditions.checkArgument((croppingBottom.length == 2 ? 1 : 0) != 0, (String)"croppingBottom has incorrect size/length. Expected: croppingBottom.length == 2, got %s", (int)croppingBottom.length);
        SDVariable out = new BatchToSpace(this.sd, x, blocks, croppingTop, croppingBottom).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable col2Im(SDVariable in, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("col2Im", "in", in);
        return new Col2Im(this.sd, in, Conv2DConfig2).outputVariable();
    }

    public SDVariable col2Im(String name, SDVariable in, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("col2Im", "in", in);
        SDVariable out = new Col2Im(this.sd, in, Conv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable conv1d(SDVariable input, SDVariable weights, SDVariable bias, Conv1DConfig Conv1DConfig2) {
        SDValidation.validateNumerical("conv1d", "input", input);
        SDValidation.validateNumerical("conv1d", "weights", weights);
        SDValidation.validateNumerical("conv1d", "bias", bias);
        return new Conv1D(this.sd, input, weights, bias, Conv1DConfig2).outputVariable();
    }

    public SDVariable conv1d(String name, SDVariable input, SDVariable weights, SDVariable bias, Conv1DConfig Conv1DConfig2) {
        SDValidation.validateNumerical("conv1d", "input", input);
        SDValidation.validateNumerical("conv1d", "weights", weights);
        SDValidation.validateNumerical("conv1d", "bias", bias);
        SDVariable out = new Conv1D(this.sd, input, weights, bias, Conv1DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable conv1d(SDVariable input, SDVariable weights, Conv1DConfig Conv1DConfig2) {
        SDValidation.validateNumerical("conv1d", "input", input);
        SDValidation.validateNumerical("conv1d", "weights", weights);
        return new Conv1D(this.sd, input, weights, null, Conv1DConfig2).outputVariable();
    }

    public SDVariable conv1d(String name, SDVariable input, SDVariable weights, Conv1DConfig Conv1DConfig2) {
        SDValidation.validateNumerical("conv1d", "input", input);
        SDValidation.validateNumerical("conv1d", "weights", weights);
        SDVariable out = new Conv1D(this.sd, input, weights, null, Conv1DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable conv2d(SDVariable layerInput, SDVariable weights, SDVariable bias, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("conv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("conv2d", "weights", weights);
        SDValidation.validateNumerical("conv2d", "bias", bias);
        return new Conv2D(this.sd, layerInput, weights, bias, Conv2DConfig2).outputVariable();
    }

    public SDVariable conv2d(String name, SDVariable layerInput, SDVariable weights, SDVariable bias, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("conv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("conv2d", "weights", weights);
        SDValidation.validateNumerical("conv2d", "bias", bias);
        SDVariable out = new Conv2D(this.sd, layerInput, weights, bias, Conv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable conv2d(SDVariable layerInput, SDVariable weights, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("conv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("conv2d", "weights", weights);
        return new Conv2D(this.sd, layerInput, weights, null, Conv2DConfig2).outputVariable();
    }

    public SDVariable conv2d(String name, SDVariable layerInput, SDVariable weights, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("conv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("conv2d", "weights", weights);
        SDVariable out = new Conv2D(this.sd, layerInput, weights, null, Conv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable conv3d(SDVariable input, SDVariable weights, SDVariable bias, Conv3DConfig Conv3DConfig2) {
        SDValidation.validateNumerical("conv3d", "input", input);
        SDValidation.validateNumerical("conv3d", "weights", weights);
        SDValidation.validateNumerical("conv3d", "bias", bias);
        return new Conv3D(this.sd, input, weights, bias, Conv3DConfig2).outputVariable();
    }

    public SDVariable conv3d(String name, SDVariable input, SDVariable weights, SDVariable bias, Conv3DConfig Conv3DConfig2) {
        SDValidation.validateNumerical("conv3d", "input", input);
        SDValidation.validateNumerical("conv3d", "weights", weights);
        SDValidation.validateNumerical("conv3d", "bias", bias);
        SDVariable out = new Conv3D(this.sd, input, weights, bias, Conv3DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable conv3d(SDVariable input, SDVariable weights, Conv3DConfig Conv3DConfig2) {
        SDValidation.validateNumerical("conv3d", "input", input);
        SDValidation.validateNumerical("conv3d", "weights", weights);
        return new Conv3D(this.sd, input, weights, null, Conv3DConfig2).outputVariable();
    }

    public SDVariable conv3d(String name, SDVariable input, SDVariable weights, Conv3DConfig Conv3DConfig2) {
        SDValidation.validateNumerical("conv3d", "input", input);
        SDValidation.validateNumerical("conv3d", "weights", weights);
        SDVariable out = new Conv3D(this.sd, input, weights, null, Conv3DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable deconv2d(SDVariable layerInput, SDVariable weights, SDVariable bias, DeConv2DConfig DeConv2DConfig2) {
        SDValidation.validateNumerical("deconv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("deconv2d", "weights", weights);
        SDValidation.validateNumerical("deconv2d", "bias", bias);
        return new DeConv2D(this.sd, layerInput, weights, bias, DeConv2DConfig2).outputVariable();
    }

    public SDVariable deconv2d(String name, SDVariable layerInput, SDVariable weights, SDVariable bias, DeConv2DConfig DeConv2DConfig2) {
        SDValidation.validateNumerical("deconv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("deconv2d", "weights", weights);
        SDValidation.validateNumerical("deconv2d", "bias", bias);
        SDVariable out = new DeConv2D(this.sd, layerInput, weights, bias, DeConv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable deconv2d(SDVariable layerInput, SDVariable weights, DeConv2DConfig DeConv2DConfig2) {
        SDValidation.validateNumerical("deconv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("deconv2d", "weights", weights);
        return new DeConv2D(this.sd, layerInput, weights, null, DeConv2DConfig2).outputVariable();
    }

    public SDVariable deconv2d(String name, SDVariable layerInput, SDVariable weights, DeConv2DConfig DeConv2DConfig2) {
        SDValidation.validateNumerical("deconv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("deconv2d", "weights", weights);
        SDVariable out = new DeConv2D(this.sd, layerInput, weights, null, DeConv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable deconv3d(SDVariable input, SDVariable weights, SDVariable bias, DeConv3DConfig DeConv3DConfig2) {
        SDValidation.validateNumerical("deconv3d", "input", input);
        SDValidation.validateNumerical("deconv3d", "weights", weights);
        SDValidation.validateNumerical("deconv3d", "bias", bias);
        return new DeConv3D(this.sd, input, weights, bias, DeConv3DConfig2).outputVariable();
    }

    public SDVariable deconv3d(String name, SDVariable input, SDVariable weights, SDVariable bias, DeConv3DConfig DeConv3DConfig2) {
        SDValidation.validateNumerical("deconv3d", "input", input);
        SDValidation.validateNumerical("deconv3d", "weights", weights);
        SDValidation.validateNumerical("deconv3d", "bias", bias);
        SDVariable out = new DeConv3D(this.sd, input, weights, bias, DeConv3DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable deconv3d(SDVariable input, SDVariable weights, DeConv3DConfig DeConv3DConfig2) {
        SDValidation.validateNumerical("deconv3d", "input", input);
        SDValidation.validateNumerical("deconv3d", "weights", weights);
        return new DeConv3D(this.sd, input, weights, null, DeConv3DConfig2).outputVariable();
    }

    public SDVariable deconv3d(String name, SDVariable input, SDVariable weights, DeConv3DConfig DeConv3DConfig2) {
        SDValidation.validateNumerical("deconv3d", "input", input);
        SDValidation.validateNumerical("deconv3d", "weights", weights);
        SDVariable out = new DeConv3D(this.sd, input, weights, null, DeConv3DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable depthToSpace(SDVariable x, int blockSize, DataFormat dataFormat) {
        SDValidation.validateNumerical("depthToSpace", "x", x);
        return new DepthToSpace(this.sd, x, blockSize, dataFormat).outputVariable();
    }

    public SDVariable depthToSpace(String name, SDVariable x, int blockSize, DataFormat dataFormat) {
        SDValidation.validateNumerical("depthToSpace", "x", x);
        SDVariable out = new DepthToSpace(this.sd, x, blockSize, dataFormat).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable depthWiseConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable bias, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("depthWiseConv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("depthWiseConv2d", "depthWeights", depthWeights);
        SDValidation.validateNumerical("depthWiseConv2d", "bias", bias);
        return new DepthwiseConv2D(this.sd, layerInput, depthWeights, bias, Conv2DConfig2).outputVariable();
    }

    public SDVariable depthWiseConv2d(String name, SDVariable layerInput, SDVariable depthWeights, SDVariable bias, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("depthWiseConv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("depthWiseConv2d", "depthWeights", depthWeights);
        SDValidation.validateNumerical("depthWiseConv2d", "bias", bias);
        SDVariable out = new DepthwiseConv2D(this.sd, layerInput, depthWeights, bias, Conv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable depthWiseConv2d(SDVariable layerInput, SDVariable depthWeights, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("depthWiseConv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("depthWiseConv2d", "depthWeights", depthWeights);
        return new DepthwiseConv2D(this.sd, layerInput, depthWeights, null, Conv2DConfig2).outputVariable();
    }

    public SDVariable depthWiseConv2d(String name, SDVariable layerInput, SDVariable depthWeights, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("depthWiseConv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("depthWiseConv2d", "depthWeights", depthWeights);
        SDVariable out = new DepthwiseConv2D(this.sd, layerInput, depthWeights, null, Conv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable dilation2D(SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        SDValidation.validateNumerical("dilation2D", "df", df);
        SDValidation.validateNumerical("dilation2D", "weights", weights);
        Preconditions.checkArgument((strides.length == 2 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length == 2, got %s", (int)strides.length);
        Preconditions.checkArgument((rates.length == 2 ? 1 : 0) != 0, (String)"rates has incorrect size/length. Expected: rates.length == 2, got %s", (int)rates.length);
        return new Dilation2D(this.sd, df, weights, strides, rates, isSameMode).outputVariable();
    }

    public SDVariable dilation2D(String name, SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        SDValidation.validateNumerical("dilation2D", "df", df);
        SDValidation.validateNumerical("dilation2D", "weights", weights);
        Preconditions.checkArgument((strides.length == 2 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length == 2, got %s", (int)strides.length);
        Preconditions.checkArgument((rates.length == 2 ? 1 : 0) != 0, (String)"rates has incorrect size/length. Expected: rates.length == 2, got %s", (int)rates.length);
        SDVariable out = new Dilation2D(this.sd, df, weights, strides, rates, isSameMode).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable extractImagePatches(SDVariable input, int kH, int kW, int sH, int sW, int rH, int rW, boolean sameMode) {
        SDValidation.validateNumerical("extractImagePatches", "input", input);
        return new ExtractImagePatches(this.sd, input, kH, kW, sH, sW, rH, rW, sameMode).outputVariable();
    }

    public SDVariable extractImagePatches(String name, SDVariable input, int kH, int kW, int sH, int sW, int rH, int rW, boolean sameMode) {
        SDValidation.validateNumerical("extractImagePatches", "input", input);
        SDVariable out = new ExtractImagePatches(this.sd, input, kH, kW, sH, sW, rH, rW, sameMode).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable im2Col(SDVariable in, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("im2Col", "in", in);
        return new Im2col(this.sd, in, Conv2DConfig2).outputVariable();
    }

    public SDVariable im2Col(String name, SDVariable in, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("im2Col", "in", in);
        SDVariable out = new Im2col(this.sd, in, Conv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable localResponseNormalization(SDVariable input, LocalResponseNormalizationConfig LocalResponseNormalizationConfig2) {
        SDValidation.validateNumerical("localResponseNormalization", "input", input);
        return new LocalResponseNormalization(this.sd, input, LocalResponseNormalizationConfig2).outputVariable();
    }

    public SDVariable localResponseNormalization(String name, SDVariable input, LocalResponseNormalizationConfig LocalResponseNormalizationConfig2) {
        SDValidation.validateNumerical("localResponseNormalization", "input", input);
        SDVariable out = new LocalResponseNormalization(this.sd, input, LocalResponseNormalizationConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable[] maxPoolWithArgmax(SDVariable input, Pooling2DConfig Pooling2DConfig2) {
        SDValidation.validateNumerical("maxPoolWithArgmax", "input", input);
        return new MaxPoolWithArgmax(this.sd, input, Pooling2DConfig2).outputVariables();
    }

    public SDVariable[] maxPoolWithArgmax(String[] names, SDVariable input, Pooling2DConfig Pooling2DConfig2) {
        SDValidation.validateNumerical("maxPoolWithArgmax", "input", input);
        SDVariable[] out = new MaxPoolWithArgmax(this.sd, input, Pooling2DConfig2).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable maxPooling2d(SDVariable input, Pooling2DConfig Pooling2DConfig2) {
        SDValidation.validateNumerical("maxPooling2d", "input", input);
        return new MaxPooling2D(this.sd, input, Pooling2DConfig2).outputVariable();
    }

    public SDVariable maxPooling2d(String name, SDVariable input, Pooling2DConfig Pooling2DConfig2) {
        SDValidation.validateNumerical("maxPooling2d", "input", input);
        SDVariable out = new MaxPooling2D(this.sd, input, Pooling2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable maxPooling3d(SDVariable input, Pooling3DConfig Pooling3DConfig2) {
        SDValidation.validateNumerical("maxPooling3d", "input", input);
        return new MaxPooling3D(this.sd, input, Pooling3DConfig2).outputVariable();
    }

    public SDVariable maxPooling3d(String name, SDVariable input, Pooling3DConfig Pooling3DConfig2) {
        SDValidation.validateNumerical("maxPooling3d", "input", input);
        SDVariable out = new MaxPooling3D(this.sd, input, Pooling3DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable separableConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable pointWeights, SDVariable bias, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("separableConv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("separableConv2d", "depthWeights", depthWeights);
        SDValidation.validateNumerical("separableConv2d", "pointWeights", pointWeights);
        SDValidation.validateNumerical("separableConv2d", "bias", bias);
        return new SConv2D(this.sd, layerInput, depthWeights, pointWeights, bias, Conv2DConfig2).outputVariable();
    }

    public SDVariable separableConv2d(String name, SDVariable layerInput, SDVariable depthWeights, SDVariable pointWeights, SDVariable bias, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("separableConv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("separableConv2d", "depthWeights", depthWeights);
        SDValidation.validateNumerical("separableConv2d", "pointWeights", pointWeights);
        SDValidation.validateNumerical("separableConv2d", "bias", bias);
        SDVariable out = new SConv2D(this.sd, layerInput, depthWeights, pointWeights, bias, Conv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable separableConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable pointWeights, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("separableConv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("separableConv2d", "depthWeights", depthWeights);
        SDValidation.validateNumerical("separableConv2d", "pointWeights", pointWeights);
        return new SConv2D(this.sd, layerInput, depthWeights, pointWeights, null, Conv2DConfig2).outputVariable();
    }

    public SDVariable separableConv2d(String name, SDVariable layerInput, SDVariable depthWeights, SDVariable pointWeights, Conv2DConfig Conv2DConfig2) {
        SDValidation.validateNumerical("separableConv2d", "layerInput", layerInput);
        SDValidation.validateNumerical("separableConv2d", "depthWeights", depthWeights);
        SDValidation.validateNumerical("separableConv2d", "pointWeights", pointWeights);
        SDVariable out = new SConv2D(this.sd, layerInput, depthWeights, pointWeights, null, Conv2DConfig2).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable spaceToBatch(SDVariable x, int[] blocks, int[] paddingTop, int ... paddingBottom) {
        SDValidation.validateNumerical("spaceToBatch", "x", x);
        Preconditions.checkArgument((blocks.length == 2 ? 1 : 0) != 0, (String)"blocks has incorrect size/length. Expected: blocks.length == 2, got %s", (int)blocks.length);
        Preconditions.checkArgument((paddingTop.length == 2 ? 1 : 0) != 0, (String)"paddingTop has incorrect size/length. Expected: paddingTop.length == 2, got %s", (int)paddingTop.length);
        Preconditions.checkArgument((paddingBottom.length == 2 ? 1 : 0) != 0, (String)"paddingBottom has incorrect size/length. Expected: paddingBottom.length == 2, got %s", (int)paddingBottom.length);
        return new SpaceToBatch(this.sd, x, blocks, paddingTop, paddingBottom).outputVariable();
    }

    public SDVariable spaceToBatch(String name, SDVariable x, int[] blocks, int[] paddingTop, int ... paddingBottom) {
        SDValidation.validateNumerical("spaceToBatch", "x", x);
        Preconditions.checkArgument((blocks.length == 2 ? 1 : 0) != 0, (String)"blocks has incorrect size/length. Expected: blocks.length == 2, got %s", (int)blocks.length);
        Preconditions.checkArgument((paddingTop.length == 2 ? 1 : 0) != 0, (String)"paddingTop has incorrect size/length. Expected: paddingTop.length == 2, got %s", (int)paddingTop.length);
        Preconditions.checkArgument((paddingBottom.length == 2 ? 1 : 0) != 0, (String)"paddingBottom has incorrect size/length. Expected: paddingBottom.length == 2, got %s", (int)paddingBottom.length);
        SDVariable out = new SpaceToBatch(this.sd, x, blocks, paddingTop, paddingBottom).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable spaceToDepth(SDVariable x, int blockSize, DataFormat dataFormat) {
        SDValidation.validateNumerical("spaceToDepth", "x", x);
        return new SpaceToDepth(this.sd, x, blockSize, dataFormat).outputVariable();
    }

    public SDVariable spaceToDepth(String name, SDVariable x, int blockSize, DataFormat dataFormat) {
        SDValidation.validateNumerical("spaceToDepth", "x", x);
        SDVariable out = new SpaceToDepth(this.sd, x, blockSize, dataFormat).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable upsampling2d(SDVariable input, int scale) {
        SDValidation.validateNumerical("upsampling2d", "input", input);
        return new Upsampling2d(this.sd, input, scale).outputVariable();
    }

    public SDVariable upsampling2d(String name, SDVariable input, int scale) {
        SDValidation.validateNumerical("upsampling2d", "input", input);
        SDVariable out = new Upsampling2d(this.sd, input, scale).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable upsampling2d(SDVariable input, int scaleH, int scaleW, boolean nchw) {
        SDValidation.validateNumerical("upsampling2d", "input", input);
        return new Upsampling2d(this.sd, input, scaleH, scaleW, nchw).outputVariable();
    }

    public SDVariable upsampling2d(String name, SDVariable input, int scaleH, int scaleW, boolean nchw) {
        SDValidation.validateNumerical("upsampling2d", "input", input);
        SDVariable out = new Upsampling2d(this.sd, input, scaleH, scaleW, nchw).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable upsampling3d(SDVariable input, boolean ncdhw, int scaleD, int scaleH, int scaleW) {
        SDValidation.validateNumerical("upsampling3d", "input", input);
        return new Upsampling3d(this.sd, input, ncdhw, scaleD, scaleH, scaleW).outputVariable();
    }

    public SDVariable upsampling3d(String name, SDVariable input, boolean ncdhw, int scaleD, int scaleH, int scaleW) {
        SDValidation.validateNumerical("upsampling3d", "input", input);
        SDVariable out = new Upsampling3d(this.sd, input, ncdhw, scaleD, scaleH, scaleW).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }
}

