/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Merge;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Switch;
import org.nd4j.linalg.api.ops.impl.indexaccum.custom.ArgMax;
import org.nd4j.linalg.api.ops.impl.indexaccum.custom.ArgMin;
import org.nd4j.linalg.api.ops.impl.reduce.Mmul;
import org.nd4j.linalg.api.ops.impl.reduce.TensorMmul;
import org.nd4j.linalg.api.ops.impl.reduce.bool.All;
import org.nd4j.linalg.api.ops.impl.reduce.bool.Any;
import org.nd4j.linalg.api.ops.impl.reduce.custom.BatchMmul;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Mean;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Norm1;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Norm2;
import org.nd4j.linalg.api.ops.impl.reduce.floating.NormMax;
import org.nd4j.linalg.api.ops.impl.reduce.floating.SquaredNorm;
import org.nd4j.linalg.api.ops.impl.reduce.longer.MatchCondition;
import org.nd4j.linalg.api.ops.impl.reduce.same.Min;
import org.nd4j.linalg.api.ops.impl.reduce.same.Prod;
import org.nd4j.linalg.api.ops.impl.reduce.same.Sum;
import org.nd4j.linalg.api.ops.impl.reduce3.Dot;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarFMod;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMax;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMin;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSet;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterAdd;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterDiv;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterMax;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterMin;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterMul;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterSub;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate;
import org.nd4j.linalg.api.ops.impl.shape.Concat;
import org.nd4j.linalg.api.ops.impl.shape.ExpandDims;
import org.nd4j.linalg.api.ops.impl.shape.Gather;
import org.nd4j.linalg.api.ops.impl.shape.GatherNd;
import org.nd4j.linalg.api.ops.impl.shape.Linspace;
import org.nd4j.linalg.api.ops.impl.shape.OneHot;
import org.nd4j.linalg.api.ops.impl.shape.OnesLike;
import org.nd4j.linalg.api.ops.impl.shape.Permute;
import org.nd4j.linalg.api.ops.impl.shape.Rank;
import org.nd4j.linalg.api.ops.impl.shape.Reshape;
import org.nd4j.linalg.api.ops.impl.shape.SequenceMask;
import org.nd4j.linalg.api.ops.impl.shape.Shape;
import org.nd4j.linalg.api.ops.impl.shape.Size;
import org.nd4j.linalg.api.ops.impl.shape.SizeAt;
import org.nd4j.linalg.api.ops.impl.shape.Slice;
import org.nd4j.linalg.api.ops.impl.shape.Split;
import org.nd4j.linalg.api.ops.impl.shape.Squeeze;
import org.nd4j.linalg.api.ops.impl.shape.Stack;
import org.nd4j.linalg.api.ops.impl.shape.StridedSlice;
import org.nd4j.linalg.api.ops.impl.shape.Tile;
import org.nd4j.linalg.api.ops.impl.shape.Transpose;
import org.nd4j.linalg.api.ops.impl.shape.Unstack;
import org.nd4j.linalg.api.ops.impl.shape.ZerosLike;
import org.nd4j.linalg.api.ops.impl.summarystats.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.summarystats.Variance;
import org.nd4j.linalg.api.ops.impl.transforms.bool.MatchConditionTransform;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndReplace;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndSet;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CumProd;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CumSum;
import org.nd4j.linalg.api.ops.impl.transforms.custom.DynamicPartition;
import org.nd4j.linalg.api.ops.impl.transforms.custom.DynamicStitch;
import org.nd4j.linalg.api.ops.impl.transforms.custom.EqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Fill;
import org.nd4j.linalg.api.ops.impl.transforms.custom.GreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.custom.GreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.custom.InvertPermutation;
import org.nd4j.linalg.api.ops.impl.transforms.custom.IsNumericTensor;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LessThan;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Max;
import org.nd4j.linalg.api.ops.impl.transforms.custom.NotEqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Reverse;
import org.nd4j.linalg.api.ops.impl.transforms.custom.ReverseSequence;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentMax;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentMean;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentMin;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentProd;
import org.nd4j.linalg.api.ops.impl.transforms.custom.segment.SegmentSum;
import org.nd4j.linalg.api.ops.impl.transforms.dtype.Cast;
import org.nd4j.linalg.api.ops.impl.transforms.same.Identity;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentMax;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentMean;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentMin;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentProd;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentSqrtN;
import org.nd4j.linalg.api.ops.impl.transforms.segment.UnsortedSegmentSum;
import org.nd4j.linalg.api.ops.random.impl.Range;
import org.nd4j.linalg.indexing.conditions.Condition;

public class SDBaseOps {
    protected SameDiff sd;

    public SDBaseOps(SameDiff sameDiff) {
        this.sd = sameDiff;
    }

    public SDVariable all(SDVariable x, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new All(this.sd, x, dimensions).outputVariable();
    }

    public SDVariable all(String name, SDVariable x, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new All(this.sd, x, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable any(SDVariable x, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Any(this.sd, x, dimensions).outputVariable();
    }

    public SDVariable any(String name, SDVariable x, int ... dimensions) {
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Any(this.sd, x, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable argmax(SDVariable in, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("argmax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new ArgMax(this.sd, in, keepDims, dimensions).outputVariable();
    }

    public SDVariable argmax(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("argmax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new ArgMax(this.sd, in, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable argmax(SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("argmax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new ArgMax(this.sd, in, false, dimensions).outputVariable();
    }

    public SDVariable argmax(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("argmax", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new ArgMax(this.sd, in, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable argmin(SDVariable in, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("argmin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new ArgMin(this.sd, in, keepDims, dimensions).outputVariable();
    }

    public SDVariable argmin(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("argmin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new ArgMin(this.sd, in, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable argmin(SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("argmin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new ArgMin(this.sd, in, false, dimensions).outputVariable();
    }

    public SDVariable argmin(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("argmin", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new ArgMin(this.sd, in, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable[] batchMmul(SDVariable[] inputsA, SDVariable[] inputsB, boolean transposeA, boolean transposeB) {
        SDValidation.validateNumerical("batchMmul", "inputsA", inputsA);
        Preconditions.checkArgument((inputsA.length >= 1 ? 1 : 0) != 0, (String)"inputsA has incorrect size/length. Expected: inputsA.length >= 1, got %s", (int)inputsA.length);
        SDValidation.validateNumerical("batchMmul", "inputsB", inputsB);
        Preconditions.checkArgument((inputsB.length >= 1 ? 1 : 0) != 0, (String)"inputsB has incorrect size/length. Expected: inputsB.length >= 1, got %s", (int)inputsB.length);
        return new BatchMmul(this.sd, inputsA, inputsB, transposeA, transposeB).outputVariables();
    }

    public SDVariable[] batchMmul(String[] names, SDVariable[] inputsA, SDVariable[] inputsB, boolean transposeA, boolean transposeB) {
        SDValidation.validateNumerical("batchMmul", "inputsA", inputsA);
        Preconditions.checkArgument((inputsA.length >= 1 ? 1 : 0) != 0, (String)"inputsA has incorrect size/length. Expected: inputsA.length >= 1, got %s", (int)inputsA.length);
        SDValidation.validateNumerical("batchMmul", "inputsB", inputsB);
        Preconditions.checkArgument((inputsB.length >= 1 ? 1 : 0) != 0, (String)"inputsB has incorrect size/length. Expected: inputsB.length >= 1, got %s", (int)inputsB.length);
        SDVariable[] out = new BatchMmul(this.sd, inputsA, inputsB, transposeA, transposeB).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable[] batchMmul(SDVariable[] inputsA, SDVariable ... inputsB) {
        SDValidation.validateNumerical("batchMmul", "inputsA", inputsA);
        Preconditions.checkArgument((inputsA.length >= 1 ? 1 : 0) != 0, (String)"inputsA has incorrect size/length. Expected: inputsA.length >= 1, got %s", (int)inputsA.length);
        SDValidation.validateNumerical("batchMmul", "inputsB", inputsB);
        Preconditions.checkArgument((inputsB.length >= 1 ? 1 : 0) != 0, (String)"inputsB has incorrect size/length. Expected: inputsB.length >= 1, got %s", (int)inputsB.length);
        return new BatchMmul(this.sd, inputsA, inputsB, false, false).outputVariables();
    }

    public SDVariable[] batchMmul(String[] names, SDVariable[] inputsA, SDVariable ... inputsB) {
        SDValidation.validateNumerical("batchMmul", "inputsA", inputsA);
        Preconditions.checkArgument((inputsA.length >= 1 ? 1 : 0) != 0, (String)"inputsA has incorrect size/length. Expected: inputsA.length >= 1, got %s", (int)inputsA.length);
        SDValidation.validateNumerical("batchMmul", "inputsB", inputsB);
        Preconditions.checkArgument((inputsB.length >= 1 ? 1 : 0) != 0, (String)"inputsB has incorrect size/length. Expected: inputsB.length >= 1, got %s", (int)inputsB.length);
        SDVariable[] out = new BatchMmul(this.sd, inputsA, inputsB, false, false).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable castTo(SDVariable arg, DataType datatype) {
        return new Cast(this.sd, arg, datatype).outputVariable();
    }

    public SDVariable castTo(String name, SDVariable arg, DataType datatype) {
        SDVariable out = new Cast(this.sd, arg, datatype).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable concat(int dimension, SDVariable ... inputs) {
        SDValidation.validateNumerical("concat", "inputs", inputs);
        Preconditions.checkArgument((inputs.length >= 1 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 1, got %s", (int)inputs.length);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(inputs), (String)"Input arrays must all be the same datatype");
        return new Concat(this.sd, inputs, dimension).outputVariable();
    }

    public SDVariable concat(String name, int dimension, SDVariable ... inputs) {
        SDValidation.validateNumerical("concat", "inputs", inputs);
        Preconditions.checkArgument((inputs.length >= 1 ? 1 : 0) != 0, (String)"inputs has incorrect size/length. Expected: inputs.length >= 1, got %s", (int)inputs.length);
        Preconditions.checkArgument((boolean)SDValidation.isSameType(inputs), (String)"Input arrays must all be the same datatype");
        SDVariable out = new Concat(this.sd, inputs, dimension).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable cumprod(SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        SDValidation.validateNumerical("cumprod", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return new CumProd(this.sd, in, exclusive, reverse, axis).outputVariable();
    }

    public SDVariable cumprod(String name, SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        SDValidation.validateNumerical("cumprod", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        SDVariable out = new CumProd(this.sd, in, exclusive, reverse, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable cumprod(SDVariable in, int ... axis) {
        SDValidation.validateNumerical("cumprod", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return new CumProd(this.sd, in, false, false, axis).outputVariable();
    }

    public SDVariable cumprod(String name, SDVariable in, int ... axis) {
        SDValidation.validateNumerical("cumprod", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        SDVariable out = new CumProd(this.sd, in, false, false, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable cumsum(SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        SDValidation.validateNumerical("cumsum", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return new CumSum(this.sd, in, exclusive, reverse, axis).outputVariable();
    }

    public SDVariable cumsum(String name, SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        SDValidation.validateNumerical("cumsum", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        SDVariable out = new CumSum(this.sd, in, exclusive, reverse, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable cumsum(SDVariable in, int ... axis) {
        SDValidation.validateNumerical("cumsum", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return new CumSum(this.sd, in, false, false, axis).outputVariable();
    }

    public SDVariable cumsum(String name, SDVariable in, int ... axis) {
        SDValidation.validateNumerical("cumsum", "in", in);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        SDVariable out = new CumSum(this.sd, in, false, false, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable dot(SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("dot", "x", x);
        SDValidation.validateNumerical("dot", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Dot(this.sd, x, y, dimensions).outputVariable();
    }

    public SDVariable dot(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("dot", "x", x);
        SDValidation.validateNumerical("dot", "y", y);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Dot(this.sd, x, y, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable[] dynamicPartition(SDVariable x, SDVariable partitions, int numPartitions) {
        SDValidation.validateNumerical("dynamicPartition", "x", x);
        SDValidation.validateInteger("dynamicPartition", "partitions", partitions);
        return new DynamicPartition(this.sd, x, partitions, numPartitions).outputVariables();
    }

    public SDVariable[] dynamicPartition(String[] names, SDVariable x, SDVariable partitions, int numPartitions) {
        SDValidation.validateNumerical("dynamicPartition", "x", x);
        SDValidation.validateInteger("dynamicPartition", "partitions", partitions);
        SDVariable[] out = new DynamicPartition(this.sd, x, partitions, numPartitions).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable dynamicStitch(SDVariable[] indices, SDVariable ... x) {
        SDValidation.validateInteger("dynamicStitch", "indices", indices);
        Preconditions.checkArgument((indices.length >= 1 ? 1 : 0) != 0, (String)"indices has incorrect size/length. Expected: indices.length >= 1, got %s", (int)indices.length);
        SDValidation.validateNumerical("dynamicStitch", "x", x);
        Preconditions.checkArgument((x.length >= 1 ? 1 : 0) != 0, (String)"x has incorrect size/length. Expected: x.length >= 1, got %s", (int)x.length);
        return new DynamicStitch(this.sd, indices, x).outputVariable();
    }

    public SDVariable dynamicStitch(String name, SDVariable[] indices, SDVariable ... x) {
        SDValidation.validateInteger("dynamicStitch", "indices", indices);
        Preconditions.checkArgument((indices.length >= 1 ? 1 : 0) != 0, (String)"indices has incorrect size/length. Expected: indices.length >= 1, got %s", (int)indices.length);
        SDValidation.validateNumerical("dynamicStitch", "x", x);
        Preconditions.checkArgument((x.length >= 1 ? 1 : 0) != 0, (String)"x has incorrect size/length. Expected: x.length >= 1, got %s", (int)x.length);
        SDVariable out = new DynamicStitch(this.sd, indices, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable eq(SDVariable x, double y) {
        SDValidation.validateNumerical("eq", "x", x);
        return new ScalarEquals(this.sd, x, (Number)y).outputVariable();
    }

    public SDVariable eq(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("eq", "x", x);
        SDVariable out = new ScalarEquals(this.sd, x, (Number)y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable eq(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("eq", "x", x);
        SDValidation.validateNumerical("eq", "y", y);
        return new EqualTo(this.sd, x, y).outputVariable();
    }

    public SDVariable eq(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("eq", "x", x);
        SDValidation.validateNumerical("eq", "y", y);
        SDVariable out = new EqualTo(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable expandDims(SDVariable x, int axis) {
        return new ExpandDims(this.sd, x, axis).outputVariable();
    }

    public SDVariable expandDims(String name, SDVariable x, int axis) {
        SDVariable out = new ExpandDims(this.sd, x, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable fill(SDVariable shape, DataType dataType, double value) {
        SDValidation.validateInteger("fill", "shape", shape);
        return new Fill(this.sd, shape, dataType, value).outputVariable();
    }

    public SDVariable fill(String name, SDVariable shape, DataType dataType, double value) {
        SDValidation.validateInteger("fill", "shape", shape);
        SDVariable out = new Fill(this.sd, shape, dataType, value).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable gather(SDVariable df, int[] indices, int axis) {
        SDValidation.validateNumerical("gather", "df", df);
        Preconditions.checkArgument((indices.length >= 1 ? 1 : 0) != 0, (String)"indices has incorrect size/length. Expected: indices.length >= 1, got %s", (int)indices.length);
        return new Gather(this.sd, df, indices, axis).outputVariable();
    }

    public SDVariable gather(String name, SDVariable df, int[] indices, int axis) {
        SDValidation.validateNumerical("gather", "df", df);
        Preconditions.checkArgument((indices.length >= 1 ? 1 : 0) != 0, (String)"indices has incorrect size/length. Expected: indices.length >= 1, got %s", (int)indices.length);
        SDVariable out = new Gather(this.sd, df, indices, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable gather(SDVariable df, SDVariable indices, int axis) {
        SDValidation.validateNumerical("gather", "df", df);
        SDValidation.validateInteger("gather", "indices", indices);
        return new Gather(this.sd, df, indices, axis).outputVariable();
    }

    public SDVariable gather(String name, SDVariable df, SDVariable indices, int axis) {
        SDValidation.validateNumerical("gather", "df", df);
        SDValidation.validateInteger("gather", "indices", indices);
        SDVariable out = new Gather(this.sd, df, indices, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable gatherNd(SDVariable df, SDVariable indices) {
        SDValidation.validateNumerical("gatherNd", "df", df);
        SDValidation.validateNumerical("gatherNd", "indices", indices);
        return new GatherNd(this.sd, df, indices).outputVariable();
    }

    public SDVariable gatherNd(String name, SDVariable df, SDVariable indices) {
        SDValidation.validateNumerical("gatherNd", "df", df);
        SDValidation.validateNumerical("gatherNd", "indices", indices);
        SDVariable out = new GatherNd(this.sd, df, indices).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable gt(SDVariable x, double y) {
        SDValidation.validateNumerical("gt", "x", x);
        return new ScalarGreaterThan(this.sd, x, (Number)y).outputVariable();
    }

    public SDVariable gt(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("gt", "x", x);
        SDVariable out = new ScalarGreaterThan(this.sd, x, (Number)y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable gt(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("gt", "x", x);
        SDValidation.validateNumerical("gt", "y", y);
        return new GreaterThan(this.sd, x, y).outputVariable();
    }

    public SDVariable gt(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("gt", "x", x);
        SDValidation.validateNumerical("gt", "y", y);
        SDVariable out = new GreaterThan(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable gte(SDVariable x, double y) {
        SDValidation.validateNumerical("gte", "x", x);
        return new ScalarGreaterThanOrEqual(this.sd, x, (Number)y).outputVariable();
    }

    public SDVariable gte(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("gte", "x", x);
        SDVariable out = new ScalarGreaterThanOrEqual(this.sd, x, (Number)y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable gte(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("gte", "x", x);
        SDValidation.validateNumerical("gte", "y", y);
        return new GreaterThanOrEqual(this.sd, x, y).outputVariable();
    }

    public SDVariable gte(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("gte", "x", x);
        SDValidation.validateNumerical("gte", "y", y);
        SDVariable out = new GreaterThanOrEqual(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable identity(SDVariable input) {
        SDValidation.validateNumerical("identity", "input", input);
        return new Identity(this.sd, input).outputVariable();
    }

    public SDVariable identity(String name, SDVariable input) {
        SDValidation.validateNumerical("identity", "input", input);
        SDVariable out = new Identity(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable invertPermutation(SDVariable input) {
        SDValidation.validateInteger("invertPermutation", "input", input);
        return new InvertPermutation(this.sd, input).outputVariable();
    }

    public SDVariable invertPermutation(String name, SDVariable input) {
        SDValidation.validateInteger("invertPermutation", "input", input);
        SDVariable out = new InvertPermutation(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable isNumericTensor(SDVariable x) {
        SDValidation.validateNumerical("isNumericTensor", "x", x);
        return new IsNumericTensor(this.sd, x).outputVariable();
    }

    public SDVariable isNumericTensor(String name, SDVariable x) {
        SDValidation.validateNumerical("isNumericTensor", "x", x);
        SDVariable out = new IsNumericTensor(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable linspace(DataType dataType, double start, double stop, long number) {
        return new Linspace(this.sd, dataType, start, stop, number).outputVariable();
    }

    public SDVariable linspace(String name, DataType dataType, double start, double stop, long number) {
        SDVariable out = new Linspace(this.sd, dataType, start, stop, number).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable linspace(SDVariable start, SDVariable stop, SDVariable number, DataType dataType) {
        SDValidation.validateNumerical("linspace", "start", start);
        SDValidation.validateNumerical("linspace", "stop", stop);
        SDValidation.validateInteger("linspace", "number", number);
        return new Linspace(this.sd, start, stop, number, dataType).outputVariable();
    }

    public SDVariable linspace(String name, SDVariable start, SDVariable stop, SDVariable number, DataType dataType) {
        SDValidation.validateNumerical("linspace", "start", start);
        SDValidation.validateNumerical("linspace", "stop", stop);
        SDValidation.validateInteger("linspace", "number", number);
        SDVariable out = new Linspace(this.sd, start, stop, number, dataType).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable lt(SDVariable x, double y) {
        SDValidation.validateNumerical("lt", "x", x);
        return new ScalarLessThan(this.sd, x, y).outputVariable();
    }

    public SDVariable lt(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("lt", "x", x);
        SDVariable out = new ScalarLessThan(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable lt(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("lt", "x", x);
        SDValidation.validateNumerical("lt", "y", y);
        return new LessThan(this.sd, x, y).outputVariable();
    }

    public SDVariable lt(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("lt", "x", x);
        SDValidation.validateNumerical("lt", "y", y);
        SDVariable out = new LessThan(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable lte(SDVariable x, double y) {
        SDValidation.validateNumerical("lte", "x", x);
        return new ScalarLessThanOrEqual(this.sd, x, (Number)y).outputVariable();
    }

    public SDVariable lte(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("lte", "x", x);
        SDVariable out = new ScalarLessThanOrEqual(this.sd, x, (Number)y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable lte(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("lte", "x", x);
        SDValidation.validateNumerical("lte", "y", y);
        return new LessThanOrEqual(this.sd, x, y).outputVariable();
    }

    public SDVariable lte(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("lte", "x", x);
        SDValidation.validateNumerical("lte", "y", y);
        SDVariable out = new LessThanOrEqual(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable matchCondition(SDVariable in, Condition condition) {
        SDValidation.validateNumerical("matchCondition", "in", in);
        return new MatchConditionTransform(this.sd, in, condition).outputVariable();
    }

    public SDVariable matchCondition(String name, SDVariable in, Condition condition) {
        SDValidation.validateNumerical("matchCondition", "in", in);
        SDVariable out = new MatchConditionTransform(this.sd, in, condition).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable matchConditionCount(SDVariable in, Condition condition) {
        SDValidation.validateNumerical("matchConditionCount", "in", in);
        return new MatchCondition(this.sd, in, condition).outputVariable();
    }

    public SDVariable matchConditionCount(String name, SDVariable in, Condition condition) {
        SDValidation.validateNumerical("matchConditionCount", "in", in);
        SDVariable out = new MatchCondition(this.sd, in, condition).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable matchConditionCount(SDVariable in, Condition condition, boolean keepDim, int ... dimensions) {
        SDValidation.validateNumerical("matchConditionCount", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new MatchCondition(this.sd, in, condition, keepDim, dimensions).outputVariable();
    }

    public SDVariable matchConditionCount(String name, SDVariable in, Condition condition, boolean keepDim, int ... dimensions) {
        SDValidation.validateNumerical("matchConditionCount", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new MatchCondition(this.sd, in, condition, keepDim, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable matchConditionCount(SDVariable in, Condition condition, int ... dimensions) {
        SDValidation.validateNumerical("matchConditionCount", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new MatchCondition(this.sd, in, condition, false, dimensions).outputVariable();
    }

    public SDVariable matchConditionCount(String name, SDVariable in, Condition condition, int ... dimensions) {
        SDValidation.validateNumerical("matchConditionCount", "in", in);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new MatchCondition(this.sd, in, condition, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable max(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("max", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new org.nd4j.linalg.api.ops.impl.reduce.same.Max(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable max(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("max", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new org.nd4j.linalg.api.ops.impl.reduce.same.Max(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable max(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("max", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new org.nd4j.linalg.api.ops.impl.reduce.same.Max(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable max(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("max", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new org.nd4j.linalg.api.ops.impl.reduce.same.Max(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable max(SDVariable first, SDVariable second) {
        SDValidation.validateNumerical("max", "first", first);
        SDValidation.validateNumerical("max", "second", second);
        return new Max(this.sd, first, second).outputVariable();
    }

    public SDVariable max(String name, SDVariable first, SDVariable second) {
        SDValidation.validateNumerical("max", "first", first);
        SDValidation.validateNumerical("max", "second", second);
        SDVariable out = new Max(this.sd, first, second).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable mean(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("mean", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Mean(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable mean(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("mean", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Mean(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable mean(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("mean", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Mean(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable mean(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("mean", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Mean(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable merge(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("merge", "x", x);
        SDValidation.validateNumerical("merge", "y", y);
        return new Merge(this.sd, x, y).outputVariable();
    }

    public SDVariable merge(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("merge", "x", x);
        SDValidation.validateNumerical("merge", "y", y);
        SDVariable out = new Merge(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable min(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("min", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Min(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable min(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("min", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Min(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable min(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("min", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Min(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable min(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("min", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Min(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable min(SDVariable first, SDVariable second) {
        SDValidation.validateNumerical("min", "first", first);
        SDValidation.validateNumerical("min", "second", second);
        return new org.nd4j.linalg.api.ops.impl.transforms.custom.Min(this.sd, first, second).outputVariable();
    }

    public SDVariable min(String name, SDVariable first, SDVariable second) {
        SDValidation.validateNumerical("min", "first", first);
        SDValidation.validateNumerical("min", "second", second);
        SDVariable out = new org.nd4j.linalg.api.ops.impl.transforms.custom.Min(this.sd, first, second).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable mmul(SDVariable x, SDVariable y, boolean transposeX, boolean transposeY, boolean transposeZ) {
        SDValidation.validateNumerical("mmul", "x", x);
        SDValidation.validateNumerical("mmul", "y", y);
        return new Mmul(this.sd, x, y, transposeX, transposeY, transposeZ).outputVariable();
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y, boolean transposeX, boolean transposeY, boolean transposeZ) {
        SDValidation.validateNumerical("mmul", "x", x);
        SDValidation.validateNumerical("mmul", "y", y);
        SDVariable out = new Mmul(this.sd, x, y, transposeX, transposeY, transposeZ).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable mmul(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("mmul", "x", x);
        SDValidation.validateNumerical("mmul", "y", y);
        return new Mmul(this.sd, x, y, false, false, false).outputVariable();
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("mmul", "x", x);
        SDValidation.validateNumerical("mmul", "y", y);
        SDVariable out = new Mmul(this.sd, x, y, false, false, false).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable neq(SDVariable x, double y) {
        SDValidation.validateNumerical("neq", "x", x);
        return new ScalarNotEquals(this.sd, x, (Number)y).outputVariable();
    }

    public SDVariable neq(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("neq", "x", x);
        SDVariable out = new ScalarNotEquals(this.sd, x, (Number)y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable neq(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("neq", "x", x);
        SDValidation.validateNumerical("neq", "y", y);
        return new NotEqualTo(this.sd, x, y).outputVariable();
    }

    public SDVariable neq(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("neq", "x", x);
        SDValidation.validateNumerical("neq", "y", y);
        SDVariable out = new NotEqualTo(this.sd, x, y).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable norm1(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("norm1", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Norm1(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable norm1(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("norm1", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Norm1(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable norm1(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("norm1", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Norm1(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable norm1(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("norm1", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Norm1(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable norm2(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("norm2", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Norm2(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable norm2(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("norm2", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Norm2(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable norm2(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("norm2", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Norm2(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable norm2(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("norm2", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Norm2(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable normmax(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("normmax", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new NormMax(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable normmax(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("normmax", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new NormMax(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable normmax(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("normmax", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new NormMax(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable normmax(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("normmax", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new NormMax(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable oneHot(SDVariable indices, int depth, int axis, double on, double off, DataType dataType) {
        SDValidation.validateNumerical("oneHot", "indices", indices);
        return new OneHot(this.sd, indices, depth, axis, on, off, dataType).outputVariable();
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth, int axis, double on, double off, DataType dataType) {
        SDValidation.validateNumerical("oneHot", "indices", indices);
        SDVariable out = new OneHot(this.sd, indices, depth, axis, on, off, dataType).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable oneHot(SDVariable indices, int depth, int axis, double on, double off) {
        SDValidation.validateNumerical("oneHot", "indices", indices);
        return new OneHot(this.sd, indices, depth, axis, on, off, DataType.FLOAT).outputVariable();
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth, int axis, double on, double off) {
        SDValidation.validateNumerical("oneHot", "indices", indices);
        SDVariable out = new OneHot(this.sd, indices, depth, axis, on, off, DataType.FLOAT).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable oneHot(SDVariable indices, int depth) {
        SDValidation.validateNumerical("oneHot", "indices", indices);
        return new OneHot(this.sd, indices, depth).outputVariable();
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth) {
        SDValidation.validateNumerical("oneHot", "indices", indices);
        SDVariable out = new OneHot(this.sd, indices, depth).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable onesLike(SDVariable input) {
        SDValidation.validateNumerical("onesLike", "input", input);
        return new OnesLike(this.sd, input).outputVariable();
    }

    public SDVariable onesLike(String name, SDVariable input) {
        SDValidation.validateNumerical("onesLike", "input", input);
        SDVariable out = new OnesLike(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable onesLike(SDVariable input, DataType dataType) {
        SDValidation.validateNumerical("onesLike", "input", input);
        return new OnesLike(this.sd, input, dataType).outputVariable();
    }

    public SDVariable onesLike(String name, SDVariable input, DataType dataType) {
        SDValidation.validateNumerical("onesLike", "input", input);
        SDVariable out = new OnesLike(this.sd, input, dataType).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable permute(SDVariable x, SDVariable dimensions) {
        SDValidation.validateNumerical("permute", "x", x);
        SDValidation.validateInteger("permute", "dimensions", dimensions);
        return new Permute(this.sd, x, dimensions).outputVariable();
    }

    public SDVariable permute(String name, SDVariable x, SDVariable dimensions) {
        SDValidation.validateNumerical("permute", "x", x);
        SDValidation.validateInteger("permute", "dimensions", dimensions);
        SDVariable out = new Permute(this.sd, x, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable permute(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("permute", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Permute(this.sd, x, dimensions).outputVariable();
    }

    public SDVariable permute(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("permute", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Permute(this.sd, x, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable prod(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("prod", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Prod(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable prod(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("prod", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Prod(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable prod(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("prod", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Prod(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable prod(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("prod", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Prod(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable range(double from, double to, double step, DataType dataType) {
        return new Range(this.sd, from, to, step, dataType).outputVariable();
    }

    public SDVariable range(String name, double from, double to, double step, DataType dataType) {
        SDVariable out = new Range(this.sd, from, to, step, dataType).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable range(SDVariable from, SDVariable to, SDVariable step, DataType dataType) {
        SDValidation.validateNumerical("range", "from", from);
        SDValidation.validateNumerical("range", "to", to);
        SDValidation.validateNumerical("range", "step", step);
        return new Range(this.sd, from, to, step, dataType).outputVariable();
    }

    public SDVariable range(String name, SDVariable from, SDVariable to, SDVariable step, DataType dataType) {
        SDValidation.validateNumerical("range", "from", from);
        SDValidation.validateNumerical("range", "to", to);
        SDValidation.validateNumerical("range", "step", step);
        SDVariable out = new Range(this.sd, from, to, step, dataType).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable rank(SDVariable in) {
        SDValidation.validateNumerical("rank", "in", in);
        return new Rank(this.sd, in).outputVariable();
    }

    public SDVariable rank(String name, SDVariable in) {
        SDValidation.validateNumerical("rank", "in", in);
        SDVariable out = new Rank(this.sd, in).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable replaceWhere(SDVariable update, SDVariable from, Condition condition) {
        SDValidation.validateNumerical("replaceWhere", "update", update);
        SDValidation.validateNumerical("replaceWhere", "from", from);
        return new CompareAndReplace(this.sd, update, from, condition).outputVariable();
    }

    public SDVariable replaceWhere(String name, SDVariable update, SDVariable from, Condition condition) {
        SDValidation.validateNumerical("replaceWhere", "update", update);
        SDValidation.validateNumerical("replaceWhere", "from", from);
        SDVariable out = new CompareAndReplace(this.sd, update, from, condition).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable replaceWhere(SDVariable update, double value, Condition condition) {
        SDValidation.validateNumerical("replaceWhere", "update", update);
        return new CompareAndSet(this.sd, update, (Number)value, condition).outputVariable();
    }

    public SDVariable replaceWhere(String name, SDVariable update, double value, Condition condition) {
        SDValidation.validateNumerical("replaceWhere", "update", update);
        SDVariable out = new CompareAndSet(this.sd, update, (Number)value, condition).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable reshape(SDVariable x, SDVariable shape) {
        SDValidation.validateNumerical("reshape", "x", x);
        SDValidation.validateNumerical("reshape", "shape", shape);
        return new Reshape(this.sd, x, shape).outputVariable();
    }

    public SDVariable reshape(String name, SDVariable x, SDVariable shape) {
        SDValidation.validateNumerical("reshape", "x", x);
        SDValidation.validateNumerical("reshape", "shape", shape);
        SDVariable out = new Reshape(this.sd, x, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable reshape(SDVariable x, long ... shape) {
        SDValidation.validateNumerical("reshape", "x", x);
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        return new Reshape(this.sd, x, shape).outputVariable();
    }

    public SDVariable reshape(String name, SDVariable x, long ... shape) {
        SDValidation.validateNumerical("reshape", "x", x);
        Preconditions.checkArgument((shape.length >= 0 ? 1 : 0) != 0, (String)"shape has incorrect size/length. Expected: shape.length >= 0, got %s", (int)shape.length);
        SDVariable out = new Reshape(this.sd, x, shape).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable reverse(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("reverse", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Reverse(this.sd, x, dimensions).outputVariable();
    }

    public SDVariable reverse(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("reverse", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Reverse(this.sd, x, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths, int seqDim, int batchDim) {
        SDValidation.validateNumerical("reverseSequence", "x", x);
        SDValidation.validateInteger("reverseSequence", "seq_lengths", seq_lengths);
        return new ReverseSequence(this.sd, x, seq_lengths, seqDim, batchDim).outputVariable();
    }

    public SDVariable reverseSequence(String name, SDVariable x, SDVariable seq_lengths, int seqDim, int batchDim) {
        SDValidation.validateNumerical("reverseSequence", "x", x);
        SDValidation.validateInteger("reverseSequence", "seq_lengths", seq_lengths);
        SDVariable out = new ReverseSequence(this.sd, x, seq_lengths, seqDim, batchDim).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths) {
        SDValidation.validateNumerical("reverseSequence", "x", x);
        SDValidation.validateInteger("reverseSequence", "seq_lengths", seq_lengths);
        return new ReverseSequence(this.sd, x, seq_lengths, -1, 0).outputVariable();
    }

    public SDVariable reverseSequence(String name, SDVariable x, SDVariable seq_lengths) {
        SDValidation.validateNumerical("reverseSequence", "x", x);
        SDValidation.validateInteger("reverseSequence", "seq_lengths", seq_lengths);
        SDVariable out = new ReverseSequence(this.sd, x, seq_lengths, -1, 0).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scalarFloorMod(SDVariable in, double value) {
        SDValidation.validateNumerical("scalarFloorMod", "in", in);
        return new ScalarFMod(this.sd, in, (Number)value).outputVariable();
    }

    public SDVariable scalarFloorMod(String name, SDVariable in, double value) {
        SDValidation.validateNumerical("scalarFloorMod", "in", in);
        SDVariable out = new ScalarFMod(this.sd, in, (Number)value).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scalarMax(SDVariable in, double value) {
        SDValidation.validateNumerical("scalarMax", "in", in);
        return new ScalarMax(this.sd, in, (Number)value).outputVariable();
    }

    public SDVariable scalarMax(String name, SDVariable in, double value) {
        SDValidation.validateNumerical("scalarMax", "in", in);
        SDVariable out = new ScalarMax(this.sd, in, (Number)value).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scalarMin(SDVariable in, double value) {
        SDValidation.validateNumerical("scalarMin", "in", in);
        return new ScalarMin(this.sd, in, (Number)value).outputVariable();
    }

    public SDVariable scalarMin(String name, SDVariable in, double value) {
        SDValidation.validateNumerical("scalarMin", "in", in);
        SDVariable out = new ScalarMin(this.sd, in, (Number)value).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scalarSet(SDVariable in, double set) {
        SDValidation.validateNumerical("scalarSet", "in", in);
        return new ScalarSet(this.sd, in, (Number)set).outputVariable();
    }

    public SDVariable scalarSet(String name, SDVariable in, double set) {
        SDValidation.validateNumerical("scalarSet", "in", in);
        SDVariable out = new ScalarSet(this.sd, in, (Number)set).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scatterAdd(SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterAdd", "ref", ref);
        SDValidation.validateNumerical("scatterAdd", "indices", indices);
        SDValidation.validateNumerical("scatterAdd", "updates", updates);
        return new ScatterAdd(this.sd, ref, indices, updates).outputVariable();
    }

    public SDVariable scatterAdd(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterAdd", "ref", ref);
        SDValidation.validateNumerical("scatterAdd", "indices", indices);
        SDValidation.validateNumerical("scatterAdd", "updates", updates);
        SDVariable out = new ScatterAdd(this.sd, ref, indices, updates).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scatterDiv(SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterDiv", "ref", ref);
        SDValidation.validateNumerical("scatterDiv", "indices", indices);
        SDValidation.validateNumerical("scatterDiv", "updates", updates);
        return new ScatterDiv(this.sd, ref, indices, updates).outputVariable();
    }

    public SDVariable scatterDiv(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterDiv", "ref", ref);
        SDValidation.validateNumerical("scatterDiv", "indices", indices);
        SDValidation.validateNumerical("scatterDiv", "updates", updates);
        SDVariable out = new ScatterDiv(this.sd, ref, indices, updates).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scatterMax(SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterMax", "ref", ref);
        SDValidation.validateNumerical("scatterMax", "indices", indices);
        SDValidation.validateNumerical("scatterMax", "updates", updates);
        return new ScatterMax(this.sd, ref, indices, updates).outputVariable();
    }

    public SDVariable scatterMax(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterMax", "ref", ref);
        SDValidation.validateNumerical("scatterMax", "indices", indices);
        SDValidation.validateNumerical("scatterMax", "updates", updates);
        SDVariable out = new ScatterMax(this.sd, ref, indices, updates).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scatterMin(SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterMin", "ref", ref);
        SDValidation.validateNumerical("scatterMin", "indices", indices);
        SDValidation.validateNumerical("scatterMin", "updates", updates);
        return new ScatterMin(this.sd, ref, indices, updates).outputVariable();
    }

    public SDVariable scatterMin(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterMin", "ref", ref);
        SDValidation.validateNumerical("scatterMin", "indices", indices);
        SDValidation.validateNumerical("scatterMin", "updates", updates);
        SDVariable out = new ScatterMin(this.sd, ref, indices, updates).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scatterMul(SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterMul", "ref", ref);
        SDValidation.validateNumerical("scatterMul", "indices", indices);
        SDValidation.validateNumerical("scatterMul", "updates", updates);
        return new ScatterMul(this.sd, ref, indices, updates).outputVariable();
    }

    public SDVariable scatterMul(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterMul", "ref", ref);
        SDValidation.validateNumerical("scatterMul", "indices", indices);
        SDValidation.validateNumerical("scatterMul", "updates", updates);
        SDVariable out = new ScatterMul(this.sd, ref, indices, updates).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scatterSub(SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterSub", "ref", ref);
        SDValidation.validateNumerical("scatterSub", "indices", indices);
        SDValidation.validateNumerical("scatterSub", "updates", updates);
        return new ScatterSub(this.sd, ref, indices, updates).outputVariable();
    }

    public SDVariable scatterSub(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterSub", "ref", ref);
        SDValidation.validateNumerical("scatterSub", "indices", indices);
        SDValidation.validateNumerical("scatterSub", "updates", updates);
        SDVariable out = new ScatterSub(this.sd, ref, indices, updates).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable scatterUpdate(SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterUpdate", "ref", ref);
        SDValidation.validateNumerical("scatterUpdate", "indices", indices);
        SDValidation.validateNumerical("scatterUpdate", "updates", updates);
        return new ScatterUpdate(this.sd, ref, indices, updates).outputVariable();
    }

    public SDVariable scatterUpdate(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateNumerical("scatterUpdate", "ref", ref);
        SDValidation.validateNumerical("scatterUpdate", "indices", indices);
        SDValidation.validateNumerical("scatterUpdate", "updates", updates);
        SDVariable out = new ScatterUpdate(this.sd, ref, indices, updates).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable segmentMax(SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMax", "segmentIds", segmentIds);
        return new SegmentMax(this.sd, data, segmentIds).outputVariable();
    }

    public SDVariable segmentMax(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMax", "segmentIds", segmentIds);
        SDVariable out = new SegmentMax(this.sd, data, segmentIds).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable segmentMean(SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMean", "segmentIds", segmentIds);
        return new SegmentMean(this.sd, data, segmentIds).outputVariable();
    }

    public SDVariable segmentMean(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMean", "segmentIds", segmentIds);
        SDVariable out = new SegmentMean(this.sd, data, segmentIds).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable segmentMin(SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMin", "segmentIds", segmentIds);
        return new SegmentMin(this.sd, data, segmentIds).outputVariable();
    }

    public SDVariable segmentMin(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMin", "segmentIds", segmentIds);
        SDVariable out = new SegmentMin(this.sd, data, segmentIds).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable segmentProd(SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentProd", "segmentIds", segmentIds);
        return new SegmentProd(this.sd, data, segmentIds).outputVariable();
    }

    public SDVariable segmentProd(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentProd", "segmentIds", segmentIds);
        SDVariable out = new SegmentProd(this.sd, data, segmentIds).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable segmentSum(SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentSum", "segmentIds", segmentIds);
        return new SegmentSum(this.sd, data, segmentIds).outputVariable();
    }

    public SDVariable segmentSum(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentSum", "segmentIds", segmentIds);
        SDVariable out = new SegmentSum(this.sd, data, segmentIds).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, int maxLen, DataType dataType) {
        SDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        return new SequenceMask(this.sd, lengths, maxLen, dataType).outputVariable();
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, int maxLen, DataType dataType) {
        SDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        SDVariable out = new SequenceMask(this.sd, lengths, maxLen, dataType).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, SDVariable maxLen, DataType dataType) {
        SDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        SDValidation.validateInteger("sequenceMask", "maxLen", maxLen);
        return new SequenceMask(this.sd, lengths, maxLen, dataType).outputVariable();
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, SDVariable maxLen, DataType dataType) {
        SDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        SDValidation.validateInteger("sequenceMask", "maxLen", maxLen);
        SDVariable out = new SequenceMask(this.sd, lengths, maxLen, dataType).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, DataType dataType) {
        SDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        return new SequenceMask(this.sd, lengths, dataType).outputVariable();
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, DataType dataType) {
        SDValidation.validateNumerical("sequenceMask", "lengths", lengths);
        SDVariable out = new SequenceMask(this.sd, lengths, dataType).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable shape(SDVariable input) {
        SDValidation.validateNumerical("shape", "input", input);
        return new Shape(this.sd, input).outputVariable();
    }

    public SDVariable shape(String name, SDVariable input) {
        SDValidation.validateNumerical("shape", "input", input);
        SDVariable out = new Shape(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable size(SDVariable in) {
        SDValidation.validateNumerical("size", "in", in);
        return new Size(this.sd, in).outputVariable();
    }

    public SDVariable size(String name, SDVariable in) {
        SDValidation.validateNumerical("size", "in", in);
        SDVariable out = new Size(this.sd, in).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sizeAt(SDVariable in, int dimension) {
        SDValidation.validateNumerical("sizeAt", "in", in);
        return new SizeAt(this.sd, in, dimension).outputVariable();
    }

    public SDVariable sizeAt(String name, SDVariable in, int dimension) {
        SDValidation.validateNumerical("sizeAt", "in", in);
        SDVariable out = new SizeAt(this.sd, in, dimension).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable slice(SDVariable input, int[] begin, int ... size) {
        SDValidation.validateNumerical("slice", "input", input);
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((size.length >= 1 ? 1 : 0) != 0, (String)"size has incorrect size/length. Expected: size.length >= 1, got %s", (int)size.length);
        return new Slice(this.sd, input, begin, size).outputVariable();
    }

    public SDVariable slice(String name, SDVariable input, int[] begin, int ... size) {
        SDValidation.validateNumerical("slice", "input", input);
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((size.length >= 1 ? 1 : 0) != 0, (String)"size has incorrect size/length. Expected: size.length >= 1, got %s", (int)size.length);
        SDVariable out = new Slice(this.sd, input, begin, size).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable slice(SDVariable input, SDVariable begin, SDVariable size) {
        SDValidation.validateNumerical("slice", "input", input);
        SDValidation.validateInteger("slice", "begin", begin);
        SDValidation.validateInteger("slice", "size", size);
        return new Slice(this.sd, input, begin, size).outputVariable();
    }

    public SDVariable slice(String name, SDVariable input, SDVariable begin, SDVariable size) {
        SDValidation.validateNumerical("slice", "input", input);
        SDValidation.validateInteger("slice", "begin", begin);
        SDValidation.validateInteger("slice", "size", size);
        SDVariable out = new Slice(this.sd, input, begin, size).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable[] split(SDVariable input, int numSplit, int splitDim) {
        SDValidation.validateNumerical("split", "input", input);
        return new Split(this.sd, input, numSplit, splitDim).outputVariables();
    }

    public SDVariable[] split(String[] names, SDVariable input, int numSplit, int splitDim) {
        SDValidation.validateNumerical("split", "input", input);
        SDVariable[] out = new Split(this.sd, input, numSplit, splitDim).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable squaredNorm(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("squaredNorm", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new SquaredNorm(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable squaredNorm(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("squaredNorm", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new SquaredNorm(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable squaredNorm(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("squaredNorm", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new SquaredNorm(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable squaredNorm(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("squaredNorm", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new SquaredNorm(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable squeeze(SDVariable x, int axis) {
        SDValidation.validateNumerical("squeeze", "x", x);
        return new Squeeze(this.sd, x, axis).outputVariable();
    }

    public SDVariable squeeze(String name, SDVariable x, int axis) {
        SDValidation.validateNumerical("squeeze", "x", x);
        SDVariable out = new Squeeze(this.sd, x, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable stack(int axis, SDVariable ... values) {
        Preconditions.checkArgument((values.length >= 1 ? 1 : 0) != 0, (String)"values has incorrect size/length. Expected: values.length >= 1, got %s", (int)values.length);
        return new Stack(this.sd, values, axis).outputVariable();
    }

    public SDVariable stack(String name, int axis, SDVariable ... values) {
        Preconditions.checkArgument((values.length >= 1 ? 1 : 0) != 0, (String)"values has incorrect size/length. Expected: values.length >= 1, got %s", (int)values.length);
        SDVariable out = new Stack(this.sd, values, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable standardDeviation(SDVariable x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("standardDeviation", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new StandardDeviation(this.sd, x, biasCorrected, keepDims, dimensions).outputVariable();
    }

    public SDVariable standardDeviation(String name, SDVariable x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("standardDeviation", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new StandardDeviation(this.sd, x, biasCorrected, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable standardDeviation(SDVariable x, boolean biasCorrected, int ... dimensions) {
        SDValidation.validateNumerical("standardDeviation", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new StandardDeviation(this.sd, x, biasCorrected, false, dimensions).outputVariable();
    }

    public SDVariable standardDeviation(String name, SDVariable x, boolean biasCorrected, int ... dimensions) {
        SDValidation.validateNumerical("standardDeviation", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new StandardDeviation(this.sd, x, biasCorrected, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable stridedSlice(SDVariable in, long[] begin, long[] end, long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        SDValidation.validateNumerical("stridedSlice", "in", in);
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((end.length >= 1 ? 1 : 0) != 0, (String)"end has incorrect size/length. Expected: end.length >= 1, got %s", (int)end.length);
        Preconditions.checkArgument((strides.length >= 1 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length >= 1, got %s", (int)strides.length);
        return new StridedSlice(this.sd, in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask).outputVariable();
    }

    public SDVariable stridedSlice(String name, SDVariable in, long[] begin, long[] end, long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        SDValidation.validateNumerical("stridedSlice", "in", in);
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((end.length >= 1 ? 1 : 0) != 0, (String)"end has incorrect size/length. Expected: end.length >= 1, got %s", (int)end.length);
        Preconditions.checkArgument((strides.length >= 1 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length >= 1, got %s", (int)strides.length);
        SDVariable out = new StridedSlice(this.sd, in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable stridedSlice(SDVariable in, long[] begin, long[] end, long ... strides) {
        SDValidation.validateNumerical("stridedSlice", "in", in);
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((end.length >= 1 ? 1 : 0) != 0, (String)"end has incorrect size/length. Expected: end.length >= 1, got %s", (int)end.length);
        Preconditions.checkArgument((strides.length >= 1 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length >= 1, got %s", (int)strides.length);
        return new StridedSlice(this.sd, in, begin, end, strides, 0, 0, 0, 0, 0).outputVariable();
    }

    public SDVariable stridedSlice(String name, SDVariable in, long[] begin, long[] end, long ... strides) {
        SDValidation.validateNumerical("stridedSlice", "in", in);
        Preconditions.checkArgument((begin.length >= 1 ? 1 : 0) != 0, (String)"begin has incorrect size/length. Expected: begin.length >= 1, got %s", (int)begin.length);
        Preconditions.checkArgument((end.length >= 1 ? 1 : 0) != 0, (String)"end has incorrect size/length. Expected: end.length >= 1, got %s", (int)end.length);
        Preconditions.checkArgument((strides.length >= 1 ? 1 : 0) != 0, (String)"strides has incorrect size/length. Expected: strides.length >= 1, got %s", (int)strides.length);
        SDVariable out = new StridedSlice(this.sd, in, begin, end, strides, 0, 0, 0, 0, 0).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sum(SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("sum", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Sum(this.sd, x, keepDims, dimensions).outputVariable();
    }

    public SDVariable sum(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("sum", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Sum(this.sd, x, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sum(SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("sum", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Sum(this.sd, x, false, dimensions).outputVariable();
    }

    public SDVariable sum(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("sum", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Sum(this.sd, x, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable[] switchOp(SDVariable x, SDVariable predicate) {
        SDValidation.validateBool("switchOp", "predicate", predicate);
        return new Switch(this.sd, x, predicate).outputVariables();
    }

    public SDVariable[] switchOp(String[] names, SDVariable x, SDVariable predicate) {
        SDValidation.validateBool("switchOp", "predicate", predicate);
        SDVariable[] out = new Switch(this.sd, x, predicate).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable tensorMmul(SDVariable x, SDVariable y, int[] dimensionsX, int[] dimensionsY, boolean transposeX, boolean transposeY, boolean transposeZ) {
        SDValidation.validateNumerical("tensorMmul", "x", x);
        SDValidation.validateNumerical("tensorMmul", "y", y);
        Preconditions.checkArgument((dimensionsX.length >= 1 ? 1 : 0) != 0, (String)"dimensionsX has incorrect size/length. Expected: dimensionsX.length >= 1, got %s", (int)dimensionsX.length);
        Preconditions.checkArgument((dimensionsY.length >= 1 ? 1 : 0) != 0, (String)"dimensionsY has incorrect size/length. Expected: dimensionsY.length >= 1, got %s", (int)dimensionsY.length);
        return new TensorMmul(this.sd, x, y, dimensionsX, dimensionsY, transposeX, transposeY, transposeZ).outputVariable();
    }

    public SDVariable tensorMmul(String name, SDVariable x, SDVariable y, int[] dimensionsX, int[] dimensionsY, boolean transposeX, boolean transposeY, boolean transposeZ) {
        SDValidation.validateNumerical("tensorMmul", "x", x);
        SDValidation.validateNumerical("tensorMmul", "y", y);
        Preconditions.checkArgument((dimensionsX.length >= 1 ? 1 : 0) != 0, (String)"dimensionsX has incorrect size/length. Expected: dimensionsX.length >= 1, got %s", (int)dimensionsX.length);
        Preconditions.checkArgument((dimensionsY.length >= 1 ? 1 : 0) != 0, (String)"dimensionsY has incorrect size/length. Expected: dimensionsY.length >= 1, got %s", (int)dimensionsY.length);
        SDVariable out = new TensorMmul(this.sd, x, y, dimensionsX, dimensionsY, transposeX, transposeY, transposeZ).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable tensorMmul(SDVariable x, SDVariable y, int[] dimensionsX, int ... dimensionsY) {
        SDValidation.validateNumerical("tensorMmul", "x", x);
        SDValidation.validateNumerical("tensorMmul", "y", y);
        Preconditions.checkArgument((dimensionsX.length >= 1 ? 1 : 0) != 0, (String)"dimensionsX has incorrect size/length. Expected: dimensionsX.length >= 1, got %s", (int)dimensionsX.length);
        Preconditions.checkArgument((dimensionsY.length >= 1 ? 1 : 0) != 0, (String)"dimensionsY has incorrect size/length. Expected: dimensionsY.length >= 1, got %s", (int)dimensionsY.length);
        return new TensorMmul(this.sd, x, y, dimensionsX, dimensionsY, false, false, false).outputVariable();
    }

    public SDVariable tensorMmul(String name, SDVariable x, SDVariable y, int[] dimensionsX, int ... dimensionsY) {
        SDValidation.validateNumerical("tensorMmul", "x", x);
        SDValidation.validateNumerical("tensorMmul", "y", y);
        Preconditions.checkArgument((dimensionsX.length >= 1 ? 1 : 0) != 0, (String)"dimensionsX has incorrect size/length. Expected: dimensionsX.length >= 1, got %s", (int)dimensionsX.length);
        Preconditions.checkArgument((dimensionsY.length >= 1 ? 1 : 0) != 0, (String)"dimensionsY has incorrect size/length. Expected: dimensionsY.length >= 1, got %s", (int)dimensionsY.length);
        SDVariable out = new TensorMmul(this.sd, x, y, dimensionsX, dimensionsY, false, false, false).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable tile(SDVariable x, SDVariable repeat) {
        SDValidation.validateInteger("tile", "repeat", repeat);
        return new Tile(this.sd, x, repeat).outputVariable();
    }

    public SDVariable tile(String name, SDVariable x, SDVariable repeat) {
        SDValidation.validateInteger("tile", "repeat", repeat);
        SDVariable out = new Tile(this.sd, x, repeat).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable tile(SDVariable x, int ... repeat) {
        Preconditions.checkArgument((repeat.length >= 1 ? 1 : 0) != 0, (String)"repeat has incorrect size/length. Expected: repeat.length >= 1, got %s", (int)repeat.length);
        return new Tile(this.sd, x, repeat).outputVariable();
    }

    public SDVariable tile(String name, SDVariable x, int ... repeat) {
        Preconditions.checkArgument((repeat.length >= 1 ? 1 : 0) != 0, (String)"repeat has incorrect size/length. Expected: repeat.length >= 1, got %s", (int)repeat.length);
        SDVariable out = new Tile(this.sd, x, repeat).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable transpose(SDVariable x) {
        return new Transpose(this.sd, x).outputVariable();
    }

    public SDVariable transpose(String name, SDVariable x) {
        SDVariable out = new Transpose(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable unsortedSegmentMax(SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMax", "data", data);
        SDValidation.validateNumerical("unsortedSegmentMax", "segmentIds", segmentIds);
        return new UnsortedSegmentMax(this.sd, data, segmentIds, numSegments).outputVariable();
    }

    public SDVariable unsortedSegmentMax(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMax", "data", data);
        SDValidation.validateNumerical("unsortedSegmentMax", "segmentIds", segmentIds);
        SDVariable out = new UnsortedSegmentMax(this.sd, data, segmentIds, numSegments).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable unsortedSegmentMean(SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMean", "data", data);
        SDValidation.validateNumerical("unsortedSegmentMean", "segmentIds", segmentIds);
        return new UnsortedSegmentMean(this.sd, data, segmentIds, numSegments).outputVariable();
    }

    public SDVariable unsortedSegmentMean(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMean", "data", data);
        SDValidation.validateNumerical("unsortedSegmentMean", "segmentIds", segmentIds);
        SDVariable out = new UnsortedSegmentMean(this.sd, data, segmentIds, numSegments).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable unsortedSegmentMin(SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMin", "data", data);
        SDValidation.validateNumerical("unsortedSegmentMin", "segmentIds", segmentIds);
        return new UnsortedSegmentMin(this.sd, data, segmentIds, numSegments).outputVariable();
    }

    public SDVariable unsortedSegmentMin(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMin", "data", data);
        SDValidation.validateNumerical("unsortedSegmentMin", "segmentIds", segmentIds);
        SDVariable out = new UnsortedSegmentMin(this.sd, data, segmentIds, numSegments).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable unsortedSegmentProd(SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentProd", "data", data);
        SDValidation.validateNumerical("unsortedSegmentProd", "segmentIds", segmentIds);
        return new UnsortedSegmentProd(this.sd, data, segmentIds, numSegments).outputVariable();
    }

    public SDVariable unsortedSegmentProd(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentProd", "data", data);
        SDValidation.validateNumerical("unsortedSegmentProd", "segmentIds", segmentIds);
        SDVariable out = new UnsortedSegmentProd(this.sd, data, segmentIds, numSegments).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable unsortedSegmentSqrtN(SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentSqrtN", "data", data);
        SDValidation.validateNumerical("unsortedSegmentSqrtN", "segmentIds", segmentIds);
        return new UnsortedSegmentSqrtN(this.sd, data, segmentIds, numSegments).outputVariable();
    }

    public SDVariable unsortedSegmentSqrtN(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentSqrtN", "data", data);
        SDValidation.validateNumerical("unsortedSegmentSqrtN", "segmentIds", segmentIds);
        SDVariable out = new UnsortedSegmentSqrtN(this.sd, data, segmentIds, numSegments).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable unsortedSegmentSum(SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentSum", "data", data);
        SDValidation.validateNumerical("unsortedSegmentSum", "segmentIds", segmentIds);
        return new UnsortedSegmentSum(this.sd, data, segmentIds, numSegments).outputVariable();
    }

    public SDVariable unsortedSegmentSum(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentSum", "data", data);
        SDValidation.validateNumerical("unsortedSegmentSum", "segmentIds", segmentIds);
        SDVariable out = new UnsortedSegmentSum(this.sd, data, segmentIds, numSegments).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable[] unstack(SDVariable value, int axis, int num) {
        return new Unstack(this.sd, value, axis, num).outputVariables();
    }

    public SDVariable[] unstack(String[] names, SDVariable value, int axis, int num) {
        SDVariable[] out = new Unstack(this.sd, value, axis, num).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable variance(SDVariable x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("variance", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Variance(this.sd, x, biasCorrected, keepDims, dimensions).outputVariable();
    }

    public SDVariable variance(String name, SDVariable x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("variance", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Variance(this.sd, x, biasCorrected, keepDims, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable variance(SDVariable x, boolean biasCorrected, int ... dimensions) {
        SDValidation.validateNumerical("variance", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        return new Variance(this.sd, x, biasCorrected, false, dimensions).outputVariable();
    }

    public SDVariable variance(String name, SDVariable x, boolean biasCorrected, int ... dimensions) {
        SDValidation.validateNumerical("variance", "x", x);
        Preconditions.checkArgument((dimensions.length >= 0 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 0, got %s", (int)dimensions.length);
        SDVariable out = new Variance(this.sd, x, biasCorrected, false, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable zerosLike(SDVariable input) {
        SDValidation.validateNumerical("zerosLike", "input", input);
        return new ZerosLike(this.sd, input).outputVariable();
    }

    public SDVariable zerosLike(String name, SDVariable input) {
        SDValidation.validateNumerical("zerosLike", "input", input);
        SDVariable out = new ZerosLike(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }
}

