/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.profiler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.GridOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.MetaOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.profiler.data.StackAggregator;
import org.nd4j.linalg.profiler.data.StringAggregator;
import org.nd4j.linalg.profiler.data.StringCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpProfiler {
    private static final Logger log = LoggerFactory.getLogger(OpProfiler.class);
    private List<OpProfilerListener> listeners = new ArrayList<OpProfilerListener>();
    private AtomicLong invocationsCount = new AtomicLong(0L);
    private static OpProfiler ourInstance = new OpProfiler();
    private StringAggregator classAggergator = new StringAggregator();
    private StringAggregator longAggergator = new StringAggregator();
    private StringCounter classCounter = new StringCounter();
    private StringCounter opCounter = new StringCounter();
    private StringCounter classPairsCounter = new StringCounter();
    private StringCounter opPairsCounter = new StringCounter();
    private StringCounter matchingCounter = new StringCounter();
    private StringCounter matchingCounterDetailed = new StringCounter();
    private StringCounter matchingCounterInverted = new StringCounter();
    private StringCounter orderCounter = new StringCounter();
    private StackAggregator methodsAggregator = new StackAggregator();
    private StackAggregator scalarAggregator = new StackAggregator();
    private StackAggregator mixedOrderAggregator = new StackAggregator();
    private StackAggregator nonEwsAggregator = new StackAggregator();
    private StackAggregator stridedAggregator = new StackAggregator();
    private StackAggregator tadStridedAggregator = new StackAggregator();
    private StackAggregator tadNonEwsAggregator = new StackAggregator();
    private StackAggregator blasAggregator = new StackAggregator();
    private StringCounter blasOrderCounter = new StringCounter();
    private final long THRESHOLD = 100000L;
    private String prevOpClass = "";
    private String prevOpName = "";
    private String prevOpMatching = "";
    private String prevOpMatchingDetailed = "";
    private String prevOpMatchingInverted = "";
    private long lastZ = 0L;

    public void clearListener(OpProfilerListener listener) {
        this.listeners.remove(listener);
    }

    public void addListener(OpProfilerListener listener) {
        this.listeners.add(listener);
    }

    public void reset() {
        this.invocationsCount.set(0L);
        this.classAggergator.reset();
        this.longAggergator.reset();
        this.classCounter.reset();
        this.opCounter.reset();
        this.classPairsCounter.reset();
        this.opPairsCounter.reset();
        this.matchingCounter.reset();
        this.matchingCounterDetailed.reset();
        this.matchingCounterInverted.reset();
        this.methodsAggregator.reset();
        this.scalarAggregator.reset();
        this.nonEwsAggregator.reset();
        this.stridedAggregator.reset();
        this.tadNonEwsAggregator.reset();
        this.tadStridedAggregator.reset();
        this.mixedOrderAggregator.reset();
        this.blasAggregator.reset();
        this.blasOrderCounter.reset();
        this.orderCounter.reset();
        this.listeners.clear();
    }

    public static OpProfiler getInstance() {
        return ourInstance;
    }

    private OpProfiler() {
    }

    protected String getOpClass(Op op) {
        if (op instanceof ScalarOp) {
            return "ScalarOp";
        }
        if (op instanceof MetaOp) {
            return "MetaOp";
        }
        if (op instanceof GridOp) {
            return "GridOp";
        }
        if (op instanceof BroadcastOp) {
            return "BroadcastOp";
        }
        if (op instanceof RandomOp) {
            return "RandomOp";
        }
        if (op instanceof Accumulation) {
            return "AccumulationOp";
        }
        if (op instanceof TransformOp) {
            if (op.y() == null) {
                return "TransformOp";
            }
            return "PairWiseTransformOp";
        }
        if (op instanceof IndexAccumulation) {
            return "IndexAccumulationOp";
        }
        return "Unknown Op calls";
    }

    public void processScalarCall() {
        this.invocationsCount.incrementAndGet();
        this.scalarAggregator.incrementCount();
    }

    public void processOpCall(Op op) {
        this.invocationsCount.incrementAndGet();
        this.opCounter.incrementCount(op.name());
        String opClass = this.getOpClass(op);
        this.classCounter.incrementCount(opClass);
        if (op.x().data().address() == this.lastZ && op.z() == op.x() && op.y() == null) {
            this.matchingCounter.incrementCount(this.prevOpMatching + " -> " + opClass);
            this.matchingCounterDetailed.incrementCount(this.prevOpMatchingDetailed + " -> " + opClass + " " + op.name());
        } else {
            this.matchingCounter.totalsIncrement();
            this.matchingCounterDetailed.totalsIncrement();
            if (op.y() != null && op.y().data().address() == this.lastZ) {
                this.matchingCounterInverted.incrementCount(this.prevOpMatchingInverted + " -> " + opClass + " " + op.name());
            } else {
                this.matchingCounterInverted.totalsIncrement();
            }
        }
        this.lastZ = op.z().data().address();
        this.prevOpMatching = opClass;
        this.prevOpMatchingDetailed = opClass + " " + op.name();
        this.prevOpMatchingInverted = opClass + " " + op.name();
        this.updatePairs(op.name(), opClass);
        PenaltyCause[] causes = this.processOperands(op.x(), op.y(), op.z());
        block5: for (PenaltyCause cause : causes) {
            switch (cause) {
                case NON_EWS_ACCESS: {
                    this.nonEwsAggregator.incrementCount();
                    continue block5;
                }
                case STRIDED_ACCESS: {
                    this.stridedAggregator.incrementCount();
                    continue block5;
                }
                case MIXED_ORDER: {
                    this.mixedOrderAggregator.incrementCount();
                    continue block5;
                }
            }
        }
        for (OpProfilerListener listener : this.listeners) {
            listener.invoke(op);
        }
    }

    public void processOpCall(Op op, DataBuffer ... tadBuffers) {
        PenaltyCause[] causes;
        this.processOpCall(op);
        block4: for (PenaltyCause cause : causes = this.processTADOperands(tadBuffers)) {
            switch (cause) {
                case TAD_NON_EWS_ACCESS: {
                    this.tadNonEwsAggregator.incrementCount();
                    continue block4;
                }
                case TAD_STRIDED_ACCESS: {
                    this.tadStridedAggregator.incrementCount();
                    continue block4;
                }
            }
        }
    }

    public StackAggregator getMixedOrderAggregator() {
        return this.mixedOrderAggregator;
    }

    public StackAggregator getScalarAggregator() {
        return this.scalarAggregator;
    }

    protected void updatePairs(String opName, String opClass) {
        String cOpNameKey = this.prevOpName + " -> " + opName;
        String cOpClassKey = this.prevOpClass + " -> " + opClass;
        this.classPairsCounter.incrementCount(cOpClassKey);
        this.opPairsCounter.incrementCount(cOpNameKey);
        this.prevOpName = opName;
        this.prevOpClass = opClass;
    }

    public void timeOpCall(Op op, long startTime) {
        long currentTime = System.nanoTime() - startTime;
        this.classAggergator.putTime(this.getOpClass(op), op, currentTime);
        if (currentTime > 100000L) {
            String keyExt = this.getOpClass(op) + " " + op.name() + " (" + op.opNum() + ")";
            this.longAggergator.putTime(keyExt, currentTime);
        }
    }

    @Deprecated
    public void processBlasCall(String blasOpName) {
        String key = "BLAS";
        this.invocationsCount.incrementAndGet();
        this.opCounter.incrementCount(blasOpName);
        this.classCounter.incrementCount(key);
        this.updatePairs(blasOpName, key);
        this.prevOpMatching = "";
        this.lastZ = 0L;
    }

    public void timeBlasCall() {
    }

    public void printOutDashboard() {
        log.info("---Total Op Calls: {}", (Object)this.invocationsCount.get());
        System.out.println();
        log.info("--- OpClass calls statistics: ---");
        System.out.println(this.classCounter.asString());
        System.out.println();
        log.info("--- OpClass pairs statistics: ---");
        System.out.println(this.classPairsCounter.asString());
        System.out.println();
        log.info("--- Individual Op calls statistics: ---");
        System.out.println(this.opCounter.asString());
        System.out.println();
        log.info("--- Matching Op calls statistics: ---");
        System.out.println(this.matchingCounter.asString());
        System.out.println();
        log.info("--- Matching detailed Op calls statistics: ---");
        System.out.println(this.matchingCounterDetailed.asString());
        System.out.println();
        log.info("--- Matching inverts Op calls statistics: ---");
        System.out.println(this.matchingCounterInverted.asString());
        System.out.println();
        log.info("--- Time for OpClass calls statistics: ---");
        System.out.println(this.classAggergator.asString());
        System.out.println();
        log.info("--- Time for long Op calls statistics: ---");
        System.out.println(this.longAggergator.asString());
        System.out.println();
        log.info("--- Time spent for Op calls statistics: ---");
        System.out.println(this.classAggergator.asPercentageString());
        System.out.println();
        log.info("--- Time spent for long Op calls statistics: ---");
        System.out.println(this.longAggergator.asPercentageString());
        System.out.println();
        log.info("--- Time spent within methods: ---");
        this.methodsAggregator.renderTree(true);
        System.out.println();
        log.info("--- Bad strides stack tree: ---");
        System.out.println("Unique entries: " + this.stridedAggregator.getUniqueBranchesNumber());
        this.stridedAggregator.renderTree();
        System.out.println();
        log.info("--- non-EWS access stack tree: ---");
        System.out.println("Unique entries: " + this.nonEwsAggregator.getUniqueBranchesNumber());
        this.nonEwsAggregator.renderTree();
        System.out.println();
        log.info("--- Mixed orders access stack tree: ---");
        System.out.println("Unique entries: " + this.mixedOrderAggregator.getUniqueBranchesNumber());
        this.mixedOrderAggregator.renderTree();
        System.out.println();
        log.info("--- TAD bad strides stack tree: ---");
        System.out.println("Unique entries: " + this.tadStridedAggregator.getUniqueBranchesNumber());
        this.tadStridedAggregator.renderTree();
        System.out.println();
        log.info("--- TAD non-EWS access stack tree: ---");
        System.out.println("Unique entries: " + this.tadNonEwsAggregator.getUniqueBranchesNumber());
        this.tadNonEwsAggregator.renderTree();
        System.out.println();
        log.info("--- Scalar access stack tree: ---");
        System.out.println("Unique entries: " + this.scalarAggregator.getUniqueBranchesNumber());
        this.scalarAggregator.renderTree(false);
        System.out.println();
        log.info("--- Blas GEMM odrders count: ---");
        System.out.println(this.blasOrderCounter.asString());
        System.out.println();
        log.info("--- BLAS access stack trace: ---");
        System.out.println("Unique entries: " + this.blasAggregator.getUniqueBranchesNumber());
        this.blasAggregator.renderTree(false);
        System.out.println();
    }

    public long getInvocationsCount() {
        return this.invocationsCount.get();
    }

    public void processStackCall(Op op, long timeStart) {
        long timeSpent = (System.nanoTime() - timeStart) / 1000L;
        this.methodsAggregator.incrementCount(timeSpent);
    }

    public String processOrders(INDArray ... operands) {
        StringBuffer buffer = new StringBuffer();
        for (int e = 0; e < operands.length; ++e) {
            if (operands[e] == null) {
                buffer.append("null");
            } else {
                buffer.append(new String("" + operands[e].ordering()).toUpperCase());
            }
            if (e >= operands.length - 1) continue;
            buffer.append(" x ");
        }
        this.orderCounter.incrementCount(buffer.toString());
        return buffer.toString();
    }

    public void processBlasCall(boolean isGemm, INDArray ... operands) {
        if (isGemm) {
            PenaltyCause[] causes;
            String key = this.processOrders(operands);
            this.blasOrderCounter.incrementCount(key);
            block8: for (PenaltyCause cause : causes = this.processOperands(operands)) {
                switch (cause) {
                    case NON_EWS_ACCESS: 
                    case STRIDED_ACCESS: 
                    case NONE: {
                        this.blasAggregator.incrementCount();
                        continue block8;
                    }
                }
            }
        } else {
            PenaltyCause[] causes;
            block9: for (PenaltyCause cause : causes = this.processOperands(operands)) {
                switch (cause) {
                    case NON_EWS_ACCESS: {
                        this.nonEwsAggregator.incrementCount();
                        continue block9;
                    }
                    case STRIDED_ACCESS: {
                        this.stridedAggregator.incrementCount();
                        continue block9;
                    }
                    case MIXED_ORDER: {
                        this.mixedOrderAggregator.incrementCount();
                        continue block9;
                    }
                }
            }
        }
    }

    public PenaltyCause[] processOperands(INDArray x, INDArray y) {
        ArrayList<PenaltyCause> penalties = new ArrayList<PenaltyCause>();
        if (x.ordering() != y.ordering()) {
            penalties.add(PenaltyCause.MIXED_ORDER);
        }
        if (x.elementWiseStride() < 1) {
            penalties.add(PenaltyCause.NON_EWS_ACCESS);
        } else if (y.elementWiseStride() < 1) {
            penalties.add(PenaltyCause.NON_EWS_ACCESS);
        }
        if (x.elementWiseStride() > 1) {
            penalties.add(PenaltyCause.STRIDED_ACCESS);
        } else if (y.elementWiseStride() > 1) {
            penalties.add(PenaltyCause.STRIDED_ACCESS);
        }
        if (penalties.isEmpty()) {
            penalties.add(PenaltyCause.NONE);
        }
        return penalties.toArray(new PenaltyCause[0]);
    }

    public PenaltyCause[] processTADOperands(DataBuffer ... tadBuffers) {
        ArrayList<PenaltyCause> causes = new ArrayList<PenaltyCause>();
        for (DataBuffer tadBuffer : tadBuffers) {
            if (tadBuffer == null) continue;
            int rank = tadBuffer.getInt(0L);
            int length = rank * 2 + 4;
            int ews = tadBuffer.getInt((long)(length - 2));
            if ((ews < 1 || rank > 2 || rank == 2 && tadBuffer.getInt(1L) > 1 && tadBuffer.getInt(2L) > 1) && !causes.contains((Object)PenaltyCause.TAD_NON_EWS_ACCESS)) {
                causes.add(PenaltyCause.TAD_NON_EWS_ACCESS);
                continue;
            }
            if (ews <= 1 || causes.contains((Object)PenaltyCause.TAD_STRIDED_ACCESS)) continue;
            causes.add(PenaltyCause.TAD_STRIDED_ACCESS);
        }
        if (causes.isEmpty()) {
            causes.add(PenaltyCause.NONE);
        }
        return causes.toArray(new PenaltyCause[0]);
    }

    public PenaltyCause[] processOperands(INDArray x, INDArray y, INDArray z) {
        if (y == null) {
            return this.processOperands(x, z);
        }
        if (x == z || y == z) {
            return this.processOperands(x, y);
        }
        PenaltyCause[] causeXY = this.processOperands(x, y);
        PenaltyCause[] causeXZ = this.processOperands(x, z);
        if (causeXY.length == 1 && causeXY[0] == PenaltyCause.NONE && causeXZ.length == 1 && causeXZ[0] == PenaltyCause.NONE) {
            return causeXY;
        }
        if (causeXY.length == 1 && causeXY[0] == PenaltyCause.NONE) {
            return causeXZ;
        }
        if (causeXZ.length == 1 && causeXZ[0] == PenaltyCause.NONE) {
            return causeXY;
        }
        return this.joinDistinct(causeXY, causeXZ);
    }

    protected PenaltyCause[] joinDistinct(PenaltyCause[] a, PenaltyCause[] b) {
        ArrayList<PenaltyCause> causes = new ArrayList<PenaltyCause>();
        for (PenaltyCause cause : a) {
            if (cause == null || causes.contains((Object)cause)) continue;
            causes.add(cause);
        }
        for (PenaltyCause cause : b) {
            if (cause == null || causes.contains((Object)cause)) continue;
            causes.add(cause);
        }
        return causes.toArray(new PenaltyCause[0]);
    }

    public PenaltyCause[] processOperands(INDArray ... operands) {
        if (operands == null) {
            return new PenaltyCause[]{PenaltyCause.NONE};
        }
        ArrayList<PenaltyCause> causes = new ArrayList<PenaltyCause>();
        for (int e = 0; e < operands.length - 1; ++e) {
            PenaltyCause[] lc;
            if (operands[e] == null && operands[e + 1] == null) continue;
            for (PenaltyCause cause : lc = this.processOperands(operands[e], operands[e + 1])) {
                if (cause == PenaltyCause.NONE || causes.contains((Object)cause)) continue;
                causes.add(cause);
            }
        }
        if (causes.isEmpty()) {
            causes.add(PenaltyCause.NONE);
        }
        return causes.toArray(new PenaltyCause[0]);
    }

    public void processMemoryAccess() {
    }

    public List<OpProfilerListener> getListeners() {
        return this.listeners;
    }

    public long getTHRESHOLD() {
        return this.THRESHOLD;
    }

    public String getPrevOpClass() {
        return this.prevOpClass;
    }

    public String getPrevOpName() {
        return this.prevOpName;
    }

    public String getPrevOpMatching() {
        return this.prevOpMatching;
    }

    public String getPrevOpMatchingDetailed() {
        return this.prevOpMatchingDetailed;
    }

    public String getPrevOpMatchingInverted() {
        return this.prevOpMatchingInverted;
    }

    public long getLastZ() {
        return this.lastZ;
    }

    public void setListeners(List<OpProfilerListener> listeners) {
        this.listeners = listeners;
    }

    public void setInvocationsCount(AtomicLong invocationsCount) {
        this.invocationsCount = invocationsCount;
    }

    public void setClassAggergator(StringAggregator classAggergator) {
        this.classAggergator = classAggergator;
    }

    public void setLongAggergator(StringAggregator longAggergator) {
        this.longAggergator = longAggergator;
    }

    public void setClassCounter(StringCounter classCounter) {
        this.classCounter = classCounter;
    }

    public void setOpCounter(StringCounter opCounter) {
        this.opCounter = opCounter;
    }

    public void setClassPairsCounter(StringCounter classPairsCounter) {
        this.classPairsCounter = classPairsCounter;
    }

    public void setOpPairsCounter(StringCounter opPairsCounter) {
        this.opPairsCounter = opPairsCounter;
    }

    public void setMatchingCounter(StringCounter matchingCounter) {
        this.matchingCounter = matchingCounter;
    }

    public void setMatchingCounterDetailed(StringCounter matchingCounterDetailed) {
        this.matchingCounterDetailed = matchingCounterDetailed;
    }

    public void setMatchingCounterInverted(StringCounter matchingCounterInverted) {
        this.matchingCounterInverted = matchingCounterInverted;
    }

    public void setOrderCounter(StringCounter orderCounter) {
        this.orderCounter = orderCounter;
    }

    public void setMethodsAggregator(StackAggregator methodsAggregator) {
        this.methodsAggregator = methodsAggregator;
    }

    public void setScalarAggregator(StackAggregator scalarAggregator) {
        this.scalarAggregator = scalarAggregator;
    }

    public void setMixedOrderAggregator(StackAggregator mixedOrderAggregator) {
        this.mixedOrderAggregator = mixedOrderAggregator;
    }

    public void setNonEwsAggregator(StackAggregator nonEwsAggregator) {
        this.nonEwsAggregator = nonEwsAggregator;
    }

    public void setStridedAggregator(StackAggregator stridedAggregator) {
        this.stridedAggregator = stridedAggregator;
    }

    public void setTadStridedAggregator(StackAggregator tadStridedAggregator) {
        this.tadStridedAggregator = tadStridedAggregator;
    }

    public void setTadNonEwsAggregator(StackAggregator tadNonEwsAggregator) {
        this.tadNonEwsAggregator = tadNonEwsAggregator;
    }

    public void setBlasAggregator(StackAggregator blasAggregator) {
        this.blasAggregator = blasAggregator;
    }

    public void setBlasOrderCounter(StringCounter blasOrderCounter) {
        this.blasOrderCounter = blasOrderCounter;
    }

    public void setPrevOpClass(String prevOpClass) {
        this.prevOpClass = prevOpClass;
    }

    public void setPrevOpName(String prevOpName) {
        this.prevOpName = prevOpName;
    }

    public void setPrevOpMatching(String prevOpMatching) {
        this.prevOpMatching = prevOpMatching;
    }

    public void setPrevOpMatchingDetailed(String prevOpMatchingDetailed) {
        this.prevOpMatchingDetailed = prevOpMatchingDetailed;
    }

    public void setPrevOpMatchingInverted(String prevOpMatchingInverted) {
        this.prevOpMatchingInverted = prevOpMatchingInverted;
    }

    public void setLastZ(long lastZ) {
        this.lastZ = lastZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpProfiler)) {
            return false;
        }
        OpProfiler other = (OpProfiler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<OpProfilerListener> this$listeners = this.getListeners();
        List<OpProfilerListener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        if (this.getInvocationsCount() != other.getInvocationsCount()) {
            return false;
        }
        StringAggregator this$classAggergator = this.getClassAggergator();
        StringAggregator other$classAggergator = other.getClassAggergator();
        if (this$classAggergator == null ? other$classAggergator != null : !this$classAggergator.equals(other$classAggergator)) {
            return false;
        }
        StringAggregator this$longAggergator = this.getLongAggergator();
        StringAggregator other$longAggergator = other.getLongAggergator();
        if (this$longAggergator == null ? other$longAggergator != null : !this$longAggergator.equals(other$longAggergator)) {
            return false;
        }
        StringCounter this$classCounter = this.getClassCounter();
        StringCounter other$classCounter = other.getClassCounter();
        if (this$classCounter == null ? other$classCounter != null : !this$classCounter.equals(other$classCounter)) {
            return false;
        }
        StringCounter this$opCounter = this.getOpCounter();
        StringCounter other$opCounter = other.getOpCounter();
        if (this$opCounter == null ? other$opCounter != null : !this$opCounter.equals(other$opCounter)) {
            return false;
        }
        StringCounter this$classPairsCounter = this.getClassPairsCounter();
        StringCounter other$classPairsCounter = other.getClassPairsCounter();
        if (this$classPairsCounter == null ? other$classPairsCounter != null : !this$classPairsCounter.equals(other$classPairsCounter)) {
            return false;
        }
        StringCounter this$opPairsCounter = this.getOpPairsCounter();
        StringCounter other$opPairsCounter = other.getOpPairsCounter();
        if (this$opPairsCounter == null ? other$opPairsCounter != null : !this$opPairsCounter.equals(other$opPairsCounter)) {
            return false;
        }
        StringCounter this$matchingCounter = this.getMatchingCounter();
        StringCounter other$matchingCounter = other.getMatchingCounter();
        if (this$matchingCounter == null ? other$matchingCounter != null : !this$matchingCounter.equals(other$matchingCounter)) {
            return false;
        }
        StringCounter this$matchingCounterDetailed = this.getMatchingCounterDetailed();
        StringCounter other$matchingCounterDetailed = other.getMatchingCounterDetailed();
        if (this$matchingCounterDetailed == null ? other$matchingCounterDetailed != null : !this$matchingCounterDetailed.equals(other$matchingCounterDetailed)) {
            return false;
        }
        StringCounter this$matchingCounterInverted = this.getMatchingCounterInverted();
        StringCounter other$matchingCounterInverted = other.getMatchingCounterInverted();
        if (this$matchingCounterInverted == null ? other$matchingCounterInverted != null : !this$matchingCounterInverted.equals(other$matchingCounterInverted)) {
            return false;
        }
        StringCounter this$orderCounter = this.getOrderCounter();
        StringCounter other$orderCounter = other.getOrderCounter();
        if (this$orderCounter == null ? other$orderCounter != null : !this$orderCounter.equals(other$orderCounter)) {
            return false;
        }
        StackAggregator this$methodsAggregator = this.getMethodsAggregator();
        StackAggregator other$methodsAggregator = other.getMethodsAggregator();
        if (this$methodsAggregator == null ? other$methodsAggregator != null : !this$methodsAggregator.equals(other$methodsAggregator)) {
            return false;
        }
        StackAggregator this$scalarAggregator = this.getScalarAggregator();
        StackAggregator other$scalarAggregator = other.getScalarAggregator();
        if (this$scalarAggregator == null ? other$scalarAggregator != null : !this$scalarAggregator.equals(other$scalarAggregator)) {
            return false;
        }
        StackAggregator this$mixedOrderAggregator = this.getMixedOrderAggregator();
        StackAggregator other$mixedOrderAggregator = other.getMixedOrderAggregator();
        if (this$mixedOrderAggregator == null ? other$mixedOrderAggregator != null : !this$mixedOrderAggregator.equals(other$mixedOrderAggregator)) {
            return false;
        }
        StackAggregator this$nonEwsAggregator = this.getNonEwsAggregator();
        StackAggregator other$nonEwsAggregator = other.getNonEwsAggregator();
        if (this$nonEwsAggregator == null ? other$nonEwsAggregator != null : !this$nonEwsAggregator.equals(other$nonEwsAggregator)) {
            return false;
        }
        StackAggregator this$stridedAggregator = this.getStridedAggregator();
        StackAggregator other$stridedAggregator = other.getStridedAggregator();
        if (this$stridedAggregator == null ? other$stridedAggregator != null : !this$stridedAggregator.equals(other$stridedAggregator)) {
            return false;
        }
        StackAggregator this$tadStridedAggregator = this.getTadStridedAggregator();
        StackAggregator other$tadStridedAggregator = other.getTadStridedAggregator();
        if (this$tadStridedAggregator == null ? other$tadStridedAggregator != null : !this$tadStridedAggregator.equals(other$tadStridedAggregator)) {
            return false;
        }
        StackAggregator this$tadNonEwsAggregator = this.getTadNonEwsAggregator();
        StackAggregator other$tadNonEwsAggregator = other.getTadNonEwsAggregator();
        if (this$tadNonEwsAggregator == null ? other$tadNonEwsAggregator != null : !this$tadNonEwsAggregator.equals(other$tadNonEwsAggregator)) {
            return false;
        }
        StackAggregator this$blasAggregator = this.getBlasAggregator();
        StackAggregator other$blasAggregator = other.getBlasAggregator();
        if (this$blasAggregator == null ? other$blasAggregator != null : !this$blasAggregator.equals(other$blasAggregator)) {
            return false;
        }
        StringCounter this$blasOrderCounter = this.getBlasOrderCounter();
        StringCounter other$blasOrderCounter = other.getBlasOrderCounter();
        if (this$blasOrderCounter == null ? other$blasOrderCounter != null : !this$blasOrderCounter.equals(other$blasOrderCounter)) {
            return false;
        }
        if (this.getTHRESHOLD() != other.getTHRESHOLD()) {
            return false;
        }
        String this$prevOpClass = this.getPrevOpClass();
        String other$prevOpClass = other.getPrevOpClass();
        if (this$prevOpClass == null ? other$prevOpClass != null : !this$prevOpClass.equals(other$prevOpClass)) {
            return false;
        }
        String this$prevOpName = this.getPrevOpName();
        String other$prevOpName = other.getPrevOpName();
        if (this$prevOpName == null ? other$prevOpName != null : !this$prevOpName.equals(other$prevOpName)) {
            return false;
        }
        String this$prevOpMatching = this.getPrevOpMatching();
        String other$prevOpMatching = other.getPrevOpMatching();
        if (this$prevOpMatching == null ? other$prevOpMatching != null : !this$prevOpMatching.equals(other$prevOpMatching)) {
            return false;
        }
        String this$prevOpMatchingDetailed = this.getPrevOpMatchingDetailed();
        String other$prevOpMatchingDetailed = other.getPrevOpMatchingDetailed();
        if (this$prevOpMatchingDetailed == null ? other$prevOpMatchingDetailed != null : !this$prevOpMatchingDetailed.equals(other$prevOpMatchingDetailed)) {
            return false;
        }
        String this$prevOpMatchingInverted = this.getPrevOpMatchingInverted();
        String other$prevOpMatchingInverted = other.getPrevOpMatchingInverted();
        if (this$prevOpMatchingInverted == null ? other$prevOpMatchingInverted != null : !this$prevOpMatchingInverted.equals(other$prevOpMatchingInverted)) {
            return false;
        }
        return this.getLastZ() == other.getLastZ();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpProfiler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<OpProfilerListener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        long $invocationsCount = this.getInvocationsCount();
        result = result * 59 + (int)($invocationsCount >>> 32 ^ $invocationsCount);
        StringAggregator $classAggergator = this.getClassAggergator();
        result = result * 59 + ($classAggergator == null ? 43 : $classAggergator.hashCode());
        StringAggregator $longAggergator = this.getLongAggergator();
        result = result * 59 + ($longAggergator == null ? 43 : $longAggergator.hashCode());
        StringCounter $classCounter = this.getClassCounter();
        result = result * 59 + ($classCounter == null ? 43 : $classCounter.hashCode());
        StringCounter $opCounter = this.getOpCounter();
        result = result * 59 + ($opCounter == null ? 43 : $opCounter.hashCode());
        StringCounter $classPairsCounter = this.getClassPairsCounter();
        result = result * 59 + ($classPairsCounter == null ? 43 : $classPairsCounter.hashCode());
        StringCounter $opPairsCounter = this.getOpPairsCounter();
        result = result * 59 + ($opPairsCounter == null ? 43 : $opPairsCounter.hashCode());
        StringCounter $matchingCounter = this.getMatchingCounter();
        result = result * 59 + ($matchingCounter == null ? 43 : $matchingCounter.hashCode());
        StringCounter $matchingCounterDetailed = this.getMatchingCounterDetailed();
        result = result * 59 + ($matchingCounterDetailed == null ? 43 : $matchingCounterDetailed.hashCode());
        StringCounter $matchingCounterInverted = this.getMatchingCounterInverted();
        result = result * 59 + ($matchingCounterInverted == null ? 43 : $matchingCounterInverted.hashCode());
        StringCounter $orderCounter = this.getOrderCounter();
        result = result * 59 + ($orderCounter == null ? 43 : $orderCounter.hashCode());
        StackAggregator $methodsAggregator = this.getMethodsAggregator();
        result = result * 59 + ($methodsAggregator == null ? 43 : $methodsAggregator.hashCode());
        StackAggregator $scalarAggregator = this.getScalarAggregator();
        result = result * 59 + ($scalarAggregator == null ? 43 : $scalarAggregator.hashCode());
        StackAggregator $mixedOrderAggregator = this.getMixedOrderAggregator();
        result = result * 59 + ($mixedOrderAggregator == null ? 43 : $mixedOrderAggregator.hashCode());
        StackAggregator $nonEwsAggregator = this.getNonEwsAggregator();
        result = result * 59 + ($nonEwsAggregator == null ? 43 : $nonEwsAggregator.hashCode());
        StackAggregator $stridedAggregator = this.getStridedAggregator();
        result = result * 59 + ($stridedAggregator == null ? 43 : $stridedAggregator.hashCode());
        StackAggregator $tadStridedAggregator = this.getTadStridedAggregator();
        result = result * 59 + ($tadStridedAggregator == null ? 43 : $tadStridedAggregator.hashCode());
        StackAggregator $tadNonEwsAggregator = this.getTadNonEwsAggregator();
        result = result * 59 + ($tadNonEwsAggregator == null ? 43 : $tadNonEwsAggregator.hashCode());
        StackAggregator $blasAggregator = this.getBlasAggregator();
        result = result * 59 + ($blasAggregator == null ? 43 : $blasAggregator.hashCode());
        StringCounter $blasOrderCounter = this.getBlasOrderCounter();
        result = result * 59 + ($blasOrderCounter == null ? 43 : $blasOrderCounter.hashCode());
        long $THRESHOLD = this.getTHRESHOLD();
        result = result * 59 + (int)($THRESHOLD >>> 32 ^ $THRESHOLD);
        String $prevOpClass = this.getPrevOpClass();
        result = result * 59 + ($prevOpClass == null ? 43 : $prevOpClass.hashCode());
        String $prevOpName = this.getPrevOpName();
        result = result * 59 + ($prevOpName == null ? 43 : $prevOpName.hashCode());
        String $prevOpMatching = this.getPrevOpMatching();
        result = result * 59 + ($prevOpMatching == null ? 43 : $prevOpMatching.hashCode());
        String $prevOpMatchingDetailed = this.getPrevOpMatchingDetailed();
        result = result * 59 + ($prevOpMatchingDetailed == null ? 43 : $prevOpMatchingDetailed.hashCode());
        String $prevOpMatchingInverted = this.getPrevOpMatchingInverted();
        result = result * 59 + ($prevOpMatchingInverted == null ? 43 : $prevOpMatchingInverted.hashCode());
        long $lastZ = this.getLastZ();
        result = result * 59 + (int)($lastZ >>> 32 ^ $lastZ);
        return result;
    }

    public String toString() {
        return "OpProfiler(listeners=" + this.getListeners() + ", invocationsCount=" + this.getInvocationsCount() + ", classAggergator=" + this.getClassAggergator() + ", longAggergator=" + this.getLongAggergator() + ", classCounter=" + this.getClassCounter() + ", opCounter=" + this.getOpCounter() + ", classPairsCounter=" + this.getClassPairsCounter() + ", opPairsCounter=" + this.getOpPairsCounter() + ", matchingCounter=" + this.getMatchingCounter() + ", matchingCounterDetailed=" + this.getMatchingCounterDetailed() + ", matchingCounterInverted=" + this.getMatchingCounterInverted() + ", orderCounter=" + this.getOrderCounter() + ", methodsAggregator=" + this.getMethodsAggregator() + ", scalarAggregator=" + this.getScalarAggregator() + ", mixedOrderAggregator=" + this.getMixedOrderAggregator() + ", nonEwsAggregator=" + this.getNonEwsAggregator() + ", stridedAggregator=" + this.getStridedAggregator() + ", tadStridedAggregator=" + this.getTadStridedAggregator() + ", tadNonEwsAggregator=" + this.getTadNonEwsAggregator() + ", blasAggregator=" + this.getBlasAggregator() + ", blasOrderCounter=" + this.getBlasOrderCounter() + ", THRESHOLD=" + this.getTHRESHOLD() + ", prevOpClass=" + this.getPrevOpClass() + ", prevOpName=" + this.getPrevOpName() + ", prevOpMatching=" + this.getPrevOpMatching() + ", prevOpMatchingDetailed=" + this.getPrevOpMatchingDetailed() + ", prevOpMatchingInverted=" + this.getPrevOpMatchingInverted() + ", lastZ=" + this.getLastZ() + ")";
    }

    public StringAggregator getClassAggergator() {
        return this.classAggergator;
    }

    public StringAggregator getLongAggergator() {
        return this.longAggergator;
    }

    public StringCounter getClassCounter() {
        return this.classCounter;
    }

    public StringCounter getOpCounter() {
        return this.opCounter;
    }

    public StringCounter getClassPairsCounter() {
        return this.classPairsCounter;
    }

    public StringCounter getOpPairsCounter() {
        return this.opPairsCounter;
    }

    public StringCounter getMatchingCounter() {
        return this.matchingCounter;
    }

    public StringCounter getMatchingCounterDetailed() {
        return this.matchingCounterDetailed;
    }

    public StringCounter getMatchingCounterInverted() {
        return this.matchingCounterInverted;
    }

    public StringCounter getOrderCounter() {
        return this.orderCounter;
    }

    public StackAggregator getMethodsAggregator() {
        return this.methodsAggregator;
    }

    public StackAggregator getNonEwsAggregator() {
        return this.nonEwsAggregator;
    }

    public StackAggregator getStridedAggregator() {
        return this.stridedAggregator;
    }

    public StackAggregator getTadStridedAggregator() {
        return this.tadStridedAggregator;
    }

    public StackAggregator getTadNonEwsAggregator() {
        return this.tadNonEwsAggregator;
    }

    public StackAggregator getBlasAggregator() {
        return this.blasAggregator;
    }

    public StringCounter getBlasOrderCounter() {
        return this.blasOrderCounter;
    }

    public static interface OpProfilerListener {
        public void invoke(Op var1);
    }

    public static enum PenaltyCause {
        NONE,
        NON_EWS_ACCESS,
        STRIDED_ACCESS,
        MIXED_ORDER,
        TAD_NON_EWS_ACCESS,
        TAD_STRIDED_ACCESS;

    }
}

