/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.eigen;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.inverse.InvertMatrix;

public class Eigen {
    public static INDArray dummy = Nd4j.scalar(1.0f);

    public static IComplexNDArray eigenvalues(INDArray A) {
        assert (A.rows() == A.columns());
        INDArray WR = Nd4j.create(A.rows(), A.rows());
        INDArray WI = WR.dup();
        Nd4j.getBlasWrapper().geev('N', 'N', A.dup(), WR, WI, dummy, dummy);
        return Nd4j.createComplex(WR, WI);
    }

    public static INDArray symmetricGeneralizedEigenvalues(INDArray A) {
        INDArray eigenvalues = Nd4j.create(A.rows());
        Nd4j.getBlasWrapper().syev('V', 'L', A, eigenvalues);
        return eigenvalues;
    }

    public static INDArray symmetricGeneralizedEigenvalues(INDArray A, boolean calculateVectors) {
        INDArray eigenvalues = Nd4j.create(A.rows());
        Nd4j.getBlasWrapper().syev('V', 'L', calculateVectors ? A : A.dup(), eigenvalues);
        return eigenvalues;
    }

    public static IComplexNDArray[] eigenvectors(INDArray A) {
        assert (A.columns() == A.rows());
        INDArray WR = Nd4j.create(A.rows());
        INDArray WI = WR.dup();
        INDArray VR = Nd4j.create(A.rows(), A.rows());
        INDArray VL = Nd4j.create(A.rows(), A.rows());
        Nd4j.getBlasWrapper().geev('v', 'v', A.dup(), WR, WI, VL, VR);
        IComplexNDArray E = Nd4j.createComplex(WR, WI);
        IComplexNDArray V = Nd4j.createComplex(A.rows(), A.rows());
        for (int i = 0; i < A.rows(); ++i) {
            if (E.getComplex(i).isReal()) {
                IComplexNDArray column = Nd4j.createComplex(VR.getColumn(i));
                V.putColumn(i, column);
                continue;
            }
            IComplexNDArray v = Nd4j.createComplex(VR.getColumn(i), VR.getColumn(i + 1));
            V.putColumn(i, v);
            V.putColumn(i + 1, v.conji());
            ++i;
        }
        return new IComplexNDArray[]{Nd4j.diag(E), V};
    }

    public static INDArray symmetricGeneralizedEigenvalues(INDArray A, INDArray B) {
        assert (A.rows() == A.columns());
        assert (B.rows() == B.columns());
        INDArray W = Nd4j.create(A.rows());
        A = InvertMatrix.invert(B, false).mmuli(A);
        Nd4j.getBlasWrapper().syev('V', 'L', A, W);
        return W;
    }

    public static INDArray symmetricGeneralizedEigenvalues(INDArray A, INDArray B, boolean calculateVectors) {
        assert (A.rows() == A.columns());
        assert (B.rows() == B.columns());
        INDArray W = Nd4j.create(A.rows());
        if (calculateVectors) {
            A.assign(InvertMatrix.invert(B, false).mmuli(A));
        } else {
            A = InvertMatrix.invert(B, false).mmuli(A);
        }
        Nd4j.getBlasWrapper().syev('V', 'L', A, W);
        return W;
    }
}

