/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;

public class BernoulliDistribution
extends BaseRandomOp {
    private double prob;

    public BernoulliDistribution() {
    }

    public BernoulliDistribution(@NonNull INDArray z, double prob) {
        if (z == null) {
            throw new NullPointerException("z");
        }
        this.init(null, null, z, z.lengthLong());
        this.prob = prob;
        this.extraArgs = new Object[]{this.prob};
    }

    public BernoulliDistribution(@NonNull INDArray z, @NonNull INDArray prob) {
        if (z == null) {
            throw new NullPointerException("z");
        }
        if (prob == null) {
            throw new NullPointerException("prob");
        }
        if (prob.elementWiseStride() != 1) {
            throw new ND4JIllegalStateException("Probabilities should have ElementWiseStride of 1");
        }
        if (prob.lengthLong() != z.lengthLong()) {
            throw new ND4JIllegalStateException("Length of probabilities array [" + prob.lengthLong() + "] doesn't match length of output array [" + z.lengthLong() + "]");
        }
        this.init(prob, null, z, z.lengthLong());
        this.prob = 0.0;
        this.extraArgs = new Object[]{this.prob};
    }

    @Override
    public int opNum() {
        return 7;
    }

    @Override
    public String name() {
        return "distribution_bernoulli";
    }
}

