/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class TanDerivative
extends BaseTransformOp {
    public TanDerivative() {
    }

    public TanDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public TanDerivative(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public TanDerivative(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public TanDerivative(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    public TanDerivative(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 66;
    }

    @Override
    public String name() {
        return "tanderivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float op(float origin, float other) {
        return 1.0f / (float)FastMath.pow((double)FastMath.cos((double)origin), (int)2);
    }

    @Override
    public double op(double origin, double other) {
        return 1.0f / (float)FastMath.pow((double)FastMath.cos((double)origin), (int)2);
    }

    @Override
    public double op(double origin) {
        return 1.0f / (float)FastMath.pow((double)FastMath.cos((double)origin), (int)2);
    }

    @Override
    public float op(float origin) {
        return 1.0f / (float)FastMath.pow((double)FastMath.cos((double)origin), (int)2);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new TanDerivative(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new TanDerivative(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new TanDerivative(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new TanDerivative(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

