/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class LogX
extends BaseTransformOp {
    private double base;

    public LogX() {
    }

    public LogX(INDArray x, INDArray z, double base) {
        super(x, z);
        this.base = base;
        this.extraArgs = new Object[]{base};
    }

    public LogX(INDArray x, INDArray z, double base, long n) {
        super(x, z, n);
        this.base = base;
        this.extraArgs = new Object[]{base};
    }

    public LogX(INDArray x, INDArray y, INDArray z, double base, long n) {
        super(x, y, z, n);
        this.base = base;
        this.extraArgs = new Object[]{base};
    }

    public LogX(INDArray x, double base) {
        super(x);
        this.base = base;
        this.extraArgs = new Object[]{base};
    }

    @Override
    public int opNum() {
        return 55;
    }

    @Override
    public String name() {
        return "log_x";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.log(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.log(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.log(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.log((double)origin) / (float)FastMath.log((double)((float)this.base));
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.log((double)origin) / FastMath.log((double)this.base);
    }

    @Override
    public double op(double origin) {
        return FastMath.log((double)origin) / FastMath.log((double)this.base);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.log((double)origin) / (float)FastMath.log((double)this.base);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.log(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LogX(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), this.base, xAlongDimension.length());
        }
        return new LogX(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.base, this.x.lengthLong());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LogX(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), this.base, xAlongDimension.length());
        }
        return new LogX(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.base, this.x.lengthLong());
    }
}

