/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.ops.transforms.Transforms;

public class AdaDeltaUpdater
implements GradientUpdater<AdaDelta> {
    private final AdaDelta config;
    private INDArray msg;
    private INDArray msdx;

    public AdaDeltaUpdater(AdaDelta config) {
        this.config = config;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, int[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVector()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(0);
        }
        int length = viewArray.length();
        this.msg = viewArray.get(NDArrayIndex.point(0), NDArrayIndex.interval(0, length / 2));
        this.msdx = viewArray.get(NDArrayIndex.point(0), NDArrayIndex.interval(length / 2, length));
        this.msg = Shape.newShapeNoCopy(this.msg, gradientShape, gradientOrder == 'f');
        this.msdx = Shape.newShapeNoCopy(this.msdx, gradientShape, gradientOrder == 'f');
        if (this.msg == null || this.msdx == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view arrays");
        }
    }

    @Override
    public void applyUpdater(INDArray gradient, int iteration) {
        if (this.msg == null || this.msdx == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        double rho = this.config.getRho();
        double epsilon = this.config.getEpsilon();
        this.msg.muli(rho).addi(gradient.mul(gradient).muli(1.0 - rho));
        INDArray rmsdx_t1 = Transforms.sqrt(this.msdx.add(epsilon), false);
        INDArray rmsg_t = Transforms.sqrt(this.msg.add(epsilon), false);
        INDArray update = gradient.muli(rmsdx_t1.divi(rmsg_t));
        this.msdx.muli(rho).addi(update.mul(update).muli(1.0 - rho));
    }

    @Override
    public AdaDelta getConfig() {
        return this.config;
    }

    public INDArray getMsg() {
        return this.msg;
    }

    public INDArray getMsdx() {
        return this.msdx;
    }

    public void setMsg(INDArray msg) {
        this.msg = msg;
    }

    public void setMsdx(INDArray msdx) {
        this.msdx = msdx;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaDeltaUpdater)) {
            return false;
        }
        AdaDeltaUpdater other = (AdaDeltaUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdaDelta this$config = this.getConfig();
        AdaDelta other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        INDArray this$msg = this.getMsg();
        INDArray other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        INDArray this$msdx = this.getMsdx();
        INDArray other$msdx = other.getMsdx();
        return !(this$msdx == null ? other$msdx != null : !this$msdx.equals(other$msdx));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaDeltaUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdaDelta $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        INDArray $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        INDArray $msdx = this.getMsdx();
        result = result * 59 + ($msdx == null ? 43 : $msdx.hashCode());
        return result;
    }

    public String toString() {
        return "AdaDeltaUpdater(config=" + this.getConfig() + ", msg=" + this.getMsg() + ", msdx=" + this.getMsdx() + ")";
    }
}

