/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class ATan
extends BaseTransformOp {
    public ATan() {
    }

    public ATan(INDArray x, INDArray z) {
        super(x, z);
    }

    public ATan(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public ATan(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public ATan(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 18;
    }

    @Override
    public String name() {
        return "atan";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.atan(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.atan(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.atan(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.atan((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.atan((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.atan((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.atan((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.atan(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ATan(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ATan(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.x.lengthLong());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ATan(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ATan(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.x.lengthLong());
    }
}

