/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;
import net.ericaro.neoitertools.Itertools;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;

public class SpecifiedIndex
implements INDArrayIndex {
    private int[] indexes;
    private int counter = 0;

    public SpecifiedIndex(int ... indexes) {
        this.indexes = indexes;
    }

    @Override
    public int end() {
        return this.indexes[this.indexes.length - 1];
    }

    @Override
    public int offset() {
        return this.indexes[0];
    }

    @Override
    public int length() {
        return this.indexes.length;
    }

    @Override
    public int stride() {
        return 1;
    }

    @Override
    public int current() {
        return this.indexes[this.counter - 1];
    }

    @Override
    public boolean hasNext() {
        return this.counter < this.indexes.length;
    }

    @Override
    public int next() {
        return this.indexes[this.counter++];
    }

    @Override
    public void reverse() {
    }

    @Override
    public boolean isInterval() {
        return false;
    }

    @Override
    public void setInterval(boolean isInterval) {
    }

    @Override
    public void init(INDArray arr, int begin, int dimension) {
    }

    @Override
    public void init(INDArray arr, int dimension) {
    }

    @Override
    public void init(int begin, int end) {
    }

    @Override
    public void reset() {
        this.counter = 0;
    }

    public static Generator<List<List<Integer>>> iterate(INDArrayIndex ... indexes) {
        Generator gen = Itertools.product((Generator)new SpecifiedIndexesGenerator(indexes));
        return gen;
    }

    public Generator<List<Integer>> generator() {
        return new SingleGenerator();
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setIndexes(int[] indexes) {
        this.indexes = indexes;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecifiedIndex)) {
            return false;
        }
        SpecifiedIndex other = (SpecifiedIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getIndexes(), other.getIndexes())) {
            return false;
        }
        return this.getCounter() == other.getCounter();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpecifiedIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getIndexes());
        result = result * 59 + this.getCounter();
        return result;
    }

    public String toString() {
        return "SpecifiedIndex(indexes=" + Arrays.toString(this.getIndexes()) + ", counter=" + this.getCounter() + ")";
    }

    public class SingleGenerator
    implements Generator<List<Integer>> {
        public List<Integer> next() throws NoSuchElementException {
            if (!SpecifiedIndex.this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Ints.asList((int[])new int[]{SpecifiedIndex.this.next()});
        }
    }

    public static class SpecifiedIndexesGenerator
    implements Generator<Generator<List<Integer>>> {
        private int index = 0;
        private INDArrayIndex[] indexes;

        public SpecifiedIndexesGenerator(INDArrayIndex[] indexes) {
            this.indexes = indexes;
        }

        public Generator<List<Integer>> next() throws NoSuchElementException {
            if (this.index >= this.indexes.length) {
                throw new NoSuchElementException("Done");
            }
            SpecifiedIndex specifiedIndex = (SpecifiedIndex)this.indexes[this.index++];
            Generator<List<Integer>> ret = specifiedIndex.generator();
            return ret;
        }
    }
}

