/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.convolution;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;

public class Im2col
extends BaseTransformOp {
    private int kh;
    private int kw;
    private int sy;
    private int sx;
    private int ph;
    private int pw;
    boolean isSameMode;

    public Im2col() {
    }

    public Im2col(INDArray x, int kh, int kw, int sy, int sx, int ph, int pw, boolean isSameMode) {
        this(x, kh, kw, sy, sx, ph, pw, isSameMode, Im2col.getNewOutputArray(x, kh, kw, sy, sx, ph, pw, false));
    }

    public Im2col(INDArray x, int kh, int kw, int sy, int sx, int ph, int pw, boolean isSameMode, INDArray z) {
        super(x);
        this.kh = kh;
        this.kw = kw;
        this.sy = sy;
        this.sx = sx;
        this.ph = ph;
        this.pw = pw;
        this.isSameMode = isSameMode;
        this.z = z;
        this.extraArgs = this.extraArgs();
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public int opNum() {
        return 37;
    }

    @Override
    public String name() {
        return "im2col";
    }

    @Override
    public Object[] extraArgs() {
        return new Object[]{this.kw, this.kh, this.sx, this.sy, this.pw, this.ph, this.isSameMode ? 1.0 : 0.0};
    }

    private static INDArray getNewOutputArray(INDArray img, int kernelHeight, int kernelWidth, int strideY, int strideX, int padHeight, int padWidth, boolean coverAll) {
        int n = img.size(0);
        int c = img.size(1);
        int h = img.size(2);
        int w = img.size(3);
        int outHeight = Convolution.outSize(h, kernelHeight, strideY, padHeight, coverAll);
        int outWidth = Convolution.outSize(w, kernelWidth, strideX, padWidth, coverAll);
        return Nd4j.createUninitialized(new int[]{n, c, kernelHeight, kernelWidth, outHeight, outWidth}, 'c');
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return null;
    }

    @Override
    public float op(float origin, float other) {
        return 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return 0.0;
    }

    @Override
    public double op(double origin) {
        return 0.0;
    }

    @Override
    public float op(float origin) {
        return 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        return null;
    }
}

