/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.nio.Buffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.GridOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.MetaOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseOp
implements Op {
    protected INDArray x;
    protected INDArray y;
    protected INDArray z;
    protected long n;
    protected long numProcessed;
    protected Object[] extraArgs;
    protected boolean passThrough;
    protected DataBuffer extraArgz;

    public BaseOp() {
    }

    @Override
    public boolean isExecSpecial() {
        return false;
    }

    public static Op.Type getOpType(Op op) {
        Op.Type type = null;
        if (op instanceof TransformOp) {
            type = op.y() == null ? (!op.isExecSpecial() ? Op.Type.TRANSFORM : Op.Type.SPECIAL) : Op.Type.PAIRWISE;
        } else if (op instanceof Accumulation) {
            type = op.y() == null ? Op.Type.REDUCE : Op.Type.REDUCE3;
        } else if (op instanceof ScalarOp) {
            type = Op.Type.SCALAR;
        } else if (op instanceof BroadcastOp) {
            type = Op.Type.BROADCAST;
        } else if (op instanceof IndexAccumulation) {
            type = Op.Type.INDEXREDUCE;
        } else if (op instanceof MetaOp) {
            type = Op.Type.META;
        } else if (op instanceof GridOp) {
            type = Op.Type.GRID;
        }
        return type;
    }

    @Override
    public DataBuffer extraArgsDataBuff() {
        if (this.extraArgz != null) {
            return this.extraArgz;
        }
        if (this.extraArgs != null) {
            DataBuffer.Type dtype;
            DataBuffer.Type type = dtype = this.x != null ? this.x.data().dataType() : Nd4j.dataType();
            if (dtype == DataBuffer.Type.FLOAT || dtype == DataBuffer.Type.HALF) {
                float[] extraz = new float[this.extraArgs.length];
                for (int i = 0; i < this.extraArgs.length; ++i) {
                    float val;
                    Number arg = (Number)this.extraArgs[i];
                    extraz[i] = val = arg.floatValue();
                }
                this.extraArgz = Nd4j.getConstantHandler().getConstantBuffer(extraz);
                return this.extraArgz;
            }
            if (dtype == DataBuffer.Type.DOUBLE) {
                double[] extraz = new double[this.extraArgs.length];
                for (int i = 0; i < this.extraArgs.length; ++i) {
                    double val;
                    Number arg = (Number)this.extraArgs[i];
                    extraz[i] = val = arg.doubleValue();
                }
                this.extraArgz = Nd4j.getConstantHandler().getConstantBuffer(extraz);
                return this.extraArgz;
            }
        }
        return null;
    }

    @Override
    public Buffer extraArgsBuff() {
        if (this.extraArgs != null) {
            if (this.x.data().dataType() == DataBuffer.Type.FLOAT) {
                DataBuffer retBuff = Nd4j.createBuffer(new float[this.extraArgs.length]);
                for (int i = 0; i < this.extraArgs.length; ++i) {
                    Number val = (Number)this.extraArgs[i];
                    retBuff.put((long)i, val.floatValue());
                }
                return retBuff.asNioFloat();
            }
            DataBuffer retBuff = Nd4j.createBuffer(new double[this.extraArgs.length]);
            for (int i = 0; i < this.extraArgs.length; ++i) {
                Number val = (Number)this.extraArgs[i];
                retBuff.put((long)i, val.doubleValue());
            }
            return retBuff.asNioDouble();
        }
        return null;
    }

    @Override
    public boolean isPassThrough() {
        return this.passThrough;
    }

    @Override
    public void setX(INDArray x) {
        if (x == null) {
            throw new IllegalArgumentException("X must not be null");
        }
        this.x = x;
        this.numProcessed = 0L;
    }

    @Override
    public void setZ(INDArray z) {
        if (z == null) {
            throw new IllegalArgumentException("Z must not be null");
        }
        this.z = z;
        this.numProcessed = 0L;
    }

    @Override
    public void setY(INDArray y) {
        if (y == null) {
            throw new IllegalArgumentException("Y must not be null");
        }
        this.y = y;
        this.numProcessed = 0L;
    }

    public BaseOp(INDArray x, INDArray z) {
        this(x, z, x.lengthLong());
    }

    public BaseOp(INDArray x, INDArray z, long n) {
        this(x, null, z, n);
    }

    public BaseOp(INDArray x, INDArray y, INDArray z, long n) {
        this.init(x, y, z, n);
    }

    public BaseOp(INDArray x) {
        this(x, null, x, x.lengthLong());
    }

    @Override
    public Object[] extraArgs() {
        return this.extraArgs;
    }

    @Override
    public INDArray x() {
        return this.x;
    }

    @Override
    public INDArray y() {
        return this.y;
    }

    @Override
    public INDArray z() {
        return this.z;
    }

    @Override
    public long n() {
        return this.n;
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.n = n;
    }

    @Override
    public void setN(long n) {
        this.n = n;
    }

    @Override
    public long numProcessed() {
        return this.numProcessed;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public void exec() {
    }

    @Override
    public void exec(int ... dimensions) {
    }
}

