/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.dataset.api.DataSetUtil;
import org.nd4j.linalg.dataset.api.preprocessor.NormalizerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.stats.DistributionStats;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.conditions.Conditions;

public class StandardizeStrategy
implements NormalizerStrategy<DistributionStats> {
    @Override
    public void preProcess(INDArray array, INDArray maskArray, DistributionStats stats) {
        if (array.rank() <= 2) {
            array.subiRowVector(stats.getMean());
            array.diviRowVector(StandardizeStrategy.filteredStd(stats));
        } else {
            Nd4j.getExecutioner().execAndReturn(new BroadcastSubOp(array, stats.getMean(), array, 1));
            Nd4j.getExecutioner().execAndReturn(new BroadcastDivOp(array, StandardizeStrategy.filteredStd(stats), array, 1));
        }
        if (maskArray != null) {
            DataSetUtil.setMaskedValuesToZero(array, maskArray);
        }
    }

    @Override
    public void revert(INDArray array, INDArray maskArray, DistributionStats stats) {
        if (array.rank() <= 2) {
            array.muliRowVector(StandardizeStrategy.filteredStd(stats));
            array.addiRowVector(stats.getMean());
        } else {
            Nd4j.getExecutioner().execAndReturn(new BroadcastMulOp(array, StandardizeStrategy.filteredStd(stats), array, 1));
            Nd4j.getExecutioner().execAndReturn(new BroadcastAddOp(array, stats.getMean(), array, 1));
        }
        if (maskArray != null) {
            DataSetUtil.setMaskedValuesToZero(array, maskArray);
        }
    }

    private static INDArray filteredStd(DistributionStats stats) {
        INDArray stdCopy = stats.getStd();
        BooleanIndexing.replaceWhere(stdCopy, 1.0, Conditions.equals(0));
        return stdCopy;
    }
}

