/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import java.io.File;
import java.io.IOException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.preprocessor.DataNormalization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePreProcessingScaler
implements DataNormalization {
    private static final Logger log = LoggerFactory.getLogger(ImagePreProcessingScaler.class);
    private double minRange;
    private double maxRange;
    private double maxPixelVal;
    private int maxBits;

    public ImagePreProcessingScaler() {
        this(0.0, 1.0, 8);
    }

    public ImagePreProcessingScaler(double a, double b) {
        this(a, b, 8);
    }

    public ImagePreProcessingScaler(double a, double b, int maxBits) {
        this.maxPixelVal = Math.pow(2.0, maxBits) - 1.0;
        this.minRange = a;
        this.maxRange = b;
    }

    @Override
    public void fit(DataSet dataSet) {
    }

    @Override
    public void fit(DataSetIterator iterator) {
    }

    @Override
    public void preProcess(DataSet toPreProcess) {
        INDArray features = toPreProcess.getFeatures();
        this.preProcess(features);
    }

    public void preProcess(INDArray features) {
        features.divi(this.maxPixelVal);
        if (this.maxRange - this.minRange != 1.0) {
            features.muli(this.maxRange - this.minRange);
        }
        if (this.minRange != 0.0) {
            features.addi(this.minRange);
        }
    }

    @Override
    public void transform(DataSet toPreProcess) {
        this.preProcess(toPreProcess);
    }

    @Override
    public void transform(INDArray features) {
        this.preProcess(features);
    }

    @Override
    public void transformLabel(INDArray label) {
    }

    @Override
    public void revert(DataSet toRevert) {
        this.revertFeatures(toRevert.getFeatures());
    }

    @Override
    public void revertFeatures(INDArray features) {
        if (this.minRange != 0.0) {
            features.subi(this.minRange);
        }
        if (this.maxRange - this.minRange != 1.0) {
            features.divi(this.maxRange - this.minRange);
        }
        features.muli(this.maxPixelVal);
    }

    @Override
    public void revertLabels(INDArray labels) {
    }

    @Override
    public void fitLabel(boolean fitLabels) {
        if (fitLabels) {
            log.warn("Labels fitting not currently supported for ImagePreProcessingScaler. Labels will not be modified");
        }
    }

    @Override
    public boolean isFitLabel() {
        return false;
    }

    @Override
    public void load(File ... statistics) throws IOException {
    }

    @Override
    public void save(File ... statistics) throws IOException {
    }
}

