/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.compression;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lombok.NonNull;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedDataBuffer
extends BaseDataBuffer {
    protected CompressionDescriptor compressionDescriptor;
    private static Logger logger = LoggerFactory.getLogger(CompressedDataBuffer.class);

    public CompressedDataBuffer(Pointer pointer, @NonNull CompressionDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.compressionDescriptor = descriptor;
        this.pointer = pointer;
        this.length = descriptor.getNumberOfElements();
        this.elementSize = (int)descriptor.getOriginalElementSize();
        this.initTypeAndSize();
    }

    protected void initTypeAndSize() {
        this.type = DataBuffer.Type.COMPRESSED;
        this.allocationMode = DataBuffer.AllocationMode.JAVACPP;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.allocationMode.name());
        out.writeInt((int)this.compressionDescriptor.getCompressedLength());
        out.writeUTF(DataBuffer.Type.COMPRESSED.name());
        out.writeUTF(this.compressionDescriptor.getCompressionAlgorithm());
        out.writeLong(this.compressionDescriptor.getCompressedLength());
        out.writeLong(this.compressionDescriptor.getOriginalLength());
        out.writeLong(this.compressionDescriptor.getNumberOfElements());
        int x = 0;
        while ((long)x < this.pointer.capacity() * (long)this.pointer.sizeof()) {
            byte b = this.pointer.asByteBuffer().get(x);
            out.writeByte(b);
            ++x;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DataBuffer readUnknown(DataInputStream s, long length) {
        DataBuffer buffer = Nd4j.createBuffer(length);
        buffer.read(s);
        if (buffer.dataType() != DataBuffer.Type.COMPRESSED) {
            return buffer;
        }
        try {
            String compressionAlgorithm = s.readUTF();
            long compressedLength = s.readLong();
            long originalLength = s.readLong();
            long numberOfElements = s.readLong();
            byte[] temp = new byte[(int)compressedLength];
            int i = 0;
            while ((long)i < compressedLength) {
                temp[i] = s.readByte();
                ++i;
            }
            try (BytePointer pointer = new BytePointer(temp);){
                CompressionDescriptor descriptor = new CompressionDescriptor();
                descriptor.setCompressedLength(compressedLength);
                descriptor.setCompressionAlgorithm(compressionAlgorithm);
                descriptor.setOriginalLength(originalLength);
                descriptor.setNumberOfElements(numberOfElements);
                CompressedDataBuffer compressedBuffer = new CompressedDataBuffer((Pointer)pointer, descriptor);
                DataBuffer dataBuffer = Nd4j.getCompressor().decompress((DataBuffer)compressedBuffer);
                return dataBuffer;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DataBuffer dup() {
        BytePointer nPtr = new BytePointer(this.compressionDescriptor.getCompressedLength());
        Pointer.memcpy((Pointer)nPtr, (Pointer)this.pointer, (long)this.compressionDescriptor.getCompressedLength());
        CompressionDescriptor nDesc = this.compressionDescriptor.clone();
        CompressedDataBuffer nBuf = new CompressedDataBuffer((Pointer)nPtr, nDesc);
        return nBuf;
    }

    public long length() {
        return this.compressionDescriptor.getNumberOfElements();
    }

    protected DataBuffer create(long length) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    public DataBuffer create(double[] data) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    public DataBuffer create(float[] data) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    public DataBuffer create(int[] data) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    public IComplexFloat getComplexFloat(long i) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    public IComplexDouble getComplexDouble(long i) {
        throw new UnsupportedOperationException("This operation isn't supported for CompressedDataBuffer");
    }

    public CompressionDescriptor getCompressionDescriptor() {
        return this.compressionDescriptor;
    }

    public void setCompressionDescriptor(CompressionDescriptor compressionDescriptor) {
        this.compressionDescriptor = compressionDescriptor;
    }
}

