/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.api.ops.Op;

public class ScalarSubtraction
extends BaseScalarOp {
    public ScalarSubtraction() {
    }

    public ScalarSubtraction(INDArray x, INDArray y, INDArray z, long n, Number num) {
        super(x, y, z, n, num);
    }

    public ScalarSubtraction(INDArray x, Number num) {
        super(x, num);
    }

    public ScalarSubtraction(INDArray x, INDArray y, INDArray z, long n, IComplexNumber num) {
        super(x, y, z, n, num);
    }

    public ScalarSubtraction(INDArray x, IComplexNumber num) {
        super(x, num);
    }

    public ScalarSubtraction(INDArray x) {
        this(x, 0);
    }

    @Override
    public int opNum() {
        return 1;
    }

    @Override
    public String name() {
        return "sub_scalar";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (this.complexNumber != null) {
            return origin.sub(this.complexNumber);
        }
        return this.complexNumber.sub(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (this.complexNumber != null) {
            return origin.sub(this.complexNumber);
        }
        return this.complexNumber.sub(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        if (this.complexNumber != null) {
            return origin.sub(this.complexNumber);
        }
        return this.complexNumber.sub(this.num);
    }

    @Override
    public float op(float origin, float other) {
        return origin - this.num.floatValue();
    }

    @Override
    public double op(double origin, double other) {
        return origin - this.num.doubleValue();
    }

    @Override
    public double op(double origin) {
        return origin - this.num.doubleValue();
    }

    @Override
    public float op(float origin) {
        return origin - this.num.floatValue();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        if (this.complexNumber != null) {
            return origin.sub(this.complexNumber);
        }
        return this.complexNumber.sub(this.num);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.num != null) {
            return new ScalarSubtraction(this.x.vectorAlongDimension(index, dimension), this.num);
        }
        return new ScalarSubtraction(this.x.vectorAlongDimension(index, dimension), this.complexNumber);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        if (this.num != null) {
            return new ScalarSubtraction(this.x.tensorAlongDimension(index, dimension), this.num);
        }
        return new ScalarSubtraction(this.x.tensorAlongDimension(index, dimension), this.complexNumber);
    }
}

