/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.params;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class GemmParams {
    private int lda;
    private int ldb;
    private int ldc;
    private int m;
    private int n;
    private int k;
    private INDArray a;
    private INDArray b;
    private INDArray c;
    private char transA = (char)78;
    private char transB = (char)78;
    private char ordering = (char)102;

    public GemmParams(INDArray a, INDArray b, INDArray c) {
        if (b.columns() != c.columns()) {
            throw new IllegalArgumentException("B columns must match C columns");
        }
        if (a.rows() != c.rows()) {
            throw new IllegalArgumentException("A rows must equal C rows");
        }
        if (Nd4j.allowsSpecifyOrdering()) {
            if (a.ordering() == b.ordering()) {
                this.ordering = a.ordering();
                this.a = this.copyIfNeccessary(a);
                this.b = this.copyIfNeccessary(b);
                this.c = c;
                if (this.ordering == 'c') {
                    this.m = c.columns();
                    this.n = c.rows();
                    this.k = a.columns();
                } else {
                    this.m = c.rows();
                    this.n = c.columns();
                    this.k = b.columns();
                }
                this.lda = a.rows();
                this.ldb = b.rows();
                this.ldc = c.rows();
                this.transA = (char)78;
                this.transB = (char)78;
            } else {
                this.a = this.copyIfNeccessary(a);
                this.b = b.dup(a.ordering());
                this.c = c;
                this.m = c.rows();
                this.n = c.columns();
                this.k = a.columns();
                this.ordering = a.ordering();
                this.lda = a.rows();
                this.ldb = b.rows();
                this.ldc = c.rows();
                this.transA = (char)78;
                this.transB = (char)78;
            }
        } else {
            this.a = this.copyIfNeccessary(a);
            this.b = this.copyIfNeccessary(b);
            this.c = c;
            this.m = c.rows();
            this.n = c.columns();
            this.k = a.columns();
            this.lda = this.a.ordering() == 'f' ? this.a.rows() : this.a.columns();
            this.ldb = this.b.ordering() == 'f' ? this.b.rows() : this.b.columns();
            this.ldc = c.rows();
            this.transA = (char)(this.a.ordering() == 'c' ? 84 : 78);
            this.transB = (char)(this.b.ordering() == 'c' ? 84 : 78);
        }
    }

    public GemmParams(INDArray a, INDArray b, INDArray c, boolean transposeA, boolean transposeB) {
        this(transposeA ? a.transpose() : a, transposeB ? b.transpose() : b, c);
    }

    private INDArray copyIfNeccessary(INDArray arr) {
        if (arr.isMatrix()) {
            if (!(Nd4j.allowsSpecifyOrdering() || arr.ordering() != 'c' || arr.stride(0) == arr.size(1) && arr.stride(1) == 1)) {
                return arr.dup();
            }
            if (arr.ordering() == 'f' && (arr.stride(0) != 1 || arr.stride(1) != arr.size(0))) {
                return arr.dup();
            }
            if (arr.elementWiseStride() < 0) {
                return arr.dup();
            }
        }
        return arr;
    }

    private void validate() {
        if (this.ordering == 'c') {
            if (this.transA == 'T' || this.transA == 't') {
                if (this.m != this.a.rows()) {
                    throw new IllegalArgumentException("M under transpose and c ordering must be A.columns()");
                }
                if (this.k != this.a.columns()) {
                    throw new IllegalArgumentException("K under transpose and c ordering must be A.rows()");
                }
            } else {
                if (this.m != this.a.columns()) {
                    throw new IllegalArgumentException("M under no transpose and c ordering must be A.rows()");
                }
                if (this.k != this.a.rows()) {
                    throw new IllegalArgumentException("K under no transpose and c ordering must be A.columns()");
                }
            }
        } else if (this.transB == 't' || this.transB == 'T') {
            if (this.n != this.b.columns()) {
                throw new IllegalArgumentException("N under transpose and c ordering ust be B.rows()");
            }
            if (this.k != this.b.rows()) {
                throw new IllegalArgumentException("K under tranpose and c ordering must be B.columns()");
            }
        } else {
            if (this.n != this.b.rows()) {
                throw new IllegalArgumentException("N under no transpose and c ordering must be B.columns()");
            }
            if (this.k != this.b.columns()) {
                throw new IllegalArgumentException("K under no transpose and c ordering must be B.rows()");
            }
        }
    }

    public int getLda() {
        return this.lda;
    }

    public int getLdb() {
        return this.ldb;
    }

    public int getLdc() {
        return this.ldc;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public INDArray getA() {
        return this.a;
    }

    public INDArray getB() {
        return this.b;
    }

    public INDArray getC() {
        return this.c;
    }

    public char getTransA() {
        return this.transA;
    }

    public char getTransB() {
        return this.transB;
    }

    public char getOrdering() {
        return this.ordering;
    }

    public void setLda(int lda) {
        this.lda = lda;
    }

    public void setLdb(int ldb) {
        this.ldb = ldb;
    }

    public void setLdc(int ldc) {
        this.ldc = ldc;
    }

    public void setM(int m) {
        this.m = m;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setA(INDArray a) {
        this.a = a;
    }

    public void setB(INDArray b) {
        this.b = b;
    }

    public void setC(INDArray c) {
        this.c = c;
    }

    public void setTransA(char transA) {
        this.transA = transA;
    }

    public void setTransB(char transB) {
        this.transB = transB;
    }

    public void setOrdering(char ordering) {
        this.ordering = ordering;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GemmParams)) {
            return false;
        }
        GemmParams other = (GemmParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLda() != other.getLda()) {
            return false;
        }
        if (this.getLdb() != other.getLdb()) {
            return false;
        }
        if (this.getLdc() != other.getLdc()) {
            return false;
        }
        if (this.getM() != other.getM()) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        if (this.getK() != other.getK()) {
            return false;
        }
        INDArray this$a = this.getA();
        INDArray other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        INDArray this$b = this.getB();
        INDArray other$b = other.getB();
        if (this$b == null ? other$b != null : !this$b.equals(other$b)) {
            return false;
        }
        INDArray this$c = this.getC();
        INDArray other$c = other.getC();
        if (this$c == null ? other$c != null : !this$c.equals(other$c)) {
            return false;
        }
        if (this.getTransA() != other.getTransA()) {
            return false;
        }
        if (this.getTransB() != other.getTransB()) {
            return false;
        }
        return this.getOrdering() == other.getOrdering();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GemmParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLda();
        result = result * 59 + this.getLdb();
        result = result * 59 + this.getLdc();
        result = result * 59 + this.getM();
        result = result * 59 + this.getN();
        result = result * 59 + this.getK();
        INDArray $a = this.getA();
        result = result * 59 + ($a == null ? 0 : $a.hashCode());
        INDArray $b = this.getB();
        result = result * 59 + ($b == null ? 0 : $b.hashCode());
        INDArray $c = this.getC();
        result = result * 59 + ($c == null ? 0 : $c.hashCode());
        result = result * 59 + this.getTransA();
        result = result * 59 + this.getTransB();
        result = result * 59 + this.getOrdering();
        return result;
    }

    public String toString() {
        return "GemmParams(lda=" + this.getLda() + ", ldb=" + this.getLdb() + ", ldc=" + this.getLdc() + ", m=" + this.getM() + ", n=" + this.getN() + ", k=" + this.getK() + ", a=" + this.getA() + ", b=" + this.getB() + ", c=" + this.getC() + ", transA=" + this.getTransA() + ", transB=" + this.getTransB() + ", ordering=" + this.getOrdering() + ")";
    }
}

