/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Prod
extends BaseAccumulation {
    public Prod() {
    }

    public Prod(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Prod(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public Prod(INDArray x) {
        super(x);
    }

    public Prod(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currentResult = this.currentResult.doubleValue() * result.doubleValue();
        ++this.numProcessed;
    }

    @Override
    public void update(IComplexNumber result) {
        this.currentComplexResult.muli(result);
        ++this.numProcessed;
    }

    @Override
    public Number zero() {
        return 1.0;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(1.0, 0.0);
    }

    @Override
    public String name() {
        return "prod";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Prod(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Prod(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Prod(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Prod(this.x.tensorAlongDimension(index, dimension));
    }
}

