/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks.cpu.accumulation;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.parallel.tasks.Task;
import org.nd4j.linalg.api.parallel.tasks.cpu.accumulation.BaseCPUAccumulationTask;

public class CPUAccumulationTask
extends BaseCPUAccumulationTask {
    protected List<Task<Double>> subTasks;

    public CPUAccumulationTask(Accumulation op, int threshold, int n, int offsetX, int offsetY, int incrX, int incrY, boolean outerTask) {
        super(op, threshold, n, offsetX, offsetY, incrX, incrY, outerTask);
    }

    public CPUAccumulationTask(Accumulation op, int threshold, boolean outerTask) {
        super(op, threshold, outerTask);
    }

    public CPUAccumulationTask(Accumulation op, int threshold, int tadIdx, int tadDim, boolean outerTask) {
        super(op, threshold, tadIdx, tadDim, outerTask);
    }

    @Override
    public Double blockUntilComplete() {
        Double accum;
        if (this.future == null) {
            this.invokeAsync();
        }
        try {
            accum = (Double)this.future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.subTasks != null) {
            accum = this.op.zeroDouble();
            for (Task<Double> task : this.subTasks) {
                double subAccum = task.blockUntilComplete();
                accum = this.op.combineSubResults(accum, subAccum);
            }
        }
        if (this.outerTask && this.subTasks != null) {
            return this.op.getAndSetFinalResult(accum);
        }
        return accum;
    }

    @Override
    public Double compute() {
        double out;
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nFirst = this.n / 2;
            CPUAccumulationTask first = new CPUAccumulationTask(this.op, this.threshold, nFirst, this.offsetX, this.offsetY, this.incrX, this.incrY, false);
            first.fork();
            int nSecond = this.n - nFirst;
            int offsetX2 = this.offsetX + nFirst * this.incrX;
            int offsetY2 = this.offsetY + nFirst * this.incrY;
            CPUAccumulationTask second = new CPUAccumulationTask(this.op, this.threshold, nSecond, offsetX2, offsetY2, this.incrX, this.incrY, false);
            second.fork();
            out = this.op.combineSubResults((Double)first.join(), (Double)second.join());
        } else {
            out = this.execute();
        }
        if (this.outerTask) {
            return this.op.getAndSetFinalResult(out);
        }
        return out;
    }

    @Override
    public Double call() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nSubTasks = 1 + this.n / this.threshold;
            this.subTasks = new ArrayList<Task<Double>>(nSubTasks);
            int taskSize = this.n / nSubTasks;
            int soFar = 0;
            for (int i = 0; i < nSubTasks; ++i) {
                int nInTask = i == nSubTasks - 1 ? this.n - soFar : taskSize;
                int offsetXNew = this.offsetX + soFar * this.incrX;
                int offsetYNew = this.offsetY + soFar * this.incrY;
                CPUAccumulationTask t = new CPUAccumulationTask(this.op, this.threshold, nInTask, offsetXNew, offsetYNew, this.incrX, this.incrY, false);
                t.invokeAsync();
                this.subTasks.add(t);
                soFar += nInTask;
            }
            return 0.0;
        }
        return this.execute();
    }

    private double execute() {
        DataBuffer y;
        DataBuffer x = this.op.x().data();
        DataBuffer dataBuffer = y = this.op.y() != null ? this.op.y().data() : null;
        if (y != null) {
            if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    float[] xf = (float[])x.array();
                    float[] yf = (float[])y.array();
                    float accum = this.op.zeroFloat();
                    if (this.incrX == 1 && this.incrY == 1) {
                        for (int i = 0; i < this.n; ++i) {
                            accum = this.op.update(accum, this.op.op(xf[this.offsetX + i], yf[this.offsetY + i]));
                        }
                    } else {
                        for (int i = 0; i < this.n; ++i) {
                            accum = this.op.update(accum, this.op.op(xf[this.offsetX + i * this.incrX], yf[this.offsetY + i * this.incrY]));
                        }
                    }
                    return accum;
                }
                double[] xd = (double[])x.array();
                double[] yd = (double[])y.array();
                double accum = this.op.zeroDouble();
                if (this.incrX == 1 && this.incrY == 1) {
                    for (int i = 0; i < this.n; ++i) {
                        accum = this.op.update(accum, this.op.op(xd[this.offsetX + i], yd[this.offsetY + i]));
                    }
                } else {
                    for (int i = 0; i < this.n; ++i) {
                        accum = this.op.update(accum, this.op.op(xd[this.offsetX + i * this.incrX], yd[this.offsetY + i * this.incrY]));
                    }
                }
                return accum;
            }
            ByteBuffer nbbx = x.asNio();
            ByteBuffer nbby = y.asNio();
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                int byteOffsetX = this.offsetX;
                int byteOffsetY = this.offsetY;
                FloatBuffer floatBufferX = nbbx.asFloatBuffer();
                FloatBuffer floatBufferY = nbby.asFloatBuffer();
                float accum = this.op.zeroFloat();
                if (this.incrX == 1 && this.incrY == 1) {
                    for (int i = 0; i < this.n; ++i) {
                        accum = this.op.update(accum, this.op.op(floatBufferX.get(byteOffsetX + i), floatBufferY.get(byteOffsetY + i)));
                    }
                } else {
                    for (int i = 0; i < this.n; ++i) {
                        accum = this.op.update(accum, this.op.op(floatBufferX.get(byteOffsetX + i * this.incrX), floatBufferY.get(byteOffsetY + i * this.incrY)));
                    }
                }
                return accum;
            }
            int byteOffsetX = this.offsetX;
            int byteOffsetY = this.offsetY;
            DoubleBuffer doubleBufferX = nbbx.asDoubleBuffer();
            DoubleBuffer doubleBufferY = nbby.asDoubleBuffer();
            double accum = this.op.zeroDouble();
            if (this.incrX == 1 && this.incrY == 1) {
                for (int i = 0; i < this.n; ++i) {
                    accum = this.op.update(accum, this.op.op(doubleBufferX.get(byteOffsetX + i), doubleBufferY.get(byteOffsetY + i)));
                }
            } else {
                for (int i = 0; i < this.n; ++i) {
                    accum = this.op.update(accum, this.op.op(doubleBufferX.get(byteOffsetX + i * this.incrX), doubleBufferY.get(byteOffsetY + i * this.incrY)));
                }
            }
            return accum;
        }
        if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                float[] xf = (float[])x.array();
                float accum = this.op.zeroFloat();
                if (this.incrX == 1) {
                    for (int i = 0; i < this.n; ++i) {
                        accum = this.op.update(accum, this.op.op(xf[this.offsetX + i]));
                    }
                } else {
                    for (int i = 0; i < this.n; ++i) {
                        accum = this.op.update(accum, this.op.op(xf[this.offsetX + i * this.incrX]));
                    }
                }
                return accum;
            }
            double[] xd = (double[])x.array();
            double accum = this.op.zeroDouble();
            if (this.incrX == 1) {
                for (int i = 0; i < this.n; ++i) {
                    accum = this.op.update(accum, this.op.op(xd[this.offsetX + i]));
                }
            } else {
                for (int i = 0; i < this.n; ++i) {
                    accum = this.op.update(accum, this.op.op(xd[this.offsetX + i * this.incrX]));
                }
            }
            return accum;
        }
        ByteBuffer nbbx = x.asNio();
        if (x.dataType() == DataBuffer.Type.FLOAT) {
            int byteOffsetX = this.offsetX;
            float accum = this.op.zeroFloat();
            FloatBuffer floatBuffer = nbbx.asFloatBuffer();
            if (this.incrX == 1) {
                for (int i = 0; i < this.n; ++i) {
                    accum = this.op.update(accum, this.op.op(floatBuffer.get(byteOffsetX + i)));
                }
            } else {
                for (int i = 0; i < this.n; ++i) {
                    accum = this.op.update(accum, this.op.op(floatBuffer.get(byteOffsetX + i * this.incrX)));
                }
            }
            return accum;
        }
        int byteOffsetX = this.offsetX;
        DoubleBuffer doubleBufferX = nbbx.asDoubleBuffer();
        double accum = this.op.zeroDouble();
        if (this.incrX == 1) {
            for (int i = 0; i < this.n; ++i) {
                accum = this.op.update(accum, this.op.op(doubleBufferX.get(byteOffsetX + i)));
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                accum = this.op.update(accum, this.op.op(doubleBufferX.get(byteOffsetX + i * this.incrX)));
            }
        }
        return accum;
    }
}

