/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.Exp;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMaxDerivative;
import org.nd4j.linalg.factory.Nd4j;

public class SoftMax
extends BaseTransformOp {
    private Number sum;
    private Number max;
    private IComplexNumber maxComplex;
    private IComplexNumber sumComplex;

    public SoftMax() {
    }

    public SoftMax(INDArray x, INDArray z) {
        super(x, z);
    }

    public SoftMax(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public SoftMax(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public SoftMax(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.length());
    }

    public SoftMax(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "softmax";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        IComplexNDArray arr = (IComplexNDArray)this.y;
        IComplexNumber ret = arr.getComplex(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        IComplexNDArray arr = (IComplexNDArray)this.y;
        IComplexNumber ret = arr.getComplex(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        IComplexNDArray arr = (IComplexNDArray)this.y;
        IComplexNumber ret = arr.getComplex(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public float op(float origin, float other) {
        float ret = other;
        ++this.numProcessed;
        return ret;
    }

    @Override
    public double op(double origin, double other) {
        double ret = other;
        ++this.numProcessed;
        return ret;
    }

    @Override
    public double op(double origin) {
        double ret = this.y.getDouble(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public float op(float origin) {
        float ret = this.y.getFloat(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        IComplexNDArray arr = (IComplexNDArray)this.y;
        IComplexNumber ret = arr.getComplex(this.numProcessed);
        ++this.numProcessed;
        return ret;
    }

    @Override
    public TransformOp derivative() {
        return new SoftMaxDerivative(this.x, this.y, this.z, this.n);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SoftMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SoftMax(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SoftMax(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SoftMax(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public void exec() {
        this.exec(1);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        this.passThrough = true;
    }

    @Override
    public void exec(int ... dimensions) {
        if (dimensions[0] != 1) {
            throw new IllegalArgumentException("Only supports row wise calculations");
        }
        if (this.x.isMatrix()) {
            INDArray maxAlongDimension = this.x.max(dimensions);
            if (!maxAlongDimension.isVector() && !maxAlongDimension.isScalar()) {
                throw new IllegalStateException("Max along dimension for input must either be a row vector or scalar");
            }
            INDArray xMinusMax = this.x.subColumnVector(maxAlongDimension);
            INDArray exp = this.z != null ? Nd4j.getExecutioner().execAndReturn(new Exp(xMinusMax, this.z)) : Nd4j.getExecutioner().execAndReturn(new Exp(xMinusMax));
            INDArray sum = exp.sum(dimensions);
            exp.diviColumnVector(sum);
            if (this.z == null) {
                this.z = exp;
            }
        } else if (this.x.isVector()) {
            double max = this.x.maxNumber().doubleValue();
            INDArray exp = this.z != null ? Nd4j.getExecutioner().execAndReturn(new Exp(this.x.sub(max), this.z)) : Nd4j.getExecutioner().execAndReturn(new Exp(this.x.sub(max)));
            exp.divi(exp.sumNumber().doubleValue());
            this.z = exp;
        }
    }
}

