/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class ELUDerivative
extends BaseTransformOp {
    public ELUDerivative() {
    }

    public ELUDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public ELUDerivative(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public ELUDerivative(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public ELUDerivative(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.length());
    }

    public ELUDerivative(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "eluderivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin.realComponent().doubleValue() >= 0.0 ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(FastMath.exp((double)origin.realComponent().doubleValue()), 0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin.realComponent().doubleValue() >= 0.0 ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(FastMath.exp((double)origin.realComponent().doubleValue()), 0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.realComponent().doubleValue() >= 0.0 ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(FastMath.exp((double)origin.realComponent().doubleValue()), 0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin.realComponent().doubleValue() >= 0.0 ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(FastMath.exp((double)origin.realComponent().doubleValue()), 0);
    }

    @Override
    public float op(float origin, float other) {
        return (double)origin >= 0.0 ? 1.0f : (float)FastMath.exp((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return origin >= 0.0 ? 1.0 : FastMath.exp((double)origin);
    }

    @Override
    public double op(double origin) {
        return origin >= 0.0 ? 1.0 : FastMath.exp((double)origin);
    }

    @Override
    public float op(float origin) {
        return (double)origin >= 0.0 ? 1.0f : (float)FastMath.exp((double)origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ELUDerivative(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ELUDerivative(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ELUDerivative(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ELUDerivative(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

