/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class CosineSimilarity
extends BaseAccumulation {
    private Number constantNormalizedByNorm2X;
    private Number constantNormalizedByNorm2Y;

    public CosineSimilarity() {
        this.passThrough = true;
    }

    public CosineSimilarity(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
        this.passThrough = true;
    }

    public CosineSimilarity(INDArray x, INDArray y, int n) {
        super(x, y, n);
        this.passThrough = true;
    }

    public CosineSimilarity(INDArray x) {
        super(x);
        this.passThrough = true;
    }

    public CosineSimilarity(INDArray x, INDArray y) {
        super(x, y);
        this.passThrough = true;
    }

    @Override
    public double update(double accum, double x) {
        return accum + x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x * y;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x * y;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.add(x * y);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.add(x.mul(y));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.add(x.mul(y));
    }

    @Override
    public String name() {
        return "cosinesimilarity";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.mul(other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.mul(Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.mul(other);
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new CosineSimilarity(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new CosineSimilarity(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xForDimesnion = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new CosineSimilarity(xForDimesnion, this.y.tensorAlongDimension(index, dimension), xForDimesnion.length());
        }
        return new CosineSimilarity(this.x.tensorAlongDimension(index, dimension));
    }

    @Override
    public void exec() {
        this.constantNormalizedByNorm2X = this.x.norm2Number();
        this.constantNormalizedByNorm2Y = this.y.norm2Number();
        this.extraArgs = new Object[]{0.0, this.constantNormalizedByNorm2X, this.constantNormalizedByNorm2Y};
        double dot = Nd4j.getBlasWrapper().dot(this.x, this.y);
        this.finalResult = dot / (this.constantNormalizedByNorm2X.doubleValue() * this.constantNormalizedByNorm2Y.doubleValue());
    }

    @Override
    public void exec(int ... dimension) {
        int[] retShape = ArrayUtil.removeIndex(this.x.shape(), dimension);
        int nOps = this.x.tensorssAlongDimension(dimension);
        this.z = Nd4j.create(retShape);
        for (int i = 0; i < nOps; ++i) {
            double d = Nd4j.getExecutioner().execAndReturn((CosineSimilarity)this.opForDimension(i, dimension)).getFinalResult().doubleValue();
            this.z.putScalar(i, d);
        }
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        double d = accum / (this.constantNormalizedByNorm2X.doubleValue() * this.constantNormalizedByNorm2Y.doubleValue());
        this.finalResult = d;
        return d;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        return (float)this.getAndSetFinalResult((double)accum);
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = Nd4j.createComplexNumber(accum.realComponent().doubleValue() / (this.constantNormalizedByNorm2X.doubleValue() * this.constantNormalizedByNorm2Y.doubleValue()), 0);
        return this.finalResultComplex;
    }

    @Override
    public double calculateFinalResult(double accum, int n) {
        throw new UnsupportedOperationException("Not supported for passthrough op");
    }

    @Override
    public float calculateFinalResult(float accum, int n) {
        throw new UnsupportedOperationException("Not supported for passthrough op");
    }
}

