/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class StandardDeviation
extends Variance {
    public StandardDeviation() {
    }

    public StandardDeviation(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public StandardDeviation(INDArray x) {
        super(x);
    }

    public StandardDeviation(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public String name() {
        return "std";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new StandardDeviation(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new StandardDeviation(xAlongDimension);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new StandardDeviation(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new StandardDeviation(xAlongDimension);
    }

    @Override
    public void exec() {
        super.exec();
    }

    @Override
    public void exec(int ... dimension) {
        if (dimension.length == 1 && dimension[0] == Integer.MAX_VALUE) {
            this.exec();
            this.z = Nd4j.scalar(this.finalResult);
            return;
        }
        int[] retShape = ArrayUtil.removeIndex(this.x.shape(), dimension);
        int nOps = this.x.tensorssAlongDimension(dimension);
        this.z = Nd4j.create(retShape);
        for (int i = 0; i < nOps; ++i) {
            double d = Nd4j.getExecutioner().execAndReturn((StandardDeviation)this.opForDimension(i, dimension)).getFinalResult().doubleValue();
            this.z.putScalar(i, d);
        }
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        double d = FastMath.sqrt((double)super.getAndSetFinalResult(accum));
        this.finalResult = d;
        return d;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        float f = (float)FastMath.sqrt((double)super.getAndSetFinalResult(accum));
        this.finalResult = Float.valueOf(f);
        return f;
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = super.getAndSetFinalResult(accum).sqrt();
        return this.finalResultComplex;
    }

    @Override
    public double calculateFinalResult(double accum, int n) {
        return FastMath.sqrt((double)super.calculateFinalResult(accum, n));
    }

    @Override
    public float calculateFinalResult(float accum, int n) {
        return (float)FastMath.sqrt((double)super.calculateFinalResult(accum, n));
    }
}

