/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.executioner;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.util.ArrayUtil;

public class OpExecutionerUtil {
    public static boolean canDoOpDirectly(INDArray x) {
        int dl1;
        if (x.isVector()) {
            return true;
        }
        int l1 = x.length();
        if (l1 == (dl1 = x.data().length())) {
            return true;
        }
        int[] shape1 = x.shape();
        int[] stridesAsInit = x.ordering() == 'c' ? ArrayUtil.calcStrides(shape1) : ArrayUtil.calcStridesFortran(shape1);
        boolean stridesSameAsInit = Arrays.equals(x.stride(), stridesAsInit);
        return stridesSameAsInit;
    }

    public static boolean canDoOpDirectly(INDArray x, INDArray y) {
        if (x.isVector()) {
            return true;
        }
        if (x.ordering() != y.ordering()) {
            return false;
        }
        int l1 = x.length();
        int dl1 = x.data().length();
        int l2 = y.length();
        int dl2 = y.data().length();
        int[] strides1 = x.stride();
        int[] strides2 = y.stride();
        boolean equalStrides = Arrays.equals(strides1, strides2);
        if (l1 == dl1 && l2 == dl2 && equalStrides) {
            return true;
        }
        if (equalStrides) {
            int[] shape1 = x.shape();
            int[] stridesAsInit = x.ordering() == 'c' ? ArrayUtil.calcStrides(shape1) : ArrayUtil.calcStridesFortran(shape1);
            boolean stridesSameAsInit = Arrays.equals(strides1, stridesAsInit);
            return stridesSameAsInit;
        }
        return false;
    }

    public static boolean canDoOpDirectly(INDArray x, INDArray y, INDArray z) {
        boolean equalStrides;
        if (x.isVector()) {
            return true;
        }
        if (x.ordering() != y.ordering() || x.ordering() != z.ordering()) {
            return false;
        }
        int l1 = x.length();
        int dl1 = x.data().length();
        int l2 = y.length();
        int dl2 = y.data().length();
        int l3 = z.length();
        int dl3 = z.data().length();
        int[] strides1 = x.stride();
        int[] strides2 = y.stride();
        int[] strides3 = z.stride();
        boolean bl = equalStrides = Arrays.equals(strides1, strides2) && Arrays.equals(strides1, strides3);
        if (l1 == dl1 && l2 == dl2 && l3 == dl3 && equalStrides) {
            return true;
        }
        if (equalStrides) {
            int[] shape1 = x.shape();
            int[] stridesAsInit = x.ordering() == 'c' ? ArrayUtil.calcStrides(shape1) : ArrayUtil.calcStridesFortran(shape1);
            boolean stridesSameAsInit = Arrays.equals(strides1, stridesAsInit);
            return stridesSameAsInit;
        }
        return false;
    }

    public static int chooseElementWiseTensorDimension(INDArray x) {
        int nOpsAlongMaxLength;
        if (x.isVector()) {
            return ArrayUtil.argMax(x.shape());
        }
        int opAlongDimensionMinStride = ArrayUtil.argMin(x.stride());
        int opAlongDimensionMaxLength = ArrayUtil.argMax(x.shape());
        if (x.isVector() || x.size(opAlongDimensionMinStride) == 1) {
            return opAlongDimensionMaxLength;
        }
        int nOpsAlongMinStride = ArrayUtil.prod(ArrayUtil.removeIndex(x.shape(), opAlongDimensionMinStride));
        if (nOpsAlongMinStride <= 10 * (nOpsAlongMaxLength = ArrayUtil.prod(ArrayUtil.removeIndex(x.shape(), opAlongDimensionMaxLength)))) {
            return opAlongDimensionMinStride;
        }
        return opAlongDimensionMaxLength;
    }

    public static int chooseElementWiseTensorDimension(INDArray x, INDArray y) {
        int nOpsAlongMaxLength;
        int opAlongDimensionMaxLength;
        if (x.isVector()) {
            return ArrayUtil.argMax(x.shape());
        }
        int opAlongDimensionMinStride = ArrayUtil.argMinOfMax(x.stride(), y.stride());
        if (opAlongDimensionMinStride == (opAlongDimensionMaxLength = ArrayUtil.argMax(x.shape())) || x.size(opAlongDimensionMinStride) == 1) {
            return opAlongDimensionMaxLength;
        }
        int nOpsAlongMinStride = ArrayUtil.prod(ArrayUtil.removeIndex(x.shape(), opAlongDimensionMinStride));
        if (nOpsAlongMinStride <= 10 * (nOpsAlongMaxLength = ArrayUtil.prod(ArrayUtil.removeIndex(x.shape(), opAlongDimensionMaxLength)))) {
            return opAlongDimensionMinStride;
        }
        return opAlongDimensionMaxLength;
    }

    public static int chooseElementWiseTensorDimension(INDArray x, INDArray y, INDArray z) {
        int nOpsAlongMaxLength;
        int opAlongDimensionMaxLength;
        if (x.isVector()) {
            return ArrayUtil.argMax(x.shape());
        }
        int opAlongDimensionMinStride = ArrayUtil.argMinOfMax(x.stride(), y.stride(), z.stride());
        if (opAlongDimensionMinStride == (opAlongDimensionMaxLength = ArrayUtil.argMax(x.shape())) || x.size(opAlongDimensionMinStride) == 1) {
            return opAlongDimensionMaxLength;
        }
        int nOpsAlongMinStride = ArrayUtil.prod(ArrayUtil.removeIndex(x.shape(), opAlongDimensionMinStride));
        if (nOpsAlongMinStride <= 10 * (nOpsAlongMaxLength = ArrayUtil.prod(ArrayUtil.removeIndex(x.shape(), opAlongDimensionMaxLength)))) {
            return opAlongDimensionMinStride;
        }
        return opAlongDimensionMaxLength;
    }

    public static Tensor1DStats get1DTensorStats(INDArray array, int ... dimension) {
        int elementWiseStride;
        int tensorStartSeparation;
        int tensorLength = array.size(dimension[0]);
        int numTensors = array.tensorssAlongDimension(dimension);
        int firstTensorOffset = array.offset();
        if (numTensors == 1) {
            tensorStartSeparation = -1;
            elementWiseStride = array.elementWiseStride();
        } else {
            INDArray secondTensor = array.tensorAlongDimension(1, dimension);
            tensorStartSeparation = secondTensor.offset() - firstTensorOffset;
            elementWiseStride = secondTensor.elementWiseStride();
        }
        return new Tensor1DStats(firstTensorOffset, tensorStartSeparation, numTensors, tensorLength, elementWiseStride);
    }

    public static class Tensor1DStats {
        public final int firstTensorOffset;
        public final int tensorStartSeparation;
        public final int numTensors;
        public final int tensorLength;
        public final int elementWiseStride;

        @ConstructorProperties(value={"firstTensorOffset", "tensorStartSeparation", "numTensors", "tensorLength", "elementWiseStride"})
        public Tensor1DStats(int firstTensorOffset, int tensorStartSeparation, int numTensors, int tensorLength, int elementWiseStride) {
            this.firstTensorOffset = firstTensorOffset;
            this.tensorStartSeparation = tensorStartSeparation;
            this.numTensors = numTensors;
            this.tensorLength = tensorLength;
            this.elementWiseStride = elementWiseStride;
        }

        public int getFirstTensorOffset() {
            return this.firstTensorOffset;
        }

        public int getTensorStartSeparation() {
            return this.tensorStartSeparation;
        }

        public int getNumTensors() {
            return this.numTensors;
        }

        public int getTensorLength() {
            return this.tensorLength;
        }

        public int getElementWiseStride() {
            return this.elementWiseStride;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tensor1DStats)) {
                return false;
            }
            Tensor1DStats other = (Tensor1DStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFirstTensorOffset() != other.getFirstTensorOffset()) {
                return false;
            }
            if (this.getTensorStartSeparation() != other.getTensorStartSeparation()) {
                return false;
            }
            if (this.getNumTensors() != other.getNumTensors()) {
                return false;
            }
            if (this.getTensorLength() != other.getTensorLength()) {
                return false;
            }
            return this.getElementWiseStride() == other.getElementWiseStride();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tensor1DStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFirstTensorOffset();
            result = result * 59 + this.getTensorStartSeparation();
            result = result * 59 + this.getNumTensors();
            result = result * 59 + this.getTensorLength();
            result = result * 59 + this.getElementWiseStride();
            return result;
        }

        public String toString() {
            return "OpExecutionerUtil.Tensor1DStats(firstTensorOffset=" + this.getFirstTensorOffset() + ", tensorStartSeparation=" + this.getTensorStartSeparation() + ", numTensors=" + this.getNumTensors() + ", tensorLength=" + this.getTensorLength() + ", elementWiseStride=" + this.getElementWiseStride() + ")";
        }
    }
}

