/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;

public class Sgd
implements GradientUpdater {
    private double learningRate = 0.1;

    public Sgd(double learningRate) {
        this.learningRate = learningRate;
    }

    @Override
    public void update(Object ... args) {
        if (args.length > 0) {
            this.learningRate = (Double)args[0];
        }
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        return gradient.mul(this.learningRate);
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sgd)) {
            return false;
        }
        Sgd other = (Sgd)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getLearningRate(), other.getLearningRate()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sgd;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        return result;
    }

    public String toString() {
        return "Sgd(learningRate=" + this.getLearningRate() + ")";
    }

    public Sgd() {
    }
}

