/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks.cpu.scalar;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.parallel.tasks.cpu.scalar.BaseCPUScalarOpAction;

public class CPUScalarOpAction
extends BaseCPUScalarOpAction {
    public CPUScalarOpAction(ScalarOp op, int threshold, int n, int offsetX, int offsetZ, int incrX, int incrZ) {
        super(op, threshold, n, offsetX, offsetZ, incrX, incrZ);
    }

    public CPUScalarOpAction(ScalarOp op, int threshold) {
        super(op, threshold);
    }

    public CPUScalarOpAction(ScalarOp op, int threshold, int tadIdx, int tadDim) {
        super(op, threshold, tadIdx, tadDim);
    }

    @Override
    public Void call() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nSubTasks = 1 + this.n / this.threshold;
            this.subTasks = new ArrayList(nSubTasks);
            int taskSize = this.n / nSubTasks;
            int soFar = 0;
            for (int i = 0; i < nSubTasks; ++i) {
                int nInTask = i == nSubTasks - 1 ? this.n - soFar : taskSize;
                int offsetXNew = this.offsetX + soFar * this.incrX;
                int offsetZNew = this.offsetZ + soFar * this.incrZ;
                CPUScalarOpAction t = new CPUScalarOpAction(this.op, this.threshold, nInTask, offsetXNew, offsetZNew, this.incrX, this.incrZ);
                t.invokeAsync();
                this.subTasks.add(t);
                soFar += nInTask;
            }
        } else {
            this.execute();
        }
        return null;
    }

    @Override
    protected void compute() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nFirst = this.n / 2;
            CPUScalarOpAction first = new CPUScalarOpAction(this.op, this.threshold, nFirst, this.offsetX, this.offsetZ, this.incrX, this.incrZ);
            first.fork();
            int nSecond = this.n - nFirst;
            int offsetX2 = this.offsetX + nFirst * this.incrX;
            int offsetZ2 = this.offsetZ + nFirst * this.incrZ;
            CPUScalarOpAction second = new CPUScalarOpAction(this.op, this.threshold, nSecond, offsetX2, offsetZ2, this.incrX, this.incrZ);
            second.fork();
            first.join();
            second.join();
        } else {
            this.execute();
        }
    }

    private void execute() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        DataBuffer x = this.op.x().data();
        DataBuffer z = this.op.z().data();
        if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                float[] xf = (float[])x.array();
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i;
                            xf[xIdx] = this.op.op(xf[xIdx]);
                        }
                    } else {
                        float[] zf = (float[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zf[this.offsetZ + i] = this.op.op(xf[this.offsetX + i]);
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xIdx = this.offsetX + i * this.incrX;
                        xf[xIdx] = this.op.op(xf[xIdx]);
                    }
                } else {
                    float[] zf = (float[])z.array();
                    for (int i = 0; i < this.n; ++i) {
                        zf[this.offsetZ + i * this.incrZ] = this.op.op(xf[this.offsetX + i * this.incrX]);
                    }
                }
            } else {
                double[] xd = (double[])x.array();
                if (this.incrX == 1 && this.incrZ == 1) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i;
                            xd[xIdx] = this.op.op(xd[xIdx]);
                        }
                    } else {
                        double[] zd = (double[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zd[this.offsetZ + i] = this.op.op(xd[this.offsetX + i]);
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xIdx = this.offsetX + i * this.incrX;
                        xd[xIdx] = this.op.op(xd[xIdx]);
                    }
                } else {
                    double[] zd = (double[])z.array();
                    for (int i = 0; i < this.n; ++i) {
                        zd[this.offsetZ + i * this.incrZ] = this.op.op(xd[this.offsetX + i * this.incrX]);
                    }
                }
            }
        } else {
            ByteBuf nbbx = x.asNetty();
            ByteBuf nbbz = z.asNetty();
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                int byteOffsetX = 4 * this.offsetX;
                int byteOffsetZ = 4 * this.offsetZ;
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < 4 * this.n; i += 4) {
                            int xbIdx = byteOffsetX + i;
                            nbbx.setFloat(xbIdx, this.op.op(nbbx.getFloat(xbIdx)));
                        }
                    } else {
                        for (int i = 0; i < 4 * this.n; i += 4) {
                            nbbz.setFloat(byteOffsetZ + i, this.op.op(nbbx.getFloat(byteOffsetX + i)));
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < 4 * this.n; i += 4) {
                        int xbIdx = byteOffsetX + i * this.incrX;
                        nbbx.setFloat(xbIdx, this.op.op(nbbx.getFloat(xbIdx)));
                    }
                } else {
                    for (int i = 0; i < 4 * this.n; i += 4) {
                        nbbz.setFloat(byteOffsetZ + i * this.incrZ, this.op.op(nbbx.getFloat(byteOffsetX + i * this.incrX)));
                    }
                }
            } else {
                int byteOffsetX = 8 * this.offsetX;
                int byteOffsetZ = 8 * this.offsetZ;
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < 8 * this.n; i += 8) {
                            int xbIdx = byteOffsetX + i;
                            nbbx.setDouble(xbIdx, this.op.op(nbbx.getDouble(xbIdx)));
                        }
                    } else {
                        for (int i = 0; i < 8 * this.n; i += 8) {
                            nbbz.setDouble(byteOffsetZ + i, this.op.op(nbbx.getDouble(byteOffsetX + i)));
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < 8 * this.n; i += 8) {
                        int xbIdx = byteOffsetX + i * this.incrX;
                        nbbx.setDouble(xbIdx, this.op.op(nbbx.getDouble(xbIdx)));
                    }
                } else {
                    for (int i = 0; i < 8 * this.n; i += 8) {
                        nbbz.setDouble(byteOffsetZ + i * this.incrZ, this.op.op(nbbx.getDouble(byteOffsetX + i * this.incrX)));
                    }
                }
            }
        }
    }
}

