/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class ManhattanDistance
extends BaseAccumulation {
    public ManhattanDistance() {
    }

    public ManhattanDistance(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public ManhattanDistance(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public ManhattanDistance(INDArray x) {
        super(x);
    }

    public ManhattanDistance(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public double update(double accum, double x) {
        return accum;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + FastMath.abs((double)(x - y));
    }

    @Override
    public float update(float accum, float x) {
        return accum;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + FastMath.abs((float)(x - y));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.add(FastMath.abs((double)(x - y)));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.add(x.sub(y).absoluteValue());
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.add(x.sub(y).absoluteValue());
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    @Override
    public String name() {
        return "manhattan";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.sub(other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.sub(Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.sub(other);
    }

    @Override
    public float op(float origin, float other) {
        return origin - other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin - other;
    }

    @Override
    public double op(double origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.y() != null) {
            return new ManhattanDistance(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.x.length());
        }
        return new ManhattanDistance(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        if (this.y() != null) {
            return new ManhattanDistance(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.x.length());
        }
        return new ManhattanDistance(this.x.tensorAlongDimension(index, dimension));
    }
}

