/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks.cpu.transform;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.parallel.tasks.cpu.transform.BaseCPUTransformOpAction;

public class CPUTransformOpAction
extends BaseCPUTransformOpAction {
    public CPUTransformOpAction(TransformOp op, int threshold, int n, int offsetX, int offsetY, int offsetZ, int incrX, int incrY, int incrZ) {
        super(op, threshold, n, offsetX, offsetY, offsetZ, incrX, incrY, incrZ);
    }

    public CPUTransformOpAction(TransformOp op, int threshold) {
        super(op, threshold);
    }

    public CPUTransformOpAction(TransformOp op, int threshold, int tadIdx, int tadDim) {
        super(op, threshold, tadIdx, tadDim);
    }

    @Override
    public Void call() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nSubTasks = 1 + this.n / this.threshold;
            this.subTasks = new ArrayList(nSubTasks);
            int taskSize = this.n / nSubTasks;
            int soFar = 0;
            for (int i = 0; i < nSubTasks; ++i) {
                int nInTask = i == nSubTasks - 1 ? this.n - soFar : taskSize;
                int offsetXNew = this.offsetX + soFar * this.incrX;
                int offsetYNew = this.offsetY + soFar * this.incrY;
                int offsetZNew = this.offsetZ + soFar * this.incrZ;
                CPUTransformOpAction t = new CPUTransformOpAction(this.op, this.threshold, nInTask, offsetXNew, offsetYNew, offsetZNew, this.incrX, this.incrY, this.incrZ);
                t.invokeAsync();
                this.subTasks.add(t);
                soFar += nInTask;
            }
        } else {
            this.execute();
        }
        return null;
    }

    @Override
    protected void compute() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nFirst = this.n / 2;
            CPUTransformOpAction first = new CPUTransformOpAction(this.op, this.threshold, nFirst, this.offsetX, this.offsetY, this.offsetZ, this.incrX, this.incrY, this.incrZ);
            first.fork();
            int nSecond = this.n - nFirst;
            int offsetX2 = this.offsetX + nFirst * this.incrX;
            int offsetY2 = this.offsetY + nFirst * this.incrY;
            int offsetZ2 = this.offsetZ + nFirst * this.incrZ;
            CPUTransformOpAction second = new CPUTransformOpAction(this.op, this.threshold, nSecond, offsetX2, offsetY2, offsetZ2, this.incrX, this.incrY, this.incrZ);
            second.fork();
            first.join();
            second.join();
        } else {
            this.execute();
        }
    }

    private void execute() {
        DataBuffer x = this.op.x().data();
        DataBuffer y = this.op.y() != null ? this.op.y().data() : null;
        DataBuffer z = this.op.z().data();
        if (y != null) {
            if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    float[] xf = (float[])x.array();
                    float[] yf = (float[])y.array();
                    if (this.incrX == 1 && this.incrY == 1 && (x == z || this.incrZ == 1)) {
                        if (x == z) {
                            for (int i = 0; i < this.n; ++i) {
                                int xIdx = this.offsetX + i;
                                xf[xIdx] = this.op.op(xf[xIdx], yf[this.offsetY + i]);
                            }
                        } else {
                            float[] zf = (float[])z.array();
                            for (int i = 0; i < this.n; ++i) {
                                zf[this.offsetZ + i] = this.op.op(xf[this.offsetX + i], yf[this.offsetY + i]);
                            }
                        }
                    } else if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i * this.incrX;
                            xf[xIdx] = this.op.op(xf[xIdx], yf[this.offsetY + i * this.incrY]);
                        }
                    } else {
                        float[] zf = (float[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zf[this.offsetZ + i * this.incrZ] = this.op.op(xf[this.offsetX + i * this.incrX], yf[this.offsetY + i * this.incrY]);
                        }
                    }
                } else {
                    double[] xd = (double[])x.array();
                    double[] yd = (double[])y.array();
                    if (this.incrX == 1 && this.incrY == 1 && (x == z || this.incrZ == 1)) {
                        if (x == z) {
                            for (int i = 0; i < this.n; ++i) {
                                int xIdx = this.offsetX + i;
                                xd[xIdx] = this.op.op(xd[xIdx], yd[this.offsetY + i]);
                            }
                        } else {
                            double[] zd = (double[])z.array();
                            for (int i = 0; i < this.n; ++i) {
                                zd[this.offsetZ + i] = this.op.op(xd[this.offsetX + i], yd[this.offsetY + i]);
                            }
                        }
                    } else if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i * this.incrX;
                            xd[xIdx] = this.op.op(xd[xIdx], yd[this.offsetY + i * this.incrY]);
                        }
                    } else {
                        double[] zd = (double[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zd[this.offsetZ + i * this.incrZ] = this.op.op(xd[this.offsetX + i * this.incrX], yd[this.offsetY + i * this.incrY]);
                        }
                    }
                }
            } else {
                ByteBuf nbbx = x.asNetty();
                ByteBuf nbby = y.asNetty();
                ByteBuf nbbz = z.asNetty();
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    int byteOffsetX = 4 * this.offsetX;
                    int byteOffsetY = 4 * this.offsetY;
                    int byteOffsetZ = 4 * this.offsetZ;
                    if (this.incrX == 1 && this.incrY == 1 && (x == z || this.incrZ == 1)) {
                        if (x == z) {
                            for (int i = 0; i < 4 * this.n; i += 4) {
                                int xbOffset = byteOffsetX + i;
                                nbbx.setFloat(xbOffset, this.op.op(nbbx.getFloat(xbOffset), nbby.getFloat(byteOffsetY + i)));
                            }
                        } else {
                            for (int i = 0; i < 4 * this.n; i += 4) {
                                nbbz.setFloat(byteOffsetZ + i, this.op.op(nbbx.getFloat(byteOffsetX + i), nbby.getFloat(byteOffsetY + i)));
                            }
                        }
                    } else if (x == z) {
                        for (int i = 0; i < 4 * this.n; i += 4) {
                            int xbOffset = byteOffsetX + i * this.incrX;
                            nbbx.setFloat(xbOffset, this.op.op(nbbx.getFloat(xbOffset), nbby.getFloat(byteOffsetY + i * this.incrY)));
                        }
                    } else {
                        for (int i = 0; i < 4 * this.n; i += 4) {
                            nbbz.setFloat(byteOffsetZ + i * this.incrZ, this.op.op(nbbx.getFloat(byteOffsetX + i * this.incrX), nbby.getFloat(byteOffsetY + i * this.incrY)));
                        }
                    }
                } else {
                    int byteOffsetX = 8 * this.offsetX;
                    int byteOffsetY = 8 * this.offsetY;
                    int byteOffsetZ = 8 * this.offsetZ;
                    if (this.incrX == 1 && this.incrY == 1 && (x == z || this.incrZ == 1)) {
                        if (x == z) {
                            for (int i = 0; i < 8 * this.n; i += 8) {
                                int xbOffset = byteOffsetX + i;
                                nbbx.setDouble(xbOffset, this.op.op(nbbx.getDouble(xbOffset), nbby.getDouble(byteOffsetY + i)));
                            }
                        } else {
                            for (int i = 0; i < 8 * this.n; i += 8) {
                                nbbz.setDouble(byteOffsetZ + i, this.op.op(nbbx.getDouble(byteOffsetX + i), nbby.getDouble(byteOffsetY + i)));
                            }
                        }
                    } else if (x == z) {
                        for (int i = 0; i < 8 * this.n; i += 8) {
                            int xbOffset = byteOffsetX + i * this.incrX;
                            nbbx.setDouble(xbOffset, this.op.op(nbbx.getDouble(xbOffset), nbby.getDouble(byteOffsetY + i * this.incrY)));
                        }
                    } else {
                        for (int i = 0; i < 8 * this.n; i += 8) {
                            nbbz.setDouble(byteOffsetZ + i * this.incrZ, this.op.op(nbbx.getDouble(byteOffsetX + i * this.incrX), nbby.getDouble(byteOffsetY + i * this.incrY)));
                        }
                    }
                }
            }
        } else if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                float[] xf = (float[])x.array();
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i;
                            xf[xIdx] = this.op.op(xf[xIdx]);
                        }
                    } else {
                        float[] zf = (float[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zf[this.offsetZ + i] = this.op.op(xf[this.offsetX + i]);
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xIdx = this.offsetX + i * this.incrX;
                        xf[xIdx] = this.op.op(xf[xIdx]);
                    }
                } else {
                    float[] zf = (float[])z.array();
                    for (int i = 0; i < this.n; ++i) {
                        zf[this.offsetZ + i * this.incrZ] = this.op.op(xf[this.offsetX + i * this.incrX]);
                    }
                }
            } else {
                double[] xd = (double[])x.array();
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i;
                            xd[xIdx] = this.op.op(xd[xIdx]);
                        }
                    } else {
                        double[] zd = (double[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zd[this.offsetZ + i] = this.op.op(xd[this.offsetX + i]);
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xIdx = this.offsetX + i * this.incrX;
                        xd[xIdx] = this.op.op(xd[xIdx]);
                    }
                } else {
                    double[] zd = (double[])z.array();
                    for (int i = 0; i < this.n; ++i) {
                        zd[this.offsetZ + i * this.incrZ] = this.op.op(xd[this.offsetX + i * this.incrX]);
                    }
                }
            }
        } else {
            ByteBuf nbbx = x.asNetty();
            ByteBuf nbbz = z.asNetty();
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                int byteOffsetX = 4 * this.offsetX;
                int byteOffsetZ = 4 * this.offsetZ;
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < 4 * this.n; i += 4) {
                            int xbOffset = byteOffsetX + i;
                            nbbx.setFloat(xbOffset, this.op.op(nbbx.getFloat(xbOffset)));
                        }
                    } else {
                        for (int i = 0; i < 4 * this.n; i += 4) {
                            nbbz.setFloat(byteOffsetZ + i, this.op.op(nbbx.getFloat(byteOffsetX + i)));
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < 4 * this.n; i += 4) {
                        int xbOffset = byteOffsetX + i * this.incrX;
                        nbbx.setFloat(xbOffset, this.op.op(nbbx.getFloat(xbOffset)));
                    }
                } else {
                    for (int i = 0; i < 4 * this.n; ++i) {
                        nbbz.setFloat(byteOffsetZ + i * this.incrZ, this.op.op(nbbx.getFloat(byteOffsetX + i * this.incrX)));
                    }
                }
            } else {
                int byteOffsetX = 8 * this.offsetX;
                int byteOffsetZ = 8 * this.offsetZ;
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < 8 * this.n; i += 8) {
                            int xbOffset = byteOffsetX + i;
                            nbbx.setDouble(xbOffset, this.op.op(nbbx.getDouble(xbOffset)));
                        }
                    } else {
                        for (int i = 0; i < 8 * this.n; i += 8) {
                            nbbz.setDouble(byteOffsetZ + i, this.op.op(nbbx.getDouble(byteOffsetX + i)));
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < 8 * this.n; i += 8) {
                        int xbOffset = byteOffsetX + i * this.incrX;
                        nbbx.setDouble(xbOffset, this.op.op(nbbx.getDouble(xbOffset)));
                    }
                } else {
                    for (int i = 0; i < 8 * this.n; i += 8) {
                        nbbz.setDouble(byteOffsetZ + i * this.incrZ, this.op.op(nbbx.getDouble(byteOffsetX + i * this.incrX)));
                    }
                }
            }
        }
    }
}

