/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks.cpu.indexaccum;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Pair;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.parallel.tasks.Task;
import org.nd4j.linalg.api.parallel.tasks.cpu.indexaccum.BaseCPUIndexAccumulationTask;

public class CPUIndexAccumulationTask
extends BaseCPUIndexAccumulationTask {
    protected List<Task<Pair<Double, Integer>>> subTasks;

    public CPUIndexAccumulationTask(IndexAccumulation op, int threshold, int n, int offsetX, int offsetY, int incrX, int incrY, int elementOffset, boolean outerTask) {
        super(op, threshold, n, offsetX, offsetY, incrX, incrY, elementOffset, outerTask);
    }

    public CPUIndexAccumulationTask(IndexAccumulation op, int threshold, boolean outerTask) {
        super(op, threshold, outerTask);
    }

    public CPUIndexAccumulationTask(IndexAccumulation op, int threshold, int tadIdx, int tadDim, boolean outerTask) {
        super(op, threshold, tadIdx, tadDim, outerTask);
    }

    @Override
    public Pair<Double, Integer> blockUntilComplete() {
        Pair<Double, Integer> accum;
        if (this.future == null) {
            this.invokeAsync();
        }
        try {
            accum = (Pair<Double, Integer>)this.future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.subTasks != null) {
            accum = this.op.zeroPair();
            for (Task<Pair<Double, Integer>> task : this.subTasks) {
                Pair<Double, Integer> subAccum = task.blockUntilComplete();
                accum = this.op.combineSubResults(accum, subAccum);
            }
        }
        if (this.outerTask) {
            this.op.setFinalResult((Integer)accum.getSecond());
        }
        return accum;
    }

    @Override
    public Pair<Double, Integer> call() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nSubTasks = 1 + this.n / this.threshold;
            this.subTasks = new ArrayList<Task<Pair<Double, Integer>>>(nSubTasks);
            int taskSize = this.n / nSubTasks;
            int soFar = 0;
            for (int i = 0; i < nSubTasks; ++i) {
                int nInTask = i == nSubTasks - 1 ? this.n - soFar : taskSize;
                int offsetXNew = this.offsetX + soFar * this.incrX;
                int offsetYNew = this.offsetY + soFar * this.incrY;
                CPUIndexAccumulationTask t = new CPUIndexAccumulationTask(this.op, this.threshold, nInTask, offsetXNew, offsetYNew, this.incrX, this.incrY, this.elementOffset + soFar, false);
                t.invokeAsync();
                this.subTasks.add(t);
                soFar += nInTask;
            }
        } else {
            return this.execute();
        }
        return null;
    }

    @Override
    protected Pair<Double, Integer> compute() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nFirst = this.n / 2;
            CPUIndexAccumulationTask first = new CPUIndexAccumulationTask(this.op, this.threshold, nFirst, this.offsetX, this.offsetY, this.incrX, this.incrY, this.elementOffset, false);
            first.fork();
            int nSecond = this.n - nFirst;
            int offsetX2 = this.offsetX + nFirst * this.incrX;
            int offsetY2 = this.offsetY + nFirst * this.incrY;
            CPUIndexAccumulationTask second = new CPUIndexAccumulationTask(this.op, this.threshold, nSecond, offsetX2, offsetY2, this.incrX, this.incrY, this.elementOffset + nFirst, false);
            second.fork();
            return this.op.combineSubResults((Pair<Double, Integer>)((Pair)first.join()), (Pair<Double, Integer>)((Pair)second.join()));
        }
        return this.execute();
    }

    private Pair<Double, Integer> execute() {
        int i;
        DataBuffer y;
        DataBuffer x = this.op.x().data();
        DataBuffer dataBuffer = y = this.op.y() != null ? this.op.y().data() : null;
        if (y != null) {
            int i2;
            if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
                int i3;
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    int i4;
                    float[] xf = (float[])x.array();
                    float[] yf = (float[])y.array();
                    float accum = this.op.zeroFloat();
                    int idxAccum = -1;
                    if (this.incrX == 1 && this.incrY == 1) {
                        for (i4 = 0; i4 < this.n; ++i4) {
                            if ((idxAccum = this.op.update(accum, idxAccum, xf[this.offsetX + i4], yf[this.offsetY + i4], i4)) != i4) continue;
                            accum = this.op.op(xf[this.offsetX + i4], yf[this.offsetY + i4]);
                        }
                    } else {
                        for (i4 = 0; i4 < this.n; ++i4) {
                            if ((idxAccum = this.op.update(accum, idxAccum, xf[this.offsetX + i4 * this.incrX], yf[this.offsetY + i4 * this.incrY], i4)) != i4) continue;
                            accum = this.op.op(xf[this.offsetX + i4 * this.incrX], yf[this.offsetY + i4 * this.incrY]);
                        }
                    }
                    int finalIdx = idxAccum + this.elementOffset;
                    if (this.outerTask) {
                        this.op.setFinalResult(finalIdx);
                    }
                    return new Pair((Object)accum, (Object)finalIdx);
                }
                double[] xd = (double[])x.array();
                double[] yd = (double[])y.array();
                double accum = this.op.zeroDouble();
                int idxAccum = -1;
                if (this.incrX == 1 && this.incrY == 1) {
                    for (i3 = 0; i3 < this.n; ++i3) {
                        if ((idxAccum = this.op.update(accum, idxAccum, xd[this.offsetX + i3], yd[this.offsetY + i3], i3)) != i3) continue;
                        accum = this.op.op(xd[this.offsetX + i3], yd[this.offsetY + i3]);
                    }
                } else {
                    for (i3 = 0; i3 < this.n; ++i3) {
                        if ((idxAccum = this.op.update(accum, idxAccum, xd[this.offsetX + i3 * this.incrX], yd[this.offsetY + i3 * this.incrY], i3)) != i3) continue;
                        accum = this.op.op(xd[this.offsetX + i3 * this.incrX], yd[this.offsetY + i3 * this.incrY]);
                    }
                }
                int finalIdx = idxAccum + this.elementOffset;
                if (this.outerTask) {
                    this.op.setFinalResult(finalIdx);
                }
                return new Pair((Object)accum, (Object)finalIdx);
            }
            ByteBuf nbbx = x.asNetty();
            ByteBuf nbby = y.asNetty();
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                int i5;
                int byteOffsetX = 4 * this.offsetX;
                int byteOffsetY = 4 * this.offsetY;
                float accum = this.op.zeroFloat();
                int idxAccum = -1;
                int idx = 0;
                if (this.incrX == 1 && this.incrY == 1) {
                    i5 = 0;
                    while (i5 < 4 * this.n) {
                        float fy;
                        float fx = nbbx.getFloat(byteOffsetX + i5);
                        if ((idxAccum = this.op.update(accum, idxAccum, fx, fy = nbby.getFloat(byteOffsetY + i5), idx)) == idx) {
                            accum = this.op.op(fx, fy);
                        }
                        i5 += 4;
                        ++idx;
                    }
                } else {
                    i5 = 0;
                    while (i5 < 4 * this.n) {
                        float fy;
                        float fx = nbbx.getFloat(byteOffsetX + i5 * this.incrX);
                        if ((idxAccum = this.op.update(accum, idxAccum, fx, fy = nbby.getFloat(byteOffsetY + i5 * this.incrY), idx)) == idx) {
                            accum = this.op.op(fx, fy);
                        }
                        i5 += 4;
                        ++idx;
                    }
                }
                int finalIdx = idxAccum + this.elementOffset;
                if (this.outerTask) {
                    this.op.setFinalResult(finalIdx);
                }
                return new Pair((Object)accum, (Object)finalIdx);
            }
            int byteOffsetX = 8 * this.offsetX;
            int byteOffsetY = 8 * this.offsetY;
            double accum = this.op.zeroDouble();
            int idxAccum = -1;
            int idx = 0;
            if (this.incrX == 1 && this.incrY == 1) {
                i2 = 0;
                while (i2 < 8 * this.n) {
                    double dy;
                    double dx = nbbx.getDouble(byteOffsetX + i2);
                    if ((idxAccum = this.op.update(accum, idxAccum, dx, dy = nbby.getDouble(byteOffsetY + i2), idx)) == idx) {
                        accum = this.op.op(dx, dy);
                    }
                    i2 += 8;
                    ++idx;
                }
            } else {
                i2 = 0;
                while (i2 < 8 * this.n) {
                    double dy;
                    double dx = nbbx.getDouble(byteOffsetX + i2 * this.incrX);
                    if ((idxAccum = this.op.update(accum, idxAccum, dx, dy = nbby.getDouble(byteOffsetY + i2 * this.incrY), idx)) == idx) {
                        accum = this.op.op(dx, dy);
                    }
                    i2 += 8;
                    ++idx;
                }
            }
            int finalIdx = idxAccum + this.elementOffset;
            if (this.outerTask) {
                this.op.setFinalResult(finalIdx);
            }
            return new Pair((Object)accum, (Object)finalIdx);
        }
        if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            int i6;
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                int i7;
                float[] xf = (float[])x.array();
                float accum = this.op.zeroFloat();
                int idxAccum = -1;
                if (this.incrX == 1) {
                    for (i7 = 0; i7 < this.n; ++i7) {
                        if ((idxAccum = this.op.update(accum, idxAccum, xf[this.offsetX + i7], i7)) != i7) continue;
                        accum = this.op.op(xf[this.offsetX + i7]);
                    }
                } else {
                    for (i7 = 0; i7 < this.n; ++i7) {
                        if ((idxAccum = this.op.update(accum, idxAccum, xf[this.offsetX + i7 * this.incrX], i7)) != i7) continue;
                        accum = this.op.op(xf[this.offsetX + i7 * this.incrX]);
                    }
                }
                int finalIdx = idxAccum + this.elementOffset;
                if (this.outerTask) {
                    this.op.setFinalResult(finalIdx);
                }
                return new Pair((Object)accum, (Object)finalIdx);
            }
            double[] xd = (double[])x.array();
            double accum = this.op.zeroDouble();
            int idxAccum = -1;
            if (this.incrX == 1) {
                for (i6 = 0; i6 < this.n; ++i6) {
                    if ((idxAccum = this.op.update(accum, idxAccum, xd[this.offsetX + i6], i6)) != i6) continue;
                    accum = this.op.op(xd[this.offsetX + i6]);
                }
            } else {
                for (i6 = 0; i6 < this.n; ++i6) {
                    if ((idxAccum = this.op.update(accum, idxAccum, xd[this.offsetX + i6 * this.incrX], i6)) != i6) continue;
                    accum = this.op.op(xd[this.offsetX + i6 * this.incrX]);
                }
            }
            int finalIdx = idxAccum + this.elementOffset;
            if (this.outerTask) {
                this.op.setFinalResult(finalIdx);
            }
            return new Pair((Object)accum, (Object)finalIdx);
        }
        ByteBuf nbbx = x.asNetty();
        if (x.dataType() == DataBuffer.Type.FLOAT) {
            int i8;
            int byteOffsetX = 4 * this.offsetX;
            float accum = this.op.zeroFloat();
            int idxAccum = -1;
            int idx = 0;
            if (this.incrX == 1) {
                i8 = 0;
                while (i8 < 4 * this.n) {
                    float fx = nbbx.getFloat(byteOffsetX + i8);
                    if ((idxAccum = this.op.update(accum, idxAccum, fx, idx)) == idx) {
                        accum = this.op.op(fx);
                    }
                    i8 += 4;
                    ++idx;
                }
            } else {
                i8 = 0;
                while (i8 < 4 * this.n) {
                    float fx = nbbx.getFloat(byteOffsetX + i8 * this.incrX);
                    if ((idxAccum = this.op.update(accum, idxAccum, fx, idx)) == idx) {
                        accum = this.op.op(fx);
                    }
                    i8 += 4;
                    ++idx;
                }
            }
            int finalIdx = idxAccum + this.elementOffset;
            if (this.outerTask) {
                this.op.setFinalResult(finalIdx);
            }
            return new Pair((Object)accum, (Object)finalIdx);
        }
        int byteOffsetX = 8 * this.offsetX;
        double accum = this.op.zeroDouble();
        int idxAccum = -1;
        int idx = 0;
        if (this.incrX == 1) {
            i = 0;
            while (i < 8 * this.n) {
                double dx = nbbx.getDouble(byteOffsetX + i);
                if ((idxAccum = this.op.update(accum, idxAccum, dx, idx)) == idx) {
                    accum = this.op.op(dx);
                }
                i += 8;
                ++idx;
            }
        } else {
            i = 0;
            while (i < 8 * this.n) {
                double dx = nbbx.getDouble(byteOffsetX + i * this.incrX);
                if ((idxAccum = this.op.update(accum, idxAccum, dx, idx)) == idx) {
                    accum = this.op.op(dx);
                }
                i += 8;
                ++idx;
            }
        }
        int finalIdx = idxAccum + this.elementOffset;
        if (this.outerTask) {
            this.op.setFinalResult(finalIdx);
        }
        return new Pair((Object)accum, (Object)finalIdx);
    }
}

