/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class Norm2
extends BaseAccumulation {
    public Norm2() {
    }

    public Norm2(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Norm2(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public Norm2(INDArray x) {
        super(x);
    }

    public Norm2(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public double update(double accum, double x) {
        return accum + x * x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x * x;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x * x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x * x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.add(x * x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.add(x * x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.add(x.mul(x));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.add(x.mul(x));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.add(x.mul(x));
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    @Override
    public String name() {
        return "norm2";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Norm2(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Norm2(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Norm2(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Norm2(this.x.tensorAlongDimension(index, dimension));
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        double d = FastMath.sqrt((double)accum);
        this.finalResult = d;
        return d;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        float f = (float)FastMath.sqrt((double)accum);
        this.finalResult = Float.valueOf(f);
        return f;
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = accum.sqrt();
        return this.finalResultComplex;
    }

    @Override
    public double calculateFinalResult(double accum, int n) {
        return FastMath.sqrt((double)accum);
    }

    @Override
    public float calculateFinalResult(float accum, int n) {
        return (float)FastMath.sqrt((double)accum);
    }
}

