/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import org.nd4j.bytebuddy.shape.IndexMapper;
import org.nd4j.bytebuddy.shape.OffsetMapper;
import org.nd4j.bytebuddy.shape.ShapeMapper;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.StridePermutation;
import org.nd4j.linalg.api.shape.loop.coordinatefunction.CoordinateFunction;
import org.nd4j.linalg.api.shape.loop.four.LoopFunction4;
import org.nd4j.linalg.api.shape.loop.four.RawArrayIterationInformation4;
import org.nd4j.linalg.api.shape.loop.three.LoopFunction3;
import org.nd4j.linalg.api.shape.loop.three.RawArrayIterationInformation3;
import org.nd4j.linalg.api.shape.loop.two.CopyLoopFunction;
import org.nd4j.linalg.api.shape.loop.two.LoopFunction2;
import org.nd4j.linalg.api.shape.loop.two.RawArrayIterationInformation2;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.ShapeOffsetResolution;
import org.nd4j.linalg.util.ArrayUtil;

public class Shape {
    private static IndexMapper[] indexMappers = new IndexMapper[255];
    private static IndexMapper[] indexMappersC = new IndexMapper[255];
    private static OffsetMapper[] mappers = new OffsetMapper[255];

    public static INDArray toOffsetZero(INDArray arr) {
        if ((arr.offset() < 1 && arr.data().length() == arr.length() || arr instanceof IComplexNDArray && arr.length() * 2 == arr.data().length()) && (arr.ordering() == 'f' && arr.stride(-1) != arr.elementStride() || arr.ordering() == 'c' && arr.stride(0) != arr.elementStride())) {
            return arr;
        }
        if (arr.isRowVector()) {
            if (arr instanceof IComplexNDArray) {
                IComplexNDArray ret = Nd4j.createComplex(arr.shape());
                for (int i = 0; i < ret.length(); ++i) {
                    ret.putScalar(i, ((IComplexNDArray)arr).getComplex(i));
                }
                return ret;
            }
            INDArray ret = Nd4j.create(arr.shape());
            for (int i = 0; i < ret.length(); ++i) {
                ret.putScalar(i, arr.getDouble(i));
            }
            return ret;
        }
        if (arr instanceof IComplexNDArray) {
            IComplexNDArray ret = Nd4j.createComplex(arr.shape());
            for (int i = 0; i < ret.slices(); ++i) {
                ret.putSlice(i, arr.slice(i));
            }
            return ret;
        }
        INDArray ret = Nd4j.create(arr.shape(), arr.ordering());
        ret.assign(arr);
        return ret;
    }

    public static INDArray copyArrayWithWholeBuffer(INDArray arr) {
        return Nd4j.create(arr.data().dup(), arr.shape(), arr.stride(), arr.offset(), arr.ordering());
    }

    public static INDArray toOffsetZeroCopy(INDArray arr) {
        return Shape.toOffsetZeroCopyHelper(arr, Nd4j.order().charValue(), false);
    }

    public static INDArray toOffsetZeroCopy(INDArray arr, char order) {
        return Shape.toOffsetZeroCopyHelper(arr, order, false);
    }

    public static INDArray toOffsetZeroCopyAnyOrder(INDArray arr) {
        return Shape.toOffsetZeroCopyHelper(arr, Nd4j.order().charValue(), true);
    }

    private static INDArray toOffsetZeroCopyHelper(final INDArray arr, char order, boolean anyOrder) {
        if (arr instanceof IComplexNDArray) {
            if (arr.isRowVector()) {
                IComplexNDArray ret = Nd4j.createComplex(arr.shape(), order);
                for (int i = 0; i < ret.length(); ++i) {
                    ret.putScalar(i, ((IComplexNDArray)arr).getComplex(i));
                }
                return ret;
            }
            IComplexNDArray ret = Nd4j.createComplex(arr.shape(), order);
            for (int i = 0; i < ret.slices(); ++i) {
                ret.putSlice(i, arr.slice(i));
            }
            return ret;
        }
        if (arr.data().allocationMode() == DataBuffer.AllocationMode.HEAP && Shape.isContiguousInBuffer(arr) && Shape.strideDescendingCAscendingF(arr) && (anyOrder || order == arr.ordering())) {
            int length = arr.length();
            int offset = arr.offset();
            char outOrder = arr.ordering();
            Object array = arr.data().array();
            if (array instanceof float[]) {
                float[] orig = (float[])array;
                float[] out = new float[length];
                System.arraycopy(orig, offset, out, 0, length);
                DataBuffer floatBuffer = Nd4j.createBuffer(out);
                int[] newShape = arr.shape();
                newShape = Arrays.copyOf(newShape, newShape.length);
                int[] newStride = arr.stride();
                newStride = Arrays.copyOf(newStride, newStride.length);
                return Nd4j.create(floatBuffer, newShape, newStride, 0, arr.ordering());
            }
            if (array instanceof double[]) {
                double[] orig = (double[])array;
                double[] out = new double[length];
                System.arraycopy(orig, offset, out, 0, length);
                DataBuffer doubleBuffer = Nd4j.createBuffer(out);
                int[] newShape = arr.shape();
                newShape = Arrays.copyOf(newShape, newShape.length);
                int[] newStride = arr.stride();
                newStride = Arrays.copyOf(newStride, newStride.length);
                return Nd4j.create(doubleBuffer, newShape, newStride, 0, arr.ordering());
            }
        }
        final INDArray ret = Nd4j.create(arr.shape(), order);
        Shape.iterate(arr, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                ret.putScalar(coord[0], arr.getDouble(coord[0]));
            }
        });
        return ret;
    }

    public static INDArray toMmulCompatible(INDArray input) {
        if (input.rank() != 2) {
            throw new IllegalArgumentException("Input must be rank 2 (matrix)");
        }
        boolean doCopy = false;
        if (input.ordering() == 'c' && (input.stride(0) != input.size(1) || input.stride(1) != 1)) {
            doCopy = true;
        } else if (input.ordering() == 'f' && (input.stride(0) != 1 || input.stride(1) != input.size(0))) {
            doCopy = true;
        }
        if (doCopy) {
            return Shape.toOffsetZeroCopyAnyOrder(input);
        }
        return input;
    }

    public static double getDouble(INDArray arr, int ... indices) {
        int offset = Shape.getOffset(arr.offset(), arr.shape(), arr.stride(), indices);
        return arr.data().getDouble(offset);
    }

    public static void iterate(INDArray arr, CoordinateFunction coordinateFunction) {
        Shape.iterate(0, arr.rank(), arr.shape(), new int[arr.rank()], coordinateFunction);
    }

    public static void iterate(INDArray arr, INDArray arr2, CoordinateFunction coordinateFunction) {
        Shape.iterate(0, arr.rank(), arr.shape(), new int[arr.rank()], 0, arr2.rank(), arr2.shape(), new int[arr2.rank()], coordinateFunction);
    }

    public static void iterate(int dimension, int n, int[] size, int[] res, int dimension2, int n2, int[] size2, int[] res2, CoordinateFunction func) {
        if (dimension >= n || dimension2 >= n2) {
            func.process(res, res2);
            return;
        }
        if (size2.length != size.length) {
            if (dimension >= size.length) {
                return;
            }
            for (int i = 0; i < size[dimension] && dimension2 < size2.length; ++i) {
                int j = 0;
                while (j < size2[dimension2]) {
                    res[dimension] = i;
                    res2[dimension2] = j++;
                    Shape.iterate(dimension + 1, n, size, res, dimension2 + 1, n2, size2, res2, func);
                }
            }
        } else {
            if (dimension >= size.length) {
                return;
            }
            for (int i = 0; i < size[dimension]; ++i) {
                int j = 0;
                while (j < size2[dimension2] && dimension2 < size2.length) {
                    res[dimension] = i;
                    res2[dimension2] = j++;
                    Shape.iterate(dimension + 1, n, size, res, dimension2 + 1, n2, size2, res2, func);
                }
            }
        }
    }

    public static void iterate(int dimension, int n, int[] size, int[] res, CoordinateFunction func) {
        if (dimension >= n) {
            func.process(new int[][]{res});
            return;
        }
        int i = 0;
        while (i < size[dimension]) {
            res[dimension] = i++;
            Shape.iterate(dimension + 1, n, size, res, func);
        }
    }

    public static int[] raw2dLoop(int idim, int ndim, int[] coord, int[] shape, int dataA, int[] stridesA, int dataB, int[] stridesB, RawArrayIterationInformation2 info, LoopFunction2 loopFunction2) {
        idim = 1;
        block0: do {
            loopFunction2.perform(idim, info, info.getA(), dataA, info.getB(), dataB);
            while (idim < ndim) {
                int n = idim;
                coord[n] = coord[n] + 1;
                if (coord[n] == shape[idim]) {
                    coord[idim] = 0;
                    dataA -= (shape[idim] - 1) * stridesA[idim];
                    dataB -= (shape[idim] - 1) * stridesB[idim];
                } else {
                    dataA += stridesA[idim];
                    dataB += stridesB[idim];
                    continue block0;
                }
                --idim;
            }
        } while (idim < ndim);
        return new int[]{dataA, dataB};
    }

    public static int[] raw3dLoop(int idim, int ndim, int[] coord, int[] shape, int dataA, int[] stridesA, int dataB, int[] stridesB, int dataC, int[] stridesC, RawArrayIterationInformation3 info, LoopFunction3 loopFunction3) {
        block0: do {
            loopFunction3.perform(idim, info, info.getA(), info.getAOffset(), info.getB(), info.getBOffset(), info.getC(), info.getCOffset());
            for (idim = 1; idim < ndim; ++idim) {
                int n = idim;
                coord[n] = coord[n] + 1;
                if (coord[n] == shape[idim]) {
                    coord[idim] = 0;
                    dataA -= (shape[idim] - 1) * stridesA[idim];
                    dataB -= (shape[idim] - 1) * stridesB[idim];
                    dataC -= (shape[idim] - 1) * stridesC[idim];
                    continue;
                }
                dataA += stridesA[idim];
                dataB += stridesB[idim];
                dataC += stridesC[idim];
                continue block0;
            }
        } while (idim < ndim);
        return new int[]{dataA, dataB, dataC};
    }

    public static int[] raw4DLoop(int idim, int ndim, int[] coord, int[] shape, int dataA, int[] stridesA, int dataB, int[] stridesB, int dataC, int[] stridesC, int dataD, int[] stridesD, RawArrayIterationInformation4 info, LoopFunction4 loopFunction4) {
        block0: do {
            loopFunction4.perform(idim, info, info.getA(), info.getAOffset(), info.getB(), info.getBOffset(), info.getC(), info.getCOffset(), info.getD(), info.getDOffset());
            for (idim = 1; idim < ndim; ++idim) {
                int n = idim;
                int n2 = coord[n];
                coord[n] = n2 + 1;
                if (n2 == shape[idim]) {
                    coord[idim] = 0;
                    dataA -= (shape[idim] - 1) * stridesA[idim];
                    dataB -= (shape[idim] - 1) * stridesB[idim];
                    dataC -= (shape[idim] - 1) * stridesC[idim];
                    dataD -= (shape[idim] - 1) * stridesD[idim];
                    continue;
                }
                dataA += stridesA[idim];
                dataB += stridesB[idim];
                dataC += stridesC[idim];
                dataD += stridesD[idim];
                continue block0;
            }
        } while (idim < ndim);
        return new int[]{dataA, dataB, dataC, dataD};
    }

    public static int getOffset(int baseOffset, int[] shape, int[] stride, int ... indices) {
        int offset = baseOffset;
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] == 1) continue;
            offset += indices[i] * stride[i];
        }
        return offset;
    }

    public static int[] sizeForAxes(int[] axes, int[] shape) {
        int[] ret = new int[shape.length];
        for (int i = 0; i < axes.length; ++i) {
            ret[i] = shape[axes[i]];
        }
        return ret;
    }

    public static boolean isVector(int[] shape) {
        if (shape.length > 2 || shape.length < 1) {
            return false;
        }
        int len = ArrayUtil.prod(shape);
        return shape[0] == len || shape[1] == len;
    }

    public static boolean isMatrix(int[] shape) {
        if (shape.length != 2) {
            return false;
        }
        return !Shape.isVector(shape);
    }

    public static int[] squeeze(int[] shape) {
        if (Shape.isColumnVectorShape(shape)) {
            return shape;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] == 1) continue;
            ret.add(shape[i]);
        }
        return ArrayUtil.toArray(ret);
    }

    public static int[] nonOneDimensions(int[] dimensions, int[] shape) {
        if (dimensions.length != shape.length) {
            throw new IllegalArgumentException("Dimensions and shape must be the same length");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < dimensions.length; ++i) {
            if (shape[i] == 1) continue;
            list.add(i);
        }
        return Ints.toArray(list);
    }

    public static int[] leadingAndTrailingOnes(int[] original) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        if (!Shape.isVector(original)) {
            for (int i = 0; i < original.length; ++i) {
                if (original[i] == 1) continue;
                ints.add(original[i]);
            }
            return Ints.toArray(ints);
        }
        return original;
    }

    public static boolean shapeEquals(int[] shape1, int[] shape2) {
        if (Shape.isColumnVectorShape(shape1) && Shape.isColumnVectorShape(shape2)) {
            return Arrays.equals(shape1, shape2);
        }
        if (Shape.isRowVectorShape(shape1) && Shape.isRowVectorShape(shape2)) {
            int[] shape1Comp = Shape.squeeze(shape1);
            int[] shape2Comp = Shape.squeeze(shape2);
            return Arrays.equals(shape1Comp, shape2Comp);
        }
        return Shape.scalarEquals(shape1 = Shape.squeeze(shape1), shape2 = Shape.squeeze(shape2)) || Arrays.equals(shape1, shape2);
    }

    public static boolean scalarEquals(int[] shape1, int[] shape2) {
        return shape1.length == 0 ? shape2.length == 1 && shape2[0] == 1 : shape2.length == 0 && shape1.length == 1 && shape1[0] == 1;
    }

    public static boolean isRowVectorShape(int[] shape) {
        return shape.length == 2 && shape[0] == 1 || shape.length == 1;
    }

    public static boolean isColumnVectorShape(int[] shape) {
        return shape.length == 2 && shape[1] == 1;
    }

    public static int[] createConcatStrides(INDArray ... arrays) {
        int i0;
        int rank = arrays[0].rank();
        for (INDArray arr : arrays) {
            if (arr.rank() == rank) continue;
            throw new IllegalArgumentException("All arrays must have same rank");
        }
        int[] ret = new int[rank];
        for (i0 = 0; i0 < rank; ++i0) {
            ret[i0] = i0;
        }
        for (i0 = 1; i0 < rank; ++i0) {
            int i1;
            int ipos = i0;
            int ax_j0 = ret[i0];
            for (i1 = i0 - 1; i1 >= 0; --i1) {
                boolean ambig = true;
                boolean shouldSwap = false;
                int ax_j1 = ret[i1];
                for (int iarrays = 0; iarrays < arrays.length; ++iarrays) {
                    if (arrays[iarrays].size(ax_j0) == 1 || arrays[iarrays].size(ax_j1) == 1) continue;
                    if (Math.abs(arrays[iarrays].stride(ax_j0)) <= Math.abs(arrays[iarrays].size(ax_j1))) {
                        shouldSwap = false;
                    } else if (ambig) {
                        shouldSwap = true;
                    }
                    ambig = false;
                }
                if (ambig) continue;
                if (!shouldSwap) break;
                ipos = i1;
            }
            if (ipos == i0) continue;
            for (i1 = i0; i1 > ipos; --i1) {
                ret[i1] = ret[i1 - 1];
            }
            ret[ipos] = ax_j0;
        }
        return ret;
    }

    public static void assignArray(INDArray destination, INDArray source) {
        int[] newStrides;
        if (source.rank() > destination.rank()) {
            int[] srcShape = Arrays.copyOf(source.shape(), source.rank());
            int[] srcStrides = Arrays.copyOf(source.stride(), source.rank());
            for (int nDimTmp = source.rank(); nDimTmp > destination.rank() && srcShape[0] == 1; --nDimTmp) {
                srcShape = Arrays.copyOfRange(srcShape, 1, srcShape.length);
                srcStrides = Arrays.copyOfRange(srcStrides, 1, srcStrides.length);
            }
            newStrides = Shape.broadcastStrides(destination.rank(), destination.shape(), source.rank(), source.shape(), source.stride());
        } else {
            newStrides = Shape.broadcastStrides(destination.rank(), destination.shape(), source.rank(), source.shape(), source.stride());
        }
        RawArrayIterationInformation2 rawIter = RawArrayIterationInformation2.builder().nDim(destination.rank()).shape(destination.shape()).a(destination.data()).aStrides(destination.stride()).b(source.data()).bStrides(newStrides).aOffset(destination.offset()).bOffset(source.offset()).build().computeOut();
        int[] offsets = new int[2];
        int[] coords = new int[rawIter.getNDim()];
        Shape.raw2dLoop(0, rawIter.getNDim(), coords, rawIter.getShape(), offsets[0], rawIter.getAStrides(), offsets[1], rawIter.getBStrides(), rawIter, new CopyLoopFunction());
    }

    public static int[] broadcastStrides(int nDim, int[] shape, int numStrideDimensions, int[] strideShape, int[] strides) {
        int iDimStart = nDim - numStrideDimensions;
        if (iDimStart < 0) {
            throw new IllegalStateException("Can't broadcast to fewer dimensions");
        }
        int[] newStrides = new int[numStrideDimensions];
        for (int iDim = nDim - 1; iDim >= iDimStart; --iDim) {
            int currShape = strideShape[iDim - iDimStart];
            if (currShape == 1) {
                newStrides[iDim] = 0;
                continue;
            }
            if (currShape != shape[iDim] && !Shape.isVector(strideShape) && !Shape.isVector(shape)) {
                throw new IllegalStateException("Current shape and shape i must match");
            }
            newStrides[iDim] = strides[iDim - iDimStart];
        }
        return newStrides;
    }

    public static RawArrayIterationInformation2 prepareTwoRawArrayIter(INDArray dst, INDArray src) {
        return RawArrayIterationInformation2.builder().aOffset(dst.offset()).a(dst.data()).b(src.data()).bOffset(src.offset()).aStrides(dst.stride()).bStrides(src.stride()).nDim(dst.rank()).shape(dst.shape()).build().computeOut();
    }

    public static StridePermutation[] createSortedStrides(int[] strides) {
        Object[] perm = StridePermutation.create(strides);
        Arrays.sort(perm);
        return perm;
    }

    public static INDArray newShapeNoCopy(INDArray arr, int[] newShape, boolean isFOrder) {
        int nk;
        int ni;
        int oi;
        int[] olddims = ArrayUtil.copy(arr.shape());
        int[] oldstrides = ArrayUtil.copy(arr.stride());
        int[] newStrides = new int[newShape.length];
        int oldnd = 0;
        for (oi = 0; oi < arr.rank(); ++oi) {
            if (arr.size(oi) == 1) continue;
            olddims[oldnd] = arr.size(oi);
            oldstrides[oldnd] = arr.stride(oi);
            ++oldnd;
        }
        int np = 1;
        for (ni = 0; ni < newShape.length; ++ni) {
            np *= newShape[ni];
        }
        int op = 1;
        for (oi = 0; oi < oldnd; ++oi) {
            op *= olddims[oi];
        }
        if (np != op) {
            return null;
        }
        if (np == 0) {
            return null;
        }
        oi = 0;
        int oj = 1;
        ni = 0;
        int nj = 1;
        while (ni < newShape.length && oi < oldnd) {
            np = newShape[ni];
            op = olddims[oi];
            while (np != op) {
                if (np < op) {
                    np *= newShape[nj++];
                    continue;
                }
                op *= olddims[oj++];
            }
            for (int ok = oi; ok < oj - 1; ++ok) {
                if (!(isFOrder ? oldstrides[ok + 1] != olddims[ok] * oldstrides[ok] : oldstrides[ok] != olddims[ok + 1] * oldstrides[ok + 1])) continue;
                return null;
            }
            if (isFOrder) {
                newStrides[ni] = oldstrides[oi];
                for (nk = ni + 1; nk < nj; ++nk) {
                    newStrides[nk] = newStrides[nk - 1] * newShape[nk - 1];
                }
            } else {
                newStrides[nj - 1] = oldstrides[oj - 1];
                for (nk = nj - 1; nk > ni; --nk) {
                    newStrides[nk - 1] = newStrides[nk] * newShape[nk];
                }
            }
            ni = nj++;
            oi = oj++;
        }
        int last_stride = ni >= 1 ? newStrides[ni - 1] : arr.elementStride();
        if (isFOrder && ni >= 1) {
            last_stride *= newShape[ni - 1];
        }
        for (nk = ni; nk < newShape.length; ++nk) {
            newStrides[nk] = last_stride;
        }
        if (arr instanceof IComplexNDArray) {
            return Nd4j.createComplex(arr.data(), newShape, newStrides, arr.offset());
        }
        return Nd4j.create(arr.data(), newShape, newStrides, arr.offset());
    }

    public static boolean cOrFortranOrder(int[] shape, int[] stride, int elementStride) {
        int dim;
        int i;
        boolean cContiguous = true;
        boolean isFortran = true;
        int sd = 1;
        for (i = shape.length - 1; i >= 0; --i) {
            dim = shape[i];
            if (stride[i] != sd) {
                cContiguous = false;
                break;
            }
            if (dim == 0) break;
            sd *= dim;
        }
        sd = elementStride;
        for (i = 0; i < shape.length; ++i) {
            dim = shape[i];
            if (stride[i] != sd) {
                isFortran = false;
            }
            if (dim == 0) break;
            sd *= dim;
        }
        return cContiguous || isFortran;
    }

    public static char getOrder(int[] shape, int[] stride, int elementStride) {
        int dim;
        int i;
        boolean cContiguous = true;
        boolean isFortran = true;
        int sd = 1;
        for (i = shape.length - 1; i >= 0; --i) {
            dim = shape[i];
            if (stride[i] != sd) {
                cContiguous = false;
                break;
            }
            if (dim == 0) break;
            sd *= dim;
        }
        sd = elementStride;
        for (i = 0; i < shape.length; ++i) {
            dim = shape[i];
            if (stride[i] != sd) {
                isFortran = false;
            }
            if (dim == 0) break;
            sd *= dim;
        }
        if (isFortran && cContiguous) {
            return 'a';
        }
        if (isFortran && !cContiguous) {
            return 'f';
        }
        if (!isFortran && !cContiguous) {
            return 'c';
        }
        return 'c';
    }

    public static char getOrder(INDArray arr) {
        return Shape.getOrder(arr.shape(), arr.stride(), arr.elementStride());
    }

    public static int sub2Ind(int[] shape, int[] indices) {
        int index = 0;
        int shift = 1;
        for (int i = 0; i < shape.length; ++i) {
            index += shift * indices[i];
            shift *= shape[i];
        }
        return index;
    }

    public static int[] ind2sub(int[] shape, int index, int numIndices) {
        IndexMapper mapper = indexMappers[shape.length];
        return mapper.ind2sub(shape, index, numIndices, 'f');
    }

    public static int[] ind2sub(int[] shape, int index) {
        return Shape.ind2sub(shape, index, ArrayUtil.prod(shape));
    }

    public static int[] ind2sub(INDArray arr, int index) {
        return Shape.ind2sub(arr.shape(), index, ArrayUtil.prod(arr.shape()));
    }

    public static int[] ind2subC(int[] shape, int index, int numIndices) {
        IndexMapper mapper = indexMappersC[shape.length];
        return mapper.ind2sub(shape, index, numIndices, 'c');
    }

    public static boolean opIsWholeBufferWithMatchingStrides(Op op) {
        if (op.y() != null) {
            return op.x().offset() == 0 && op.n() == op.x().data().length() && op.y().offset() == 0 && op.y().data().length() == op.n() && op.z().offset() == 0 && op.z().offset() == 0 && op.z().data().length() == op.n() && Arrays.equals(op.x().stride(), op.y().stride()) && Arrays.equals(op.x().stride(), op.z().stride()) && !(op.x() instanceof IComplexNDArray) && !(op.y() instanceof IComplexNDArray);
        }
        return op.x().offset() == 0 && op.n() == op.x().data().length() && op.z().offset() == 0 && op.z().offset() == 0 && op.z().data().length() == op.n() && Arrays.equals(op.x().stride(), op.z().stride()) && !(op.x() instanceof IComplexNDArray) && !(op.y() instanceof IComplexNDArray);
    }

    public static boolean opIsWithMatchingStrides(Op op) {
        if (op.y() != null) {
            return op.x().offset() == 0 && op.n() == op.x().data().length() && op.y().offset() == 0 && op.z().offset() == 0 && op.z().offset() == 0 && Arrays.equals(op.x().stride(), op.y().stride()) && Arrays.equals(op.x().stride(), op.z().stride()) && !(op.x() instanceof IComplexNDArray) && !(op.y() instanceof IComplexNDArray);
        }
        return op.x().offset() == 0 && op.z().offset() == 0 && op.z().offset() == 0 && Arrays.equals(op.x().stride(), op.z().stride()) && !(op.x() instanceof IComplexNDArray) && !(op.y() instanceof IComplexNDArray);
    }

    public static int[] ind2subC(int[] shape, int index) {
        return Shape.ind2subC(shape, index, ArrayUtil.prod(shape));
    }

    public static int[] ind2subC(INDArray arr, int index) {
        return Shape.ind2subC(arr.shape(), index, ArrayUtil.prod(arr.shape()));
    }

    public static int offsetFor(INDArray arr, int[] indexes) {
        ShapeOffsetResolution resolution = new ShapeOffsetResolution(arr);
        resolution.exec(Shape.toIndexes(indexes));
        return resolution.getOffset();
    }

    public static int offsetFor(INDArray arr, int index) {
        int[] indexes = arr.ordering() == 'c' ? Shape.ind2subC(arr, index) : Shape.ind2sub(arr, index);
        return Shape.offsetFor(arr, indexes);
    }

    public static void assertShapeLessThan(int[] shape, int[] lessThan) {
        if (shape.length != lessThan.length) {
            throw new IllegalArgumentException("Shape length must be == less than length");
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] < lessThan[i]) continue;
            throw new IllegalStateException("Shape[" + i + "] should be less than lessThan[" + i + "]");
        }
    }

    public static int[] moveOnesToEnd(int[] shape) {
        ArrayList<Integer> nonOnes = new ArrayList<Integer>();
        ArrayList<Integer> ones = new ArrayList<Integer>();
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] == 1) {
                ones.add(i);
                continue;
            }
            nonOnes.add(i);
        }
        return Ints.concat((int[][])new int[][]{Ints.toArray(nonOnes), Ints.toArray(ones)});
    }

    public static INDArrayIndex[] toIndexes(int[] indices) {
        INDArrayIndex[] ret = new INDArrayIndex[indices.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new NDArrayIndex(indices[i]);
        }
        return ret;
    }

    public static int[] newStrides(int[] strides, int newLength, INDArrayIndex[] indexes) {
        if (strides.length > newLength) {
            int[] newStrides = new int[strides.length - 1];
            for (int i = 0; i < newStrides.length; ++i) {
                newStrides[i] = strides[i + 1];
            }
            strides = newStrides;
        }
        return strides;
    }

    public static int[] newOffsets(int[] offsets, int newLength, INDArrayIndex[] indexes) {
        if (offsets.length > newLength) {
            int[] newOffsets = new int[offsets.length - 1];
            for (int i = 0; i < newOffsets.length; ++i) {
                newOffsets[i] = offsets[i + 1];
            }
            offsets = newOffsets;
        }
        return offsets;
    }

    public static int[] squeezeOffsets(int[] shape, int[] offsets) {
        ArrayList<Integer> squeezeIndices = new ArrayList<Integer>();
        for (int i = 0; i < shape.length; ++i) {
            if (offsets[i] != 0) continue;
            squeezeIndices.add(i);
        }
        int[] ret = ArrayUtil.removeIndex(offsets, Ints.toArray(squeezeIndices));
        int delta = Math.abs(ret.length - shape.length);
        if (delta == 0) {
            return ret;
        }
        if (ret.length > shape.length) {
            throw new IllegalStateException("Unable to squeeze offsets");
        }
        int[] retOffsets = new int[shape.length];
        System.arraycopy(ret, 0, retOffsets, 0, ret.length);
        return retOffsets;
    }

    public static boolean squeezeEquals(int[] test1, int[] test2) {
        int[] s2;
        int[] s1 = Shape.squeeze(test1);
        return Shape.scalarEquals(s1, s2 = Shape.squeeze(test2)) || Arrays.equals(s1, s2);
    }

    public static boolean strideDescendingCAscendingF(INDArray array) {
        int[] strides = array.stride();
        if (array.isVector() && strides[0] == 1 && strides[1] == 1) {
            return true;
        }
        char order = array.ordering();
        if (order == 'c') {
            for (int i = 1; i < strides.length; ++i) {
                if (strides[i - 1] > strides[i]) continue;
                return false;
            }
            return true;
        }
        if (order == 'f') {
            for (int i = 1; i < strides.length; ++i) {
                if (strides[i - 1] < strides[i]) continue;
                return false;
            }
            return true;
        }
        if (order == 'a') {
            return true;
        }
        throw new RuntimeException("Invalid order: not c or f (is: " + order + ")");
    }

    public static boolean isContiguousInBuffer(INDArray in) {
        int[] stridesIfContiguous;
        int dLength;
        int length = in.length();
        if (length == (dLength = in.data().length())) {
            return true;
        }
        char order = in.ordering();
        int[] shape = in.shape();
        if (order == 'f') {
            stridesIfContiguous = ArrayUtil.calcStridesFortran(shape);
        } else if (order == 'c') {
            stridesIfContiguous = ArrayUtil.calcStrides(shape);
        } else {
            throw new RuntimeException("Invalid order");
        }
        return Arrays.equals(in.stride(), stridesIfContiguous);
    }

    static {
        for (int i = 0; i < 255; ++i) {
            Shape.indexMappersC[i] = ShapeMapper.getInd2SubInstance((char)'c', (int)i);
            Shape.indexMappers[i] = ShapeMapper.getInd2SubInstance((char)'f', (int)i);
            Shape.mappers[i] = ShapeMapper.getOffsetMapperInstance((int)i);
        }
    }
}

