/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.iter;

import java.io.Serializable;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.util.ArrayUtil;

public class LinearIndexLookup
implements Serializable {
    private char ordering;
    private int[][] indexes;
    private int[] shape;
    private boolean[] exists;
    private int numIndexes;

    public LinearIndexLookup(int[] shape, char ordering) {
        this.shape = shape;
        this.ordering = ordering;
        this.numIndexes = ArrayUtil.prod(shape);
        this.indexes = new int[this.numIndexes][shape.length];
        this.exists = new boolean[this.numIndexes];
    }

    public int[] lookup(int index) {
        if (this.exists[index]) {
            return this.indexes[index];
        }
        this.exists[index] = true;
        this.indexes[index] = this.ordering == 'c' ? Shape.ind2subC(this.shape, index, this.numIndexes) : Shape.ind2sub(this.shape, index, this.numIndexes);
        return this.indexes[index];
    }
}

