/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape.loop.two;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.StridePermutation;
import org.nd4j.linalg.util.ArrayUtil;

public class RawArrayIterationInformation2
implements Serializable {
    private int nDim;
    private int aOffset = -1;
    private int bOffset = -1;
    private int[] aStrides;
    private int[] bStrides;
    private int[] shape;
    private DataBuffer a;
    private DataBuffer b;

    public RawArrayIterationInformation2 computeOut() {
        int i;
        int aOffset = this.aOffset;
        int bOffset = this.bOffset;
        int[] aStrides = ArrayUtil.copy(this.aStrides);
        int[] bStrides = ArrayUtil.copy(this.bStrides);
        int[] shape = ArrayUtil.copy(this.shape);
        int nDim = this.nDim;
        StridePermutation[] perms = Shape.createSortedStrides(aStrides);
        for (i = 0; i < nDim; ++i) {
            int iPerm = perms[nDim - i - 1].getPermutation();
            shape[i] = this.shape[iPerm];
            aStrides[i] = aStrides[iPerm];
            bStrides[i] = bStrides[iPerm];
        }
        for (i = 0; i < nDim; ++i) {
            int outStrideA = aStrides[i];
            int outStrideB = bStrides[i];
            int shapeI = shape[i];
            if (outStrideA >= 0) continue;
            aOffset += outStrideA * shapeI - 1;
            bOffset += outStrideB * shapeI - 1;
            int n = i;
            aStrides[n] = aStrides[n] - outStrideA;
            int n2 = i;
            bStrides[n2] = bStrides[n2] - outStrideB;
        }
        i = 0;
        for (int j = 1; j < nDim; ++j) {
            if (shape[i] == 1) {
                shape[i] = shape[j];
                aStrides[i] = aStrides[j];
                bStrides[i] = aStrides[j];
                continue;
            }
            if (shape[j] == 1) continue;
            if (aStrides[i] * shape[i] == aStrides[j] && bStrides[i] * shape[i] == bStrides[j]) {
                int n = i;
                shape[n] = shape[n] * shape[j];
                continue;
            }
            shape[++i] = shape[j];
            aStrides[i] = aStrides[j];
            bStrides[i] = bStrides[j];
        }
        nDim = i + 1;
        if (nDim == 1) {
            nDim = 2;
            shape = this.shape;
            aStrides = this.aStrides;
            bStrides = this.bStrides;
        }
        return RawArrayIterationInformation2.builder().aOffset(aOffset).a(this.a).b(this.b).bOffset(bOffset).aStrides(aStrides).bStrides(bStrides).shape(shape).nDim(nDim).build();
    }

    public static RawArrayIterationInformation2Builder builder() {
        return new RawArrayIterationInformation2Builder();
    }

    public int getNDim() {
        return this.nDim;
    }

    public int getAOffset() {
        return this.aOffset;
    }

    public int getBOffset() {
        return this.bOffset;
    }

    public int[] getAStrides() {
        return this.aStrides;
    }

    public int[] getBStrides() {
        return this.bStrides;
    }

    public int[] getShape() {
        return this.shape;
    }

    public DataBuffer getA() {
        return this.a;
    }

    public DataBuffer getB() {
        return this.b;
    }

    public void setNDim(int nDim) {
        this.nDim = nDim;
    }

    public void setAOffset(int aOffset) {
        this.aOffset = aOffset;
    }

    public void setBOffset(int bOffset) {
        this.bOffset = bOffset;
    }

    public void setAStrides(int[] aStrides) {
        this.aStrides = aStrides;
    }

    public void setBStrides(int[] bStrides) {
        this.bStrides = bStrides;
    }

    public void setShape(int[] shape) {
        this.shape = shape;
    }

    public void setA(DataBuffer a) {
        this.a = a;
    }

    public void setB(DataBuffer b) {
        this.b = b;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawArrayIterationInformation2)) {
            return false;
        }
        RawArrayIterationInformation2 other = (RawArrayIterationInformation2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNDim() != other.getNDim()) {
            return false;
        }
        if (this.getAOffset() != other.getAOffset()) {
            return false;
        }
        if (this.getBOffset() != other.getBOffset()) {
            return false;
        }
        if (!Arrays.equals(this.getAStrides(), other.getAStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getBStrides(), other.getBStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), other.getShape())) {
            return false;
        }
        DataBuffer this$a = this.getA();
        DataBuffer other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        DataBuffer this$b = this.getB();
        DataBuffer other$b = other.getB();
        return !(this$b == null ? other$b != null : !this$b.equals(other$b));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawArrayIterationInformation2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNDim();
        result = result * 59 + this.getAOffset();
        result = result * 59 + this.getBOffset();
        result = result * 59 + Arrays.hashCode(this.getAStrides());
        result = result * 59 + Arrays.hashCode(this.getBStrides());
        result = result * 59 + Arrays.hashCode(this.getShape());
        DataBuffer $a = this.getA();
        result = result * 59 + ($a == null ? 0 : $a.hashCode());
        DataBuffer $b = this.getB();
        result = result * 59 + ($b == null ? 0 : $b.hashCode());
        return result;
    }

    public String toString() {
        return "RawArrayIterationInformation2(nDim=" + this.getNDim() + ", aOffset=" + this.getAOffset() + ", bOffset=" + this.getBOffset() + ", aStrides=" + Arrays.toString(this.getAStrides()) + ", bStrides=" + Arrays.toString(this.getBStrides()) + ", shape=" + Arrays.toString(this.getShape()) + ", a=" + this.getA() + ", b=" + this.getB() + ")";
    }

    @ConstructorProperties(value={"nDim", "aOffset", "bOffset", "aStrides", "bStrides", "shape", "a", "b"})
    public RawArrayIterationInformation2(int nDim, int aOffset, int bOffset, int[] aStrides, int[] bStrides, int[] shape, DataBuffer a, DataBuffer b) {
        this.nDim = nDim;
        this.aOffset = aOffset;
        this.bOffset = bOffset;
        this.aStrides = aStrides;
        this.bStrides = bStrides;
        this.shape = shape;
        this.a = a;
        this.b = b;
    }

    public RawArrayIterationInformation2() {
    }

    public static class RawArrayIterationInformation2Builder {
        private int nDim;
        private int aOffset;
        private int bOffset;
        private int[] aStrides;
        private int[] bStrides;
        private int[] shape;
        private DataBuffer a;
        private DataBuffer b;

        RawArrayIterationInformation2Builder() {
        }

        public RawArrayIterationInformation2Builder nDim(int nDim) {
            this.nDim = nDim;
            return this;
        }

        public RawArrayIterationInformation2Builder aOffset(int aOffset) {
            this.aOffset = aOffset;
            return this;
        }

        public RawArrayIterationInformation2Builder bOffset(int bOffset) {
            this.bOffset = bOffset;
            return this;
        }

        public RawArrayIterationInformation2Builder aStrides(int[] aStrides) {
            this.aStrides = aStrides;
            return this;
        }

        public RawArrayIterationInformation2Builder bStrides(int[] bStrides) {
            this.bStrides = bStrides;
            return this;
        }

        public RawArrayIterationInformation2Builder shape(int[] shape) {
            this.shape = shape;
            return this;
        }

        public RawArrayIterationInformation2Builder a(DataBuffer a) {
            this.a = a;
            return this;
        }

        public RawArrayIterationInformation2Builder b(DataBuffer b) {
            this.b = b;
            return this;
        }

        public RawArrayIterationInformation2 build() {
            return new RawArrayIterationInformation2(this.nDim, this.aOffset, this.bOffset, this.aStrides, this.bStrides, this.shape, this.a, this.b);
        }

        public String toString() {
            return "RawArrayIterationInformation2.RawArrayIterationInformation2Builder(nDim=" + this.nDim + ", aOffset=" + this.aOffset + ", bOffset=" + this.bOffset + ", aStrides=" + Arrays.toString(this.aStrides) + ", bStrides=" + Arrays.toString(this.bStrides) + ", shape=" + Arrays.toString(this.shape) + ", a=" + this.a + ", b=" + this.b + ")";
        }
    }
}

