/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Sign
extends BaseTransformOp {
    public Sign() {
    }

    public Sign(INDArray x, INDArray z) {
        super(x, z);
    }

    public Sign(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public Sign(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Sign(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "sign";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return this.sign(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return this.sign(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return this.sign(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)this.sign(origin);
    }

    @Override
    public double op(double origin, double other) {
        return this.sign(origin);
    }

    @Override
    public double op(double origin) {
        return this.sign(origin);
    }

    @Override
    public float op(float origin) {
        return (float)this.sign(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return this.sign(origin);
    }

    private double sign(double n) {
        if (n < 0.0) {
            return -1.0;
        }
        if (n > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    private IComplexNumber sign(IComplexNumber n) {
        if (n.realComponent().doubleValue() > 0.0) {
            return Nd4j.createDouble(1.0, 0.0);
        }
        if (n.realComponent().doubleValue() < 0.0) {
            return Nd4j.createDouble(-1.0, 0.0);
        }
        return Nd4j.createDouble(0.0, 0.0);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sign(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sign(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sign(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sign(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

