/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.api.ops.Op;

public class ScalarMultiplication
extends BaseScalarOp {
    public ScalarMultiplication() {
    }

    public ScalarMultiplication(INDArray x, INDArray y, INDArray z, int n, Number num) {
        super(x, y, z, n, num);
    }

    public ScalarMultiplication(INDArray x, Number num) {
        super(x, num);
    }

    public ScalarMultiplication(INDArray x, INDArray y, INDArray z, int n, IComplexNumber num) {
        super(x, y, z, n, num);
    }

    public ScalarMultiplication(INDArray x) {
        this(x, 0);
    }

    public ScalarMultiplication(INDArray x, IComplexNumber num) {
        super(x, num);
    }

    @Override
    public String name() {
        return "mul_scalar";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (this.complexNumber != null) {
            return origin.mul(this.complexNumber);
        }
        return this.complexNumber.mul(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (this.complexNumber != null) {
            return origin.mul(this.complexNumber);
        }
        return this.complexNumber.mul(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        if (this.complexNumber != null) {
            return origin.mul(this.complexNumber);
        }
        return this.complexNumber.mul(this.num);
    }

    @Override
    public float op(float origin, float other) {
        return origin * this.num.floatValue();
    }

    @Override
    public double op(double origin, double other) {
        return origin * this.num.doubleValue();
    }

    @Override
    public double op(double origin) {
        return origin * this.num.doubleValue();
    }

    @Override
    public float op(float origin) {
        return origin * this.num.floatValue();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        if (this.complexNumber != null) {
            return origin.mul(this.complexNumber);
        }
        return this.complexNumber.mul(this.num);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.num != null) {
            return new ScalarMultiplication(this.x.vectorAlongDimension(index, dimension), this.num);
        }
        return new ScalarMultiplication(this.x.vectorAlongDimension(index, dimension), this.complexNumber);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        if (this.num != null) {
            return new ScalarMultiplication(this.x.tensorAlongDimension(index, dimension), this.num);
        }
        return new ScalarMultiplication(this.x.tensorAlongDimension(index, dimension), this.complexNumber);
    }
}

