/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset;

import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class ViewIterator
implements DataSetIterator {
    private int batchSize = -1;
    private int cursor = 0;
    private DataSet data;
    private DataSetPreProcessor preProcessor;

    public ViewIterator(DataSet data, int batchSize) {
        this.batchSize = batchSize;
        this.data = data;
    }

    @Override
    public DataSet next(int num) {
        throw new UnsupportedOperationException("Only allowed to retrieve dataset based on batch size");
    }

    @Override
    public int totalExamples() {
        return this.data.numExamples();
    }

    @Override
    public int inputColumns() {
        return this.data.numInputs();
    }

    @Override
    public int totalOutcomes() {
        return this.data.numOutcomes();
    }

    @Override
    public void reset() {
        this.cursor = 0;
    }

    @Override
    public int batch() {
        return this.batchSize;
    }

    @Override
    public int cursor() {
        return this.cursor;
    }

    @Override
    public int numExamples() {
        return this.data.numExamples();
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.numExamples();
    }

    @Override
    public void remove() {
    }

    @Override
    public DataSet next() {
        if (this.cursor + this.batch() > this.numExamples()) {
            this.cursor = this.cursor() + this.batch() - this.numExamples();
        }
        DataSet next = (DataSet)this.data.getRange(this.cursor, this.cursor + this.batch());
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(next);
        }
        this.cursor += this.batch();
        return next;
    }
}

