/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;

public class ExistingMiniBatchDataSetIterator
implements DataSetIterator {
    private List<String[]> paths;
    private int currIdx;
    private File rootDir;
    private int totalBatches = -1;
    private DataSetPreProcessor dataSetPreProcessor;

    public ExistingMiniBatchDataSetIterator(File rootDir) {
        this.rootDir = rootDir;
        this.paths = new ArrayList<String[]>();
        HashSet<String> dataUUIDs = new HashSet<String>();
        for (File f : rootDir.listFiles()) {
            dataUUIDs.add(f.getName().replace(".labels.bin", "").replace(".bin", ""));
        }
        for (String uuid : dataUUIDs) {
            this.paths.add(new String[]{new File(rootDir, uuid + ".bin").getAbsolutePath(), new File(rootDir, uuid + ".labels.bin").getAbsolutePath()});
        }
    }

    @Override
    public DataSet next(int num) {
        throw new UnsupportedOperationException("Unable to load custom number of examples");
    }

    @Override
    public int totalExamples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int inputColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int totalOutcomes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.currIdx = 0;
    }

    @Override
    public int batch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int cursor() {
        return this.currIdx;
    }

    @Override
    public int numExamples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.dataSetPreProcessor = preProcessor;
    }

    @Override
    public boolean hasNext() {
        return this.currIdx < this.totalBatches;
    }

    @Override
    public void remove() {
    }

    @Override
    public DataSet next() {
        try {
            DataSet ret = this.read(this.currIdx);
            if (this.dataSetPreProcessor != null) {
                this.dataSetPreProcessor.preProcess(ret);
            }
            ++this.currIdx;
            return ret;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read dataset");
        }
    }

    private DataSet read(int idx) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.paths.get(idx)[0]));
        DataInputStream dis = new DataInputStream(bis);
        BufferedInputStream labelInputStream = new BufferedInputStream(new FileInputStream(this.paths.get(idx)[1]));
        DataInputStream labelDis = new DataInputStream(labelInputStream);
        DataSet d = new DataSet(Nd4j.read(dis), Nd4j.read(labelDis));
        dis.close();
        labelDis.close();
        return d;
    }
}

