/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.HashSet;
import java.util.Set;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class LinearIndex
extends BaseTransformOp {
    private int internalCount = 0;
    private int[] indices;
    private boolean wholeArray = false;
    private Set<Integer> encountered = new HashSet<Integer>();

    public LinearIndex() {
    }

    public LinearIndex(INDArray x) {
        this(x, true);
    }

    public LinearIndex(INDArray x, INDArray z, boolean wholeArray) {
        super(x, z);
        this.wholeArray = wholeArray;
        this.initIndexesIfNecessary();
    }

    public LinearIndex(INDArray x, INDArray z, int n, boolean wholeArray) {
        super(x, z, n);
        this.wholeArray = wholeArray;
        this.initIndexesIfNecessary();
    }

    public LinearIndex(INDArray x, INDArray y, INDArray z, int n, boolean wholeArray) {
        super(x, y, z, n);
        this.wholeArray = wholeArray;
        this.initIndexesIfNecessary();
    }

    public LinearIndex(INDArray x, boolean wholeArray) {
        super(x);
        this.wholeArray = wholeArray;
        this.initIndexesIfNecessary();
    }

    @Override
    public String name() {
        return "linearindex";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        this.addToIndex();
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        this.addToIndex();
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        this.addToIndex();
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        this.addToIndex();
        return origin;
    }

    @Override
    public double op(double origin, double other) {
        this.addToIndex();
        return origin;
    }

    @Override
    public double op(double origin) {
        this.addToIndex();
        return origin;
    }

    @Override
    public float op(float origin) {
        this.addToIndex();
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        this.addToIndex();
        return origin;
    }

    private void addToIndex() {
        if (!this.wholeArray) {
            return;
        }
        int idx = this.getLinearIndex();
        if (this.encountered.contains(idx)) {
            throw new IllegalStateException("Please checking striding. Index: " + idx + " already encountered ");
        }
        this.encountered.add(idx);
        this.indices[this.internalCount] = idx;
        ++this.internalCount;
        ++this.numProcessed;
    }

    private int getLinearIndex() {
        return this.x.linearIndex(this.numProcessed);
    }

    private void initIndexesIfNecessary() {
        if (this.wholeArray) {
            this.indices = new int[this.x.length()];
        }
    }

    public int[] getIndices() {
        return this.indices;
    }

    @Override
    public void exec() {
        for (int i = 0; i < this.x.length(); ++i) {
            this.addToIndex();
        }
    }

    @Override
    public boolean isPassThrough() {
        return true;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LinearIndex(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), false);
        }
        return new LinearIndex(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.x.length(), false);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LinearIndex(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), false);
        }
        return new LinearIndex(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.x.length(), false);
    }
}

